/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.ICSharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CSharedLibrary;
import org.eclipse.debug.core.DebugException;

public class CSharedLibraryManager
implements ICSharedLibraryManager {
    private CDebugTarget fDebugTarget;
    private ArrayList fSharedLibraries;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CSharedLibraryManager(CDebugTarget target) {
        this.fDebugTarget = target;
        this.fSharedLibraries = new ArrayList(5);
    }

    public void sharedLibraryLoaded(ICDISharedLibrary cdiLibrary) {
        CSharedLibrary library = new CSharedLibrary(this.getDebugTarget(), cdiLibrary);
        ArrayList arrayList = this.fSharedLibraries;
        synchronized (arrayList) {
            this.fSharedLibraries.add(library);
        }
        library.fireCreationEvent();
    }

    public synchronized void sharedLibraryUnloaded(ICDISharedLibrary cdiLibrary) {
        CSharedLibrary library = this.find(cdiLibrary);
        if (library != null) {
            ArrayList arrayList = this.fSharedLibraries;
            synchronized (arrayList) {
                this.fSharedLibraries.remove(library);
            }
            library.dispose();
            library.fireTerminateEvent();
        }
    }

    public void symbolsLoaded(ICDISharedLibrary cdiLibrary) {
        CSharedLibrary library = this.find(cdiLibrary);
        if (library != null) {
            library.fireChangeEvent(256);
        }
    }

    public ICSharedLibrary[] getSharedLibraries() {
        return this.fSharedLibraries.toArray(new ICSharedLibrary[this.fSharedLibraries.size()]);
    }

    public void dispose() {
        Iterator it = this.fSharedLibraries.iterator();
        while (it.hasNext()) {
            ((CSharedLibrary)it.next()).dispose();
        }
        this.fSharedLibraries.clear();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICSharedLibraryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.CSharedLibraryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this;
        }
        return null;
    }

    protected CSharedLibrary find(ICDISharedLibrary cdiLibrary) {
        Iterator it = this.fSharedLibraries.iterator();
        while (it.hasNext()) {
            CSharedLibrary library = (CSharedLibrary)it.next();
            if (!library.getCDISharedLibrary().equals(cdiLibrary)) continue;
            return library;
        }
        return null;
    }

    public void loadSymbols(ICSharedLibrary[] libraries) throws DebugException {
        int i = 0;
        while (i < libraries.length) {
            try {
                ((CSharedLibrary)libraries[i]).getCDISharedLibrary().loadSymbols();
            }
            catch (CDIException e) {
                CDebugElement.targetRequestFailed(e.getMessage(), null);
            }
            ++i;
        }
    }

    public void loadSymbolsForAll() throws DebugException {
        ICDITarget target = this.getDebugTarget().getCDITarget();
        try {
            ICDISharedLibrary[] libraries = target.getSharedLibraries();
            int i = 0;
            while (i < libraries.length) {
                libraries[i].loadSymbols();
                ++i;
            }
        }
        catch (CDIException e) {
            CDebugElement.targetRequestFailed(e.getMessage(), null);
        }
    }

    protected CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }
}

