/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.core.model.CVariableFormat;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.AbstractCValue;
import org.eclipse.cdt.debug.internal.core.model.AbstractCVariable;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CType;
import org.eclipse.cdt.debug.internal.core.model.CValueFactory;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public class CVariable
extends AbstractCVariable
implements ICDIEventListener {
    private boolean fIsEnabled = true;
    private InternalVariable fOriginal;
    private InternalVariable fShadow;
    private String fName;
    private CVariableFormat fFormat = CVariableFormat.getFormat(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT));

    protected CVariable(CDebugElement parent, ICDIVariableDescriptor cdiVariableObject) {
        super(parent);
        if (cdiVariableObject != null) {
            this.fName = cdiVariableObject.getName();
            this.createOriginal(cdiVariableObject);
        }
        this.fIsEnabled = !this.isBookkeepingEnabled();
        this.getCDISession().getEventManager().addEventListener(this);
    }

    protected CVariable(CDebugElement parent, ICDIVariableDescriptor cdiVariableObject, String errorMessage) {
        super(parent);
        if (cdiVariableObject != null) {
            this.fName = cdiVariableObject.getName();
            this.createOriginal(cdiVariableObject);
        }
        this.fIsEnabled = !this.isBookkeepingEnabled();
        this.setStatus(2, MessageFormat.format(CoreModelMessages.getString("CVariable.1"), errorMessage));
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public ICType getType() throws DebugException {
        InternalVariable iv = this.getCurrentInternalVariable();
        return iv != null ? iv.getType() : null;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public void setEnabled(boolean enabled) throws DebugException {
        InternalVariable iv = this.getOriginal();
        if (iv != null) {
            iv.dispose(true);
        }
        if ((iv = this.getShadow()) != null) {
            iv.dispose(true);
        }
        this.fIsEnabled = enabled;
        this.fireChangeEvent(256);
    }

    public boolean canEnableDisable() {
        return !(this.getParent() instanceof IValue);
    }

    public boolean isArgument() {
        InternalVariable iv = this.getOriginal();
        return iv != null ? iv.isArgument() : false;
    }

    public IValue getValue() throws DebugException {
        InternalVariable iv;
        if (this.isEnabled() && (iv = this.getCurrentInternalVariable()) != null) {
            try {
                return iv.getValue();
            }
            catch (DebugException e) {
                this.setStatus(2, e.getMessage());
            }
        }
        return null;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public String getReferenceTypeName() throws DebugException {
        ICType type = this.getType();
        return type != null ? type.getName() : "";
    }

    public boolean hasValueChanged() throws DebugException {
        InternalVariable iv = this.getCurrentInternalVariable();
        return iv != null ? iv.isChanged() : false;
    }

    public boolean supportsFormatting() {
        return true;
    }

    public CVariableFormat getFormat() {
        return this.fFormat;
    }

    public void changeFormat(CVariableFormat format) throws DebugException {
        this.setFormat(format);
        this.resetValue();
    }

    public boolean canCastToArray() {
        try {
            ICType type = this.getType();
            return this.getOriginal() != null && this.isEnabled() && type.isPointer();
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public void castToArray(int startIndex, int length) throws DebugException {
        InternalVariable current = this.getCurrentInternalVariable();
        if (current != null) {
            InternalVariable newVar = current.createShadow(startIndex, length);
            if (this.getShadow() != null) {
                this.getShadow().dispose(true);
            }
            this.setShadow(newVar);
            this.fireChangeEvent(256);
        }
    }

    public void setValue(String expression) throws DebugException {
        InternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            String newExpression = this.processExpression(expression);
            iv.setValue(newExpression);
        }
    }

    public void setValue(IValue value) throws DebugException {
        CDebugElement.notSupported(CoreModelMessages.getString("CVariable.3"));
    }

    public boolean supportsValueModification() {
        return true;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return value.getDebugTarget().equals(this.getDebugTarget());
    }

    public boolean canCast() {
        return this.getOriginal() != null && this.isEnabled();
    }

    public String getCurrentType() {
        String typeName = "";
        try {
            typeName = this.getReferenceTypeName();
        }
        catch (DebugException debugException) {}
        return typeName;
    }

    public void cast(String type) throws DebugException {
        InternalVariable current = this.getCurrentInternalVariable();
        if (current != null) {
            InternalVariable newVar = current.createShadow(type);
            if (this.getShadow() != null) {
                this.getShadow().dispose(true);
            }
            this.setShadow(newVar);
            this.fireChangeEvent(256);
        }
    }

    public void restoreOriginal() throws DebugException {
        InternalVariable iv;
        InternalVariable oldVar = this.getShadow();
        this.setShadow(null);
        if (oldVar != null) {
            oldVar.dispose(true);
        }
        if ((iv = this.getOriginal()) != null) {
            iv.invalidateValue();
        }
        this.fireChangeEvent(256);
    }

    public boolean isCasted() {
        return this.getShadow() != null;
    }

    public void handleDebugEvents(ICDIEvent[] events) {
        InternalVariable iv = this.getCurrentInternalVariable();
        if (iv == null) {
            return;
        }
        int i = 0;
        while (i < events.length) {
            ICDITarget target;
            ICDIEvent event = events[i];
            ICDIObject source = event.getSource();
            if (source != null && (target = source.getTarget()).equals(this.getCDITarget())) {
                if (event instanceof ICDIChangedEvent) {
                    if (source instanceof ICDIVariable && iv.isSameVariable((ICDIVariable)source)) {
                        this.handleChangedEvent((ICDIChangedEvent)event);
                    }
                } else if (event instanceof ICDIResumedEvent) {
                    this.handleResumedEvent((ICDIResumedEvent)event);
                }
            }
            ++i;
        }
    }

    private void handleResumedEvent(ICDIResumedEvent event) {
        boolean changed = false;
        if (this.hasErrors()) {
            this.resetStatus();
            changed = true;
            InternalVariable iv = this.getCurrentInternalVariable();
            if (iv != null) {
                iv.invalidateValue();
            }
        }
        if (changed) {
            this.fireChangeEvent(256);
        }
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
        InternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            iv.setChanged(true);
            this.fireChangeEvent(256);
        }
    }

    private InternalVariable getCurrentInternalVariable() {
        if (this.getShadow() != null) {
            return this.getShadow();
        }
        return this.getOriginal();
    }

    private InternalVariable getOriginal() {
        return this.fOriginal;
    }

    private void setOriginal(InternalVariable original) {
        this.fOriginal = original;
    }

    private InternalVariable getShadow() {
        return this.fShadow;
    }

    private void setShadow(InternalVariable shadow) {
        this.fShadow = shadow;
    }

    protected boolean isBookkeepingEnabled() {
        boolean result = false;
        try {
            result = this.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", false);
        }
        catch (CoreException coreException) {}
        return result;
    }

    private void createOriginal(ICDIVariableDescriptor vo) {
        if (vo != null) {
            this.fName = vo.getName();
        }
        this.setOriginal(new InternalVariable(this, vo));
    }

    protected boolean hasErrors() {
        return !this.isOK();
    }

    protected void setChanged(boolean changed) {
        InternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            iv.setChanged(changed);
        }
    }

    protected void resetValue() {
        InternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            this.resetStatus();
            iv.resetValue();
            this.fireChangeEvent(256);
        }
    }

    private String processExpression(String oldExpression) throws DebugException {
        return oldExpression;
    }

    public void dispose() {
        this.internalDispose(false);
    }

    protected int sizeof() {
        InternalVariable iv = this.getCurrentInternalVariable();
        return iv != null ? iv.sizeof() : -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CVariable) {
            InternalVariable iv = this.getOriginal();
            return iv != null ? iv.equals(((CVariable)obj).getOriginal()) : false;
        }
        return false;
    }

    protected boolean sameVariable(ICDIVariableDescriptor vo) {
        InternalVariable iv = this.getOriginal();
        return iv != null && iv.sameVariable(vo);
    }

    protected void setFormat(CVariableFormat format) {
        this.fFormat = format;
    }

    public String getExpressionString() throws DebugException {
        InternalVariable iv = this.getCurrentInternalVariable();
        return iv != null ? iv.getQualifiedName() : null;
    }

    protected void preserve() {
        this.resetStatus();
        InternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            iv.preserve();
        }
    }

    protected void internalDispose(boolean destroy) {
        this.getCDISession().getEventManager().removeEventListener(this);
        InternalVariable iv = this.getOriginal();
        if (iv != null) {
            iv.dispose(destroy);
        }
        if ((iv = this.getShadow()) != null) {
            iv.dispose(destroy);
        }
    }

    private class InternalVariable {
        private CVariable fVariable;
        private ICDIVariableDescriptor fCDIVariableObject;
        private ICDIVariable fCDIVariable;
        private CType fType;
        private String fQualifiedName;
        private ICValue fValue;
        private boolean fChanged = false;

        InternalVariable(CVariable var, ICDIVariableDescriptor varObject) {
            this.setVariable(var);
            this.setCDIVariableObject(varObject);
            this.setCDIVariable(varObject instanceof ICDIVariable ? (ICDIVariable)varObject : null);
        }

        InternalVariable createShadow(int start, int length) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getCDIVariableObject().getVariableDescriptorAsArray(start, length));
            }
            catch (CDIException e) {
                CDebugElement.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        InternalVariable createShadow(String type) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getCDIVariableObject().getVariableDescriptorAsType(type));
            }
            catch (CDIException e) {
                CDebugElement.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        private synchronized ICDIVariable getCDIVariable() throws DebugException {
            if (this.fCDIVariable == null) {
                try {
                    this.fCDIVariable = this.getCDIVariableObject().createVariable();
                }
                catch (CDIException e) {
                    CDebugElement.requestFailed(e.getMessage(), null);
                }
            }
            return this.fCDIVariable;
        }

        private void setCDIVariable(ICDIVariable variable) {
            this.fCDIVariable = variable;
        }

        private ICDIVariableDescriptor getCDIVariableObject() {
            return this.fCDIVariableObject;
        }

        private void setCDIVariableObject(ICDIVariableDescriptor variableObject) {
            this.fCDIVariableObject = variableObject;
        }

        String getQualifiedName() throws DebugException {
            if (this.fQualifiedName == null) {
                try {
                    this.fQualifiedName = this.fCDIVariableObject != null ? this.fCDIVariableObject.getQualifiedName() : null;
                }
                catch (CDIException e) {
                    CDebugElement.requestFailed(e.getMessage(), null);
                }
            }
            return this.fQualifiedName;
        }

        CType getType() throws DebugException {
            ICDIVariableDescriptor varObject;
            if (this.fType == null && (varObject = this.getCDIVariableObject()) != null) {
                InternalVariable internalVariable = this;
                synchronized (internalVariable) {
                    if (this.fType == null) {
                        try {
                            this.fType = new CType(varObject.getType());
                        }
                        catch (CDIException e) {
                            CDebugElement.requestFailed(e.getMessage(), null);
                        }
                    }
                }
            }
            return this.fType;
        }

        synchronized void invalidate(boolean destroy) {
            try {
                if (destroy && this.fCDIVariable != null) {
                    this.fCDIVariable.dispose();
                }
            }
            catch (CDIException e) {
                CVariable.this.logError(e.getMessage());
            }
            this.invalidateValue();
            this.setCDIVariable(null);
            if (this.fType != null) {
                this.fType.dispose();
            }
            this.fType = null;
        }

        void dispose(boolean destroy) {
            this.invalidate(destroy);
        }

        boolean isSameVariable(ICDIVariable cdiVar) {
            return this.fCDIVariable != null ? this.fCDIVariable.equals(cdiVar) : false;
        }

        int sizeof() {
            if (this.getCDIVariableObject() != null) {
                try {
                    return this.getCDIVariableObject().sizeof();
                }
                catch (CDIException cDIException) {}
            }
            return 0;
        }

        boolean isArgument() {
            return this.getCDIVariableObject() instanceof ICDIArgumentDescriptor;
        }

        void setValue(String expression) throws DebugException {
            ICDIVariable cdiVariable = null;
            try {
                cdiVariable = this.getCDIVariable();
                if (cdiVariable != null) {
                    cdiVariable.setValue(expression);
                } else {
                    CDebugElement.requestFailed(CoreModelMessages.getString("CModificationVariable.0"), null);
                }
            }
            catch (CDIException e) {
                CDebugElement.targetRequestFailed(e.getMessage(), null);
            }
        }

        void setValue(ICValue value) {
            this.fValue = value;
        }

        synchronized ICValue getValue() throws DebugException {
            ICDIVariable var;
            if (this.fValue == null && (var = this.getCDIVariable()) != null) {
                try {
                    ICDIValue cdiValue = var.getValue();
                    if (cdiValue != null) {
                        ICDIType cdiType = cdiValue.getType();
                        if (cdiValue instanceof ICDIArrayValue && cdiType != null) {
                            int[] dims;
                            CType type = new CType(cdiType);
                            if (type.isArray() && (dims = type.getArrayDimensions()).length > 0 && dims[0] > 0) {
                                this.fValue = CValueFactory.createIndexedValue(this.getVariable(), (ICDIArrayValue)cdiValue, 0, dims[0]);
                            }
                        } else {
                            this.fValue = CValueFactory.createValue(this.getVariable(), cdiValue);
                        }
                    }
                }
                catch (CDIException e) {
                    CDebugElement.requestFailed(e.getMessage(), e);
                }
            }
            return this.fValue;
        }

        void invalidateValue() {
            if (this.fValue instanceof AbstractCValue) {
                ((AbstractCValue)this.fValue).dispose();
                this.fValue = null;
            }
        }

        boolean isChanged() {
            return this.fChanged;
        }

        synchronized void setChanged(boolean changed) {
            if (changed) {
                this.invalidateValue();
            }
            if (this.fValue instanceof AbstractCValue) {
                ((AbstractCValue)this.fValue).setChanged(changed);
            }
            this.fChanged = changed;
        }

        synchronized void preserve() {
            this.setChanged(false);
            if (this.fValue instanceof AbstractCValue) {
                ((AbstractCValue)this.fValue).preserve();
            }
        }

        CVariable getVariable() {
            return this.fVariable;
        }

        private void setVariable(CVariable variable) {
            this.fVariable = variable;
        }

        void resetValue() {
            if (this.fValue instanceof AbstractCValue) {
                ((AbstractCValue)this.fValue).reset();
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof InternalVariable) {
                return this.getCDIVariableObject().equals(((InternalVariable)obj).getCDIVariableObject());
            }
            return false;
        }

        boolean sameVariable(ICDIVariableDescriptor vo) {
            return this.getCDIVariableObject().equals(vo);
        }
    }
}

