/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.gnu;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.make.core.makefile.IMakefileValidator;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefileValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;

public class GNUMakefileChecker
extends ACBuilder {
    protected Map validatorMap = new HashMap();

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta = null;
        if (kind != 6) {
            delta = this.getDelta(this.getProject());
        }
        if (delta == null || kind == 6) {
            this.checkProject(this.getProject(), monitor);
        } else {
            MyResourceDeltaVisitor vis = new MyResourceDeltaVisitor(monitor);
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)vis);
            }
        }
        this.checkCancel(monitor);
        return new IProject[0];
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void checkProject(IProject project, IProgressMonitor monitor) {
        IFile[] files = this.getCandidateMakefiles(project);
        int i = 0;
        while (i < files.length) {
            this.checkMakefile(files[i], monitor);
            ++i;
        }
    }

    protected boolean isMakefileCandidate(IFile file) {
        IFile[] files = this.getCandidateMakefiles(file.getProject());
        int i = 0;
        while (i < files.length) {
            if (files[i].getFullPath().equals((Object)file.getFullPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void checkMakefile(IFile file, IProgressMonitor monitor) {
        IMakefileValidator validator = this.getMakefileValidator(file);
        try {
            this.removeAllMarkers(file);
        }
        catch (CoreException coreException) {}
        validator.checkFile(file, monitor);
    }

    protected IFile[] getCandidateMakefiles(IProject proj) {
        IFile defaultMakefile = proj.getFile((IPath)new Path("Makefile"));
        if (defaultMakefile.exists()) {
            return new IFile[]{defaultMakefile};
        }
        return new IFile[0];
    }

    protected IMakefileValidator getMakefileValidator(IFile file) {
        IMakefileValidator validator = (IMakefileValidator)this.validatorMap.get(file.getProject());
        if (validator == null) {
            validator = new GNUMakefileValidator();
            validator.setMarkerGenerator((IMarkerGenerator)this);
            this.validatorMap.put(file.getProject(), validator);
        }
        return validator;
    }

    private void removeAllMarkers(IFile file) throws CoreException {
        IWorkspace workspace = file.getWorkspace();
        IMarker[] markers = file.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers != null) {
            workspace.deleteMarkers(markers);
        }
    }

    public class MyResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        IProgressMonitor monitor;

        public MyResourceDeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IFile candidate;
            IResource resource = delta.getResource();
            if (resource != null && resource.getProject() == GNUMakefileChecker.this.getProject() && resource instanceof IFile && GNUMakefileChecker.this.isMakefileCandidate(candidate = (IFile)resource) && delta.getKind() != 2) {
                GNUMakefileChecker.this.checkMakefile(candidate, this.monitor);
            }
            return true;
        }
    }
}

