/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterGroup;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Register;
import org.eclipse.cdt.debug.mi.core.cdi.model.RegisterDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.RegisterGroup;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableDescriptor;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataListChangedRegisters;
import org.eclipse.cdt.debug.mi.core.command.MIDataListRegisterNames;
import org.eclipse.cdt.debug.mi.core.command.MIVarCreate;
import org.eclipse.cdt.debug.mi.core.command.MIVarDelete;
import org.eclipse.cdt.debug.mi.core.command.MIVarUpdate;
import org.eclipse.cdt.debug.mi.core.event.MIChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataListChangedRegistersInfo;
import org.eclipse.cdt.debug.mi.core.output.MIDataListRegisterNamesInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarCreateInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarUpdateInfo;

public class RegisterManager
extends Manager {
    Map regsMap;
    MIVarChange[] noChanges = new MIVarChange[0];

    public RegisterManager(Session session) {
        super(session, true);
        this.regsMap = new Hashtable();
        this.setAutoUpdate(MIPlugin.getDefault().getPluginPreferences().getBoolean(IMIConstants.PREF_REGISTERS_AUTO_REFRESH));
    }

    synchronized List getRegistersList(Target target) {
        List regsList = (List)this.regsMap.get(target);
        if (regsList == null) {
            regsList = Collections.synchronizedList(new ArrayList());
            this.regsMap.put(target, regsList);
        }
        return regsList;
    }

    public ICDIRegisterGroup[] getRegisterGroups(Target target) throws CDIException {
        RegisterGroup group = new RegisterGroup(target, "Main");
        return new ICDIRegisterGroup[]{group};
    }

    public ICDIRegisterDescriptor[] getRegisterDescriptors(RegisterGroup group) throws CDIException {
        Target target = (Target)group.getTarget();
        return this.getRegisterDescriptors(target);
    }

    public ICDIRegisterDescriptor[] getRegisterDescriptors(Target target) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataListRegisterNames registers = factory.createMIDataListRegisterNames();
        try {
            mi.postCommand(registers);
            MIDataListRegisterNamesInfo info = registers.getMIDataListRegisterNamesInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            String[] names = info.getRegisterNames();
            ArrayList<RegisterDescriptor> regsList = new ArrayList<RegisterDescriptor>(names.length);
            int i = 0;
            while (i < names.length) {
                if (names[i].length() > 0) {
                    regsList.add(new RegisterDescriptor(target, null, null, names[i], null, i, 0));
                }
                ++i;
            }
            return regsList.toArray(new ICDIRegisterDescriptor[0]);
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public Register createRegister(RegisterDescriptor regDesc) throws CDIException {
        Register reg = this.findRegister(regDesc);
        if (reg == null) {
            try {
                String name = regDesc.getQualifiedName();
                Target target = (Target)regDesc.getTarget();
                MISession mi = target.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIVarCreate var = factory.createMIVarCreate(name);
                mi.postCommand(var);
                MIVarCreateInfo info = var.getMIVarCreateInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                reg = new Register(regDesc, info.getMIVar());
                List regList = this.getRegistersList(target);
                regList.add(reg);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        return reg;
    }

    public void destroyRegister(Register reg) {
        Target target = (Target)reg.getTarget();
        List regList = (List)this.regsMap.get(target);
        if (regList != null && regList.remove(reg)) {
            MISession miSession = target.getMISession();
            try {
                this.removeMIVar(miSession, reg.getMIVar());
            }
            catch (CDIException cDIException) {}
        }
    }

    void removeMIVar(MISession miSession, MIVar miVar) throws CDIException {
        CommandFactory factory = miSession.getCommandFactory();
        MIVarDelete var = factory.createMIVarDelete(miVar.getVarName());
        try {
            miSession.postCommand(var);
            var.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public Register getRegister(MISession miSession, String varName) {
        Target target = ((Session)this.getSession()).getTarget(miSession);
        Register[] regs = this.getRegisters(target);
        int i = 0;
        while (i < regs.length) {
            if (regs[i].getMIVar().getVarName().equals(varName)) {
                return regs[i];
            }
            try {
                Register r = (Register)regs[i].getChild(varName);
                if (r != null) {
                    return r;
                }
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
        return null;
    }

    public Register getRegister(MISession miSession, int regno) {
        Target target = ((Session)this.getSession()).getTarget(miSession);
        return this.getRegister(target, regno);
    }

    public Register getRegister(Target target, int regno) {
        Register[] regs = this.getRegisters(target);
        int i = 0;
        while (i < regs.length) {
            if (regs[i].getPosition() == regno) {
                return regs[i];
            }
            ++i;
        }
        return null;
    }

    public void update(Target target) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataListChangedRegisters changed = factory.createMIDataListChangedRegisters();
        try {
            mi.postCommand(changed);
            MIDataListChangedRegistersInfo info = changed.getMIDataListChangedRegistersInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            int[] regnos = info.getRegisterNumbers();
            ArrayList<MIChangedEvent> eventList = new ArrayList<MIChangedEvent>(regnos.length);
            int i = 0;
            while (i < regnos.length) {
                Register reg = this.getRegister(target, regnos[i]);
                if (reg != null) {
                    String varName = reg.getMIVar().getVarName();
                    MIVarChange[] changes = this.noChanges;
                    MIVarUpdate update = factory.createMIVarUpdate(varName);
                    try {
                        mi.postCommand(update);
                        MIVarUpdateInfo updateInfo = update.getMIVarUpdateInfo();
                        if (updateInfo == null) {
                            throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                        }
                        changes = updateInfo.getMIVarChanges();
                    }
                    catch (MIException mIException) {}
                    if (changes.length != 0) {
                        int j = 0;
                        while (j < changes.length) {
                            String n = changes[j].getVarName();
                            if (changes[j].isInScope()) {
                                eventList.add(new MIVarChangedEvent(mi, n));
                            }
                            ++j;
                        }
                    } else {
                        eventList.add(new MIRegisterChangedEvent(mi, update.getToken(), reg.getName(), regnos[i]));
                    }
                }
                ++i;
            }
            MIEvent[] events = eventList.toArray(new MIEvent[0]);
            mi.fireEvents(events);
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    private Register[] getRegisters(Target target) {
        List regsList = (List)this.regsMap.get(target);
        if (regsList != null) {
            return regsList.toArray(new Register[regsList.size()]);
        }
        return new Register[0];
    }

    private Register findRegister(RegisterDescriptor rd) throws CDIException {
        Target target = (Target)rd.getTarget();
        String name = rd.getName();
        int position = rd.getPosition();
        Register[] regs = this.getRegisters(target);
        int i = 0;
        while (i < regs.length) {
            if (regs[i].getName().equals(name) && regs[i].getCastingArrayStart() == rd.getCastingArrayStart() && regs[i].getCastingArrayEnd() == rd.getCastingArrayEnd() && VariableDescriptor.equalsCasting(regs[i], rd) && regs[i].getPosition() == position) {
                return regs[i];
            }
            ++i;
        }
        return null;
    }
}

