/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.util.LinkedList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.cdt.internal.ui.search.CSearchResultCollector;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkbenchSite;

public abstract class FindAction
extends SelectionParseAction {
    public FindAction(CEditor editor) {
        super(editor);
    }

    public FindAction(IWorkbenchSite site) {
        super(site);
    }

    protected CSearchQuery createSearchQuery(String pattern, ICSearchConstants.SearchFor searchFor) {
        CSearchQuery op = null;
        ICSearchScope scope = this.getScope();
        if (scope == null) {
            return null;
        }
        String scopeDescription = this.getScopeDescription();
        LinkedList<ICSearchConstants.SearchFor> search = new LinkedList<ICSearchConstants.SearchFor>();
        search.add(searchFor);
        CSearchResultCollector collector = new CSearchResultCollector();
        ICSearchConstants.LimitTo limitTo = this.getLimitTo();
        op = new CSearchQuery(CCorePlugin.getWorkspace(), pattern, true, search, limitTo, scope, scopeDescription, collector);
        return op;
    }

    protected CSearchQuery createSearchQuery(IASTOffsetableNamedElement node) {
        int i;
        String pattern = null;
        if (node instanceof IASTQualifiedNameElement) {
            String[] qualNames = ((IASTQualifiedNameElement)node).getFullyQualifiedName();
            pattern = "::" + qualNames[0];
            i = 1;
            while (i < qualNames.length) {
                pattern = String.valueOf(pattern) + "::";
                pattern = String.valueOf(pattern) + qualNames[i];
                ++i;
            }
        } else {
            pattern = node.getName();
        }
        if (node instanceof IASTFunction) {
            pattern = String.valueOf(pattern) + '(';
            String[] parameterTypes = ASTUtil.getFunctionParameterTypes((IASTFunction)((IASTFunction)node));
            i = 0;
            while (i < parameterTypes.length) {
                if (i != 0) {
                    pattern = String.valueOf(pattern) + ", ";
                }
                pattern = String.valueOf(pattern) + parameterTypes[i];
                ++i;
            }
            pattern = String.valueOf(pattern) + ')';
        }
        return this.createSearchQuery(pattern, CSearchUtil.getSearchForFromNode(node));
    }

    public void run() {
        ISelection sel = this.getSelection();
        if (sel instanceof IStructuredSelection) {
            this.run((IStructuredSelection)sel);
        } else if (sel instanceof ITextSelection) {
            this.run((ITextSelection)sel);
        }
    }

    public void run(IStructuredSelection sel) {
        Object obj = sel.getFirstElement();
        if (obj == null || !(obj instanceof ICElement)) {
            this.operationNotAvailable();
            return;
        }
        this.clearStatusLine();
        ICElement element = (ICElement)obj;
        CSearchQuery job = this.createSearchQuery(element.getElementName(), CSearchUtil.getSearchForFromElement(element));
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQuery((ISearchQuery)job);
    }

    public void run(ITextSelection sel) {
        IASTOffsetableNamedElement node;
        block8: {
            if (sel == null) {
                return;
            }
            SelectionParseAction.SelSearchNode selNode = this.getSelection(sel);
            int selectionStart = selNode.selStart;
            int selectionEnd = selNode.selEnd;
            IFile resourceFile = this.fEditor.getInputFile();
            IParser parser = this.setupParser(resourceFile);
            node = null;
            IParser.ISelectionParseResult result = null;
            try {
                result = parser.parse(selectionStart, selectionEnd);
                if (result != null) {
                    node = result.getOffsetableNamedElement();
                }
            }
            catch (ParseError parseError) {
            }
            catch (Exception exception) {
            }
            catch (VirtualMachineError vmErr) {
                if (!(vmErr instanceof OutOfMemoryError)) break block8;
                Util.log(null, (String)("Selection Search Out Of Memory error: " + vmErr.getMessage() + " on File: " + resourceFile.getName()), (ICLogConstants.LogConst)ICLogConstants.CDT);
            }
        }
        if (node == null || !(node instanceof IASTNode)) {
            this.operationNotAvailable();
            return;
        }
        this.clearStatusLine();
        CSearchQuery job = this.createSearchQuery(node);
        if (job == null) {
            return;
        }
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQuery((ISearchQuery)job);
    }

    protected abstract String getScopeDescription();

    protected abstract ICSearchScope getScope();

    protected abstract ICSearchConstants.LimitTo getLimitTo();
}

