/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceConfiguration
extends BuildObject
implements IResourceConfiguration {
    private static final String EMPTY_STRING = new String();
    private IConfiguration parent;
    private List toolList;
    private Map toolMap;
    private String resPath;
    private Boolean isExcluded;
    private boolean isExtensionResourceConfig = false;
    private boolean isDirty = false;
    private boolean resolved = true;

    public ResourceConfiguration(IConfiguration parent, IManagedConfigElement element) {
        this.parent = parent;
        this.isExtensionResourceConfig = true;
        this.resolved = false;
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionResourceConfiguration(this);
        IManagedConfigElement[] tools = element.getChildren("tool");
        int n = 0;
        while (n < tools.length) {
            Tool toolChild = new Tool((IBuildObject)this, tools[n]);
            this.toolList.add(toolChild);
            ++n;
        }
    }

    public ResourceConfiguration(IConfiguration parent, Element element) {
        this.parent = parent;
        this.isExtensionResourceConfig = false;
        this.loadFromProject(element);
        NodeList configElements = element.getChildNodes();
        int i = 0;
        while (i < configElements.getLength()) {
            Node configElement = configElements.item(i);
            if (configElement.getNodeName().equals("tool")) {
                Tool tool = new Tool((IBuildObject)this, (Element)configElement);
                this.addTool(tool);
            }
            ++i;
        }
    }

    public ResourceConfiguration(IConfiguration parent, String id, String resourceName, String path) {
        this.parent = parent;
        this.setId(id);
        this.setName(resourceName);
        this.resPath = path;
        this.isDirty = false;
        this.isExcluded = new Boolean(false);
    }

    public ResourceConfiguration(IConfiguration parent, ResourceConfiguration cloneConfig, String id) {
        this.setId(id);
        this.setName(cloneConfig.getName());
        this.parent = parent;
        this.isExtensionResourceConfig = false;
        if (cloneConfig.resPath != null) {
            this.resPath = new String(cloneConfig.resPath);
        }
        if (cloneConfig.isExcluded != null) {
            this.isExcluded = new Boolean(cloneConfig.isExcluded);
        }
        if (cloneConfig.toolList != null) {
            ListIterator iter = cloneConfig.getToolList().listIterator();
            while (iter.hasNext()) {
                String subName;
                String subId;
                Tool toolChild = (Tool)iter.next();
                int nnn = ManagedBuildManager.getRandomNumber();
                if (toolChild.getSuperClass() != null) {
                    subId = String.valueOf(toolChild.getSuperClass().getId()) + "." + nnn;
                    subName = toolChild.getSuperClass().getName();
                } else {
                    subId = String.valueOf(toolChild.getId()) + "." + nnn;
                    subName = toolChild.getName();
                }
                ITool toolSuperClass = null;
                ITool[] tools = parent.getTools();
                int i = 0;
                while (i < tools.length) {
                    ITool configTool = tools[i];
                    if (configTool.getSuperClass() == toolChild.getSuperClass().getSuperClass()) {
                        toolSuperClass = configTool;
                        break;
                    }
                    ++i;
                }
                Tool newTool = new Tool((IBuildObject)this, toolSuperClass, subId, subName, toolChild);
                this.addTool(newTool);
            }
        }
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.resPath = element.getAttribute("resourcePath");
        String excludeStr = element.getAttribute("exclude");
        if (excludeStr != null) {
            this.isExcluded = new Boolean("true".equals(excludeStr));
        }
    }

    protected void loadFromProject(Element element) {
        String excludeStr;
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        if (element.hasAttribute("exclude") && (excludeStr = element.getAttribute("exclude")) != null) {
            this.isExcluded = new Boolean("true".equals(excludeStr));
        }
        if (element.hasAttribute("resourcePath")) {
            this.resPath = element.getAttribute("resourcePath");
        }
    }

    public void serialize(Document doc, Element element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.isExcluded != null) {
            element.setAttribute("exclude", this.isExcluded.toString());
        }
        if (this.resPath != null) {
            element.setAttribute("resourcePath", this.resPath);
        }
        List toolElements = this.getToolList();
        ListIterator iter = toolElements.listIterator();
        while (iter.hasNext()) {
            Tool tool = (Tool)iter.next();
            Element toolElement = doc.createElement("tool");
            element.appendChild(toolElement);
            tool.serialize(doc, toolElement);
        }
        this.isDirty = false;
    }

    public IConfiguration getParent() {
        return this.parent;
    }

    public ITool[] getTools() {
        ITool[] tools = new ITool[this.getToolList().size()];
        ListIterator iter = this.getToolList().listIterator();
        int i = 0;
        while (iter.hasNext()) {
            Tool tool = (Tool)iter.next();
            tools[i++] = tool;
        }
        return tools;
    }

    public ITool getTool(String id) {
        Tool tool = (Tool)this.getToolMap().get(id);
        return tool;
    }

    private List getToolList() {
        if (this.toolList == null) {
            this.toolList = new ArrayList();
        }
        return this.toolList;
    }

    private Map getToolMap() {
        if (this.toolMap == null) {
            this.toolMap = new HashMap();
        }
        return this.toolMap;
    }

    public void addTool(Tool tool) {
        this.getToolList().add(tool);
        this.getToolMap().put(tool.getId(), tool);
    }

    public boolean isExcluded() {
        if (this.isExcluded != null) {
            return this.isExcluded;
        }
        return false;
    }

    public String getResourcePath() {
        String path = this.resPath;
        if (path == null) {
            return EMPTY_STRING;
        }
        return path;
    }

    public void setExclude(boolean excluded) {
        if (this.isExcluded == null || excluded != this.isExcluded) {
            this.isExcluded = new Boolean(excluded);
            this.setDirty(true);
        }
    }

    public void setResourcePath(String path) {
        if (path == null) {
            return;
        }
        if (this.resPath == null || !path.equals(this.resPath)) {
            this.resPath = path;
            this.setDirty(true);
        }
    }

    public boolean isExtensionResourceConfiguration() {
        return this.isExtensionResourceConfig;
    }

    public boolean isDirty() {
        if (this.isExtensionResourceConfig) {
            return false;
        }
        if (this.isDirty) {
            return true;
        }
        ListIterator iter = this.getToolList().listIterator();
        while (iter.hasNext()) {
            Tool toolChild = (Tool)iter.next();
            if (!toolChild.isDirty()) continue;
            return true;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            ListIterator iter = this.getToolList().listIterator();
            while (iter.hasNext()) {
                Tool toolChild = (Tool)iter.next();
                toolChild.setDirty(false);
            }
        }
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            ListIterator iter = this.getToolList().listIterator();
            while (iter.hasNext()) {
                Tool toolChild = (Tool)iter.next();
                toolChild.resolveReferences();
            }
        }
    }

    public ITool createTool(ITool superClass, String id, String name, boolean isExtensionElement) {
        Tool tool = new Tool(this, superClass, id, name, isExtensionElement);
        this.addTool(tool);
        this.setDirty(true);
        return tool;
    }

    public void reset() {
        ITool[] tools = this.getTools();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            IOption[] opts = tool.getOptions();
            int j = 0;
            while (j < opts.length) {
                tool.removeOption(opts[j]);
                ++j;
            }
            ++i;
        }
        this.isExcluded = new Boolean(false);
    }

    public void setToolCommand(ITool tool, String command) {
        tool.setToolCommand(command);
    }

    public IOption setOption(ITool tool, IOption option, boolean value) throws BuildException {
        IOption retOpt = option;
        if (option.getBooleanValue() != value) {
            if (option.getParent().getParent() != this) {
                IOption newSuperClass = option;
                if (!newSuperClass.isExtensionElement()) {
                    newSuperClass = newSuperClass.getSuperClass();
                }
                if (newSuperClass.isExtensionElement() && newSuperClass.overridesOnlyValue()) {
                    newSuperClass = newSuperClass.getSuperClass();
                }
                int nnn = ManagedBuildManager.getRandomNumber();
                String subId = String.valueOf(newSuperClass.getId()) + "." + nnn;
                retOpt = tool.createOption(newSuperClass, subId, null, false);
                retOpt.setValueType(option.getValueType());
                retOpt.setValue(value);
                this.setDirty(true);
            } else {
                option.setValue(value);
            }
            this.parent.setRebuildState(true);
        }
        return retOpt;
    }

    public IOption setOption(ITool tool, IOption option, String value) throws BuildException {
        IOption retOpt = option;
        String oldValue = option.getStringValue();
        if (oldValue != null && !oldValue.equals(value)) {
            if (option.getParent().getParent() != this) {
                IOption newSuperClass = option;
                if (!newSuperClass.isExtensionElement()) {
                    newSuperClass = newSuperClass.getSuperClass();
                }
                if (newSuperClass.isExtensionElement() && newSuperClass.overridesOnlyValue()) {
                    newSuperClass = newSuperClass.getSuperClass();
                }
                int nnn = ManagedBuildManager.getRandomNumber();
                String subId = String.valueOf(newSuperClass.getId()) + "." + nnn;
                retOpt = tool.createOption(newSuperClass, subId, null, false);
                retOpt.setValueType(option.getValueType());
                retOpt.setValue(value);
                this.setDirty(true);
            } else {
                option.setValue(value);
            }
            this.parent.setRebuildState(true);
        }
        return retOpt;
    }

    public IOption setOption(ITool tool, IOption option, String[] value) throws BuildException {
        Object[] oldValue;
        IOption retOpt = option;
        switch (option.getValueType()) {
            case 3: {
                oldValue = option.getStringListValue();
                break;
            }
            case 4: {
                oldValue = option.getIncludePaths();
                break;
            }
            case 5: {
                oldValue = option.getDefinedSymbols();
                break;
            }
            case 6: {
                oldValue = option.getLibraries();
                break;
            }
            case 7: {
                oldValue = option.getUserObjects();
                break;
            }
            default: {
                oldValue = new String[]{};
            }
        }
        if (!Arrays.equals(value, oldValue)) {
            if (option.getParent().getParent() != this) {
                IOption newSuperClass = option;
                if (!newSuperClass.isExtensionElement()) {
                    newSuperClass = newSuperClass.getSuperClass();
                }
                if (newSuperClass.isExtensionElement() && newSuperClass.overridesOnlyValue()) {
                    newSuperClass = newSuperClass.getSuperClass();
                }
                int nnn = ManagedBuildManager.getRandomNumber();
                String subId = String.valueOf(newSuperClass.getId()) + "." + nnn;
                retOpt = tool.createOption(newSuperClass, subId, null, false);
                retOpt.setValueType(option.getValueType());
                retOpt.setValue(value);
                this.setDirty(true);
            } else {
                option.setValue(value);
            }
            this.parent.setRebuildState(true);
        }
        return retOpt;
    }

    public IResource getOwner() {
        return this.getParent().getOwner();
    }
}

