/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewConfigurationDialog
extends Dialog {
    private static final String PREFIX = "NewConfiguration";
    private static final String LABEL = "NewConfiguration.label";
    private static final String ERROR = "NewConfiguration.error";
    private static final String NAME = "NewConfiguration.label.name";
    private static final String GROUP = "NewConfiguration.label.group";
    private static final String COPY = "NewConfiguration.label.copy";
    private static final String CLONE = "NewConfiguration.label.clone";
    private static final String TITLE = "NewConfiguration.error.title";
    private static final String DUPLICATE = "NewConfiguration.error.duplicateName";
    private Button btnClone;
    private Button btnCopy;
    private Button btnOk;
    private Text configName;
    private Combo copyConfigSelector;
    private Combo cloneConfigSelector;
    private boolean clone;
    private IConfiguration[] defaultConfigs;
    private IConfiguration[] definedConfigs;
    private IConfiguration parentConfig;
    private IManagedProject managedProject;
    private String newName;
    private String title = "";

    protected NewConfigurationDialog(Shell parentShell, IManagedProject managedProject, String title) {
        super(parentShell);
        this.title = title;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.newName = new String();
        this.parentConfig = null;
        this.managedProject = managedProject;
        this.clone = true;
        this.definedConfigs = managedProject.getConfigurations();
        IProjectType projectType = managedProject.getProjectType();
        this.defaultConfigs = projectType.getConfigurations();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.newName = this.configName.getText().trim();
            String baseConfigName = new String();
            if (this.clone) {
                baseConfigName = this.cloneConfigSelector.getItem(this.cloneConfigSelector.getSelectionIndex());
                int i = 0;
                while (i < this.definedConfigs.length) {
                    IConfiguration config = this.definedConfigs[i];
                    if (config.getName().equals(baseConfigName)) {
                        this.parentConfig = config;
                        break;
                    }
                    ++i;
                }
            } else {
                baseConfigName = this.copyConfigSelector.getItem(this.copyConfigSelector.getSelectionIndex());
                int i = 0;
                while (i < this.defaultConfigs.length) {
                    IConfiguration config = this.defaultConfigs[i];
                    if (config.getName().equals(baseConfigName)) {
                        this.parentConfig = config;
                        break;
                    }
                    ++i;
                }
            }
        } else {
            this.newName = null;
            this.parentConfig = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnOk = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.configName.setFocus();
        if (this.configName != null) {
            this.configName.setText(this.newName);
        }
        this.updateButtonState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label(composite, 16384);
        nameLabel.setFont(parent.getFont());
        nameLabel.setText(ManagedBuilderUIMessages.getResourceString(NAME));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        nameLabel.setLayoutData((Object)gd);
        this.configName = new Text(composite, 2052);
        this.configName.setFont(composite.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.configName.setLayoutData((Object)gd);
        this.configName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationDialog.this.updateButtonState();
            }
        });
        Group group = new Group(composite, 0);
        group.setFont(composite.getFont());
        group.setText(ManagedBuilderUIMessages.getResourceString(GROUP));
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        group.setLayoutData((Object)gd);
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewConfigurationDialog.this.clone = NewConfigurationDialog.this.btnClone.getSelection();
                NewConfigurationDialog.this.updateComboState();
            }
        };
        this.btnCopy = new Button((Composite)group, 16);
        this.btnCopy.setFont(group.getFont());
        this.btnCopy.setText(ManagedBuilderUIMessages.getResourceString(COPY));
        this.setButtonLayoutData(this.btnCopy);
        this.btnCopy.addSelectionListener((SelectionListener)radioListener);
        this.copyConfigSelector = new Combo((Composite)group, 2060);
        this.copyConfigSelector.setFont(group.getFont());
        this.copyConfigSelector.setItems(this.getDefaultConfigNames());
        int index = this.copyConfigSelector.indexOf(this.newName);
        this.copyConfigSelector.select(index < 0 ? 0 : index);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.copyConfigSelector.setLayoutData((Object)gd);
        this.copyConfigSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationDialog.this.updateButtonState();
            }
        });
        this.copyConfigSelector.setEnabled(false);
        this.btnClone = new Button((Composite)group, 16);
        this.btnClone.setFont(group.getFont());
        this.btnClone.setText(ManagedBuilderUIMessages.getResourceString(CLONE));
        this.setButtonLayoutData(this.btnClone);
        this.btnClone.addSelectionListener((SelectionListener)radioListener);
        this.btnClone.setSelection(true);
        this.cloneConfigSelector = new Combo((Composite)group, 2060);
        this.cloneConfigSelector.setFont(group.getFont());
        this.cloneConfigSelector.setItems(this.getDefinedConfigNames());
        index = this.cloneConfigSelector.indexOf(this.newName);
        this.cloneConfigSelector.select(index < 0 ? 0 : index);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.cloneConfigSelector.setLayoutData((Object)gd);
        this.cloneConfigSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationDialog.this.updateButtonState();
            }
        });
        return composite;
    }

    public IConfiguration getParentConfiguration() {
        return this.parentConfig;
    }

    private String[] getDefaultConfigNames() {
        String[] names = new String[this.defaultConfigs.length];
        int index = 0;
        while (index < this.defaultConfigs.length) {
            IConfiguration config = this.defaultConfigs[index];
            names[index] = config.getName();
            ++index;
        }
        return names;
    }

    private String[] getDefinedConfigNames() {
        String[] names = new String[this.definedConfigs.length];
        int index = 0;
        while (index < this.definedConfigs.length) {
            IConfiguration config = this.definedConfigs[index];
            names[index] = config.getName();
            ++index;
        }
        return names;
    }

    public String getNewName() {
        return this.newName;
    }

    protected boolean isDuplicateName(String newName) {
        IConfiguration[] configs = this.managedProject.getConfigurations();
        int index = 0;
        while (index < configs.length) {
            IConfiguration configuration = configs[index];
            if (configuration.getName().equals(newName)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private void updateButtonState() {
        if (this.btnOk != null) {
            int selectionIndex = this.copyConfigSelector.getSelectionIndex();
            this.btnOk.setEnabled(this.validateName() && selectionIndex != -1);
        }
    }

    protected void updateComboState() {
        this.cloneConfigSelector.setEnabled(this.clone);
        this.copyConfigSelector.setEnabled(!this.clone);
    }

    private boolean validateName() {
        String currentName = this.configName.getText().trim();
        int nameLength = currentName.length();
        if (this.isDuplicateName(currentName)) {
            MessageDialog.openError((Shell)this.getShell(), (String)ManagedBuilderUIMessages.getResourceString(TITLE), (String)ManagedBuilderUIMessages.getFormattedString(DUPLICATE, currentName));
            return false;
        }
        return nameLength > 0;
    }
}

