/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.MIInferior;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MIProcess;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;

public class MIProcessAdapter
implements MIProcess {
    Process fGDBProcess;

    public MIProcessAdapter(String[] args, IProgressMonitor monitor) throws IOException {
        this.fGDBProcess = this.getGDBProcess(args, monitor);
    }

    protected Process getGDBProcess(String[] args, IProgressMonitor monitor) throws IOException {
        int ONE_SECOND = 1000;
        if (MIPlugin.getDefault().isDebugging()) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < args.length) {
                sb.append(args[i]);
                sb.append(' ');
                ++i;
            }
            MIPlugin.getDefault().debugLog(sb.toString());
        }
        final Process pgdb = ProcessFactory.getFactory().exec(args);
        Thread syncStartup = new Thread("GDB Start"){

            public void run() {
                try {
                    String line;
                    InputStream stream = pgdb.getInputStream();
                    InputStreamReader r = new InputStreamReader(stream);
                    BufferedReader reader = new BufferedReader(r);
                    while ((line = reader.readLine()) != null) {
                        if (!(line = line.trim()).endsWith("(gdb)")) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {}
            }
        };
        syncStartup.start();
        MIPlugin miPlugin = MIPlugin.getDefault();
        Preferences prefs = miPlugin.getPluginPreferences();
        int timepass = 0;
        int launchTimeout = prefs.getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
        if (launchTimeout <= 0) {
            launchTimeout = Integer.MAX_VALUE;
        }
        timepass = 0;
        while (timepass < launchTimeout) {
            if (!syncStartup.isAlive() || monitor.isCanceled()) break;
            try {
                Thread.sleep(ONE_SECOND);
            }
            catch (InterruptedException interruptedException) {}
            timepass += ONE_SECOND;
        }
        try {
            syncStartup.interrupt();
            syncStartup.join(ONE_SECOND);
        }
        catch (InterruptedException interruptedException) {}
        if (monitor.isCanceled()) {
            pgdb.destroy();
            String message = MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session");
            throw new IOException(message);
        }
        if (timepass > launchTimeout) {
            pgdb.destroy();
            String message = MIPlugin.getResourceString("src.GDBDebugger.Error_launch_timeout");
            throw new IOException(message);
        }
        return pgdb;
    }

    public boolean canInterrupt(MIInferior inferior) {
        return this.fGDBProcess instanceof Spawner;
    }

    public void interrupt(MIInferior inferior) {
        if (this.fGDBProcess instanceof Spawner) {
            int i;
            Spawner gdbSpawner = (Spawner)this.fGDBProcess;
            gdbSpawner.interrupt();
            MIInferior mIInferior = inferior;
            synchronized (mIInferior) {
                i = 0;
                while (inferior.isRunning() && i < 5) {
                    try {
                        inferior.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++i;
                }
            }
            if (inferior.isRunning() && inferior.getInferiorPID() > 0) {
                gdbSpawner.raise(inferior.getInferiorPID(), gdbSpawner.INT);
                mIInferior = inferior;
                synchronized (mIInferior) {
                    i = 0;
                    while (inferior.isRunning() && i < 5) {
                        try {
                            inferior.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ++i;
                    }
                }
            }
        }
    }

    public int exitValue() {
        return this.fGDBProcess.exitValue();
    }

    public int waitFor() throws InterruptedException {
        return this.fGDBProcess.waitFor();
    }

    public void destroy() {
        this.fGDBProcess.destroy();
    }

    public InputStream getErrorStream() {
        return this.fGDBProcess.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.fGDBProcess.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.fGDBProcess.getOutputStream();
    }
}

