/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.filetype;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ResolverChangeEvent;
import org.eclipse.cdt.core.filetype.ResolverDelta;
import org.eclipse.cdt.core.internal.filetype.CFileTypeResolver;
import org.eclipse.cdt.core.internal.filetype.ResolverModel;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public class WorkspaceResolver
extends CFileTypeResolver {
    public static final String PREFS_ASSOCIATIONS_INCLUSION = "org.eclipse.cdt.core.associationInclusion";
    public static final String PREFS_ASSOCIATIONS_EXCLUSION = "org.eclipse.cdt.core.associationExclusion";
    ResolverModel fModel;
    List extensionsList;
    private static final String EXTENSION_ASSOC = "CFileTypeAssociation";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_PATTERN = "pattern";
    private static final String ATTR_FILE = "file";

    public WorkspaceResolver() {
        this(ResolverModel.getDefault());
    }

    public WorkspaceResolver(ResolverModel model) {
        super((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        this.fModel = model;
    }

    protected void doAdjustAssociations(ICFileTypeAssociation[] addAssocs, ICFileTypeAssociation[] delAssocs, boolean triggerEvent) {
        ICFileTypeAssociation[] newInclusion;
        List extensionsList;
        ArrayList<ICFileTypeAssociation> newExcList;
        int i;
        ArrayList<ResolverDelta> deltas = new ArrayList<ResolverDelta>();
        if (triggerEvent && addAssocs != null && addAssocs.length > 0) {
            i = 0;
            while (i < addAssocs.length) {
                deltas.add(new ResolverDelta(addAssocs[i], 16));
                ++i;
            }
        }
        if (triggerEvent && delAssocs != null && delAssocs.length > 0) {
            i = 0;
            while (i < delAssocs.length) {
                deltas.add(new ResolverDelta(delAssocs[i], 32));
                ++i;
            }
        }
        if (addAssocs != null && addAssocs.length > 0) {
            ArrayList<ICFileTypeAssociation> newIncList = new ArrayList<ICFileTypeAssociation>();
            newExcList = new ArrayList<ICFileTypeAssociation>();
            extensionsList = this.getExtensionsAssociations();
            int i2 = 0;
            while (i2 < addAssocs.length) {
                if (!extensionsList.contains(addAssocs[i2])) {
                    newIncList.add(addAssocs[i2]);
                } else {
                    newExcList.add(addAssocs[i2]);
                }
                ++i2;
            }
            if (!newIncList.isEmpty()) {
                List inclusion = this.getInclusionAssociations();
                inclusion.addAll(newIncList);
                newInclusion = inclusion.toArray(new ICFileTypeAssociation[inclusion.size()]);
                this.setInclusionAssociations(newInclusion);
            }
            if (!newExcList.isEmpty()) {
                List exclusion = this.getExclusionAssociations();
                exclusion.removeAll(newExcList);
                newInclusion = exclusion.toArray(new ICFileTypeAssociation[exclusion.size()]);
                this.setInclusionAssociations(newInclusion);
            }
        }
        if (delAssocs != null && delAssocs.length > 0) {
            ArrayList<ICFileTypeAssociation> newIncList = new ArrayList<ICFileTypeAssociation>();
            newExcList = new ArrayList();
            extensionsList = this.getExtensionsAssociations();
            int i3 = 0;
            while (i3 < delAssocs.length) {
                if (extensionsList.contains(delAssocs[i3])) {
                    newExcList.add(delAssocs[i3]);
                } else {
                    newIncList.add(delAssocs[i3]);
                }
                ++i3;
            }
            if (!newExcList.isEmpty()) {
                List exclusion = this.getExclusionAssociations();
                exclusion.addAll(newExcList);
                ICFileTypeAssociation[] newExclusion = exclusion.toArray(new ICFileTypeAssociation[exclusion.size()]);
                this.setExclusionAssociations(newExclusion);
            }
            if (!newIncList.isEmpty()) {
                List inclusion = this.getInclusionAssociations();
                inclusion.removeAll(newIncList);
                newInclusion = inclusion.toArray(new ICFileTypeAssociation[inclusion.size()]);
                this.setInclusionAssociations(newInclusion);
            }
        }
        if (addAssocs != null && addAssocs.length > 0 || delAssocs != null && delAssocs.length > 0) {
            CCorePlugin.getDefault().savePluginPreferences();
        }
        if (triggerEvent && !deltas.isEmpty()) {
            ResolverChangeEvent event = new ResolverChangeEvent(this.fModel, this);
            int i4 = 0;
            while (i4 < deltas.size()) {
                ResolverDelta delta = (ResolverDelta)deltas.get(i4);
                event.addDelta(delta);
                ++i4;
            }
            this.fModel.fireEvent(event);
        }
    }

    public List getExtensionsAssociations() {
        if (this.extensionsList == null) {
            this.extensionsList = new ArrayList();
            IExtensionPoint point = this.getExtensionPoint(EXTENSION_ASSOC);
            IExtension[] extensions = point.getExtensions();
            IConfigurationElement[] elements = null;
            int i = 0;
            while (i < extensions.length) {
                elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    ICFileType typeRef = this.fModel.getFileTypeById(elements[j].getAttribute(ATTR_TYPE));
                    if (typeRef != null) {
                        this.extensionsList.addAll(this.getAssocFromExtension(typeRef, elements[j]));
                        this.extensionsList.addAll(this.getAssocFromFile(typeRef, elements[j]));
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this.extensionsList;
    }

    public List getDefaultInclusionAssociations() {
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        String s = prefs.getDefaultString(PREFS_ASSOCIATIONS_INCLUSION);
        String[] items = s.split(";");
        List assoc = this.getAssocFromPreferences(items);
        return assoc;
    }

    public List getInclusionAssociations() {
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        String s = prefs.getString(PREFS_ASSOCIATIONS_INCLUSION);
        String[] items = s.split(";");
        List assoc = this.getAssocFromPreferences(items);
        return assoc;
    }

    private void setInclusionAssociations(ICFileTypeAssociation[] addAssocs) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < addAssocs.length) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(addAssocs[i].getPattern());
            sb.append("!!");
            sb.append(addAssocs[i].getType().getId());
            ++i;
        }
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        String s = prefs.getString(PREFS_ASSOCIATIONS_INCLUSION);
        if (s.length() > 0) {
            sb.append(';').append(s);
        }
        prefs.setValue(PREFS_ASSOCIATIONS_INCLUSION, sb.toString());
    }

    public List getDefaultExclusionAssociations() {
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        String s = prefs.getDefaultString(PREFS_ASSOCIATIONS_EXCLUSION);
        String[] items = s.split(";");
        List assocs = this.getAssocFromPreferences(items);
        return assocs;
    }

    public List getExclusionAssociations() {
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        String s = prefs.getString(PREFS_ASSOCIATIONS_EXCLUSION);
        String[] items = s.split(";");
        List assocs = this.getAssocFromPreferences(items);
        return assocs;
    }

    private void setExclusionAssociations(ICFileTypeAssociation[] addAssocs) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < addAssocs.length) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(addAssocs[i].getPattern());
            sb.append("!!");
            sb.append(addAssocs[i].getType().getId());
            ++i;
        }
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        String s = prefs.getString(PREFS_ASSOCIATIONS_EXCLUSION);
        if (s.length() > 0) {
            sb.append(';').append(s);
        }
        prefs.setValue(PREFS_ASSOCIATIONS_EXCLUSION, sb.toString());
    }

    protected ICFileTypeAssociation[] loadAssociations() {
        ArrayList assocs = new ArrayList();
        List exclusion = this.getExclusionAssociations();
        List inclusion = this.getInclusionAssociations();
        int i = 0;
        while (i < inclusion.size()) {
            Object inc = inclusion.get(i);
            if (!exclusion.contains(inc)) {
                assocs.add(inc);
            }
            ++i;
        }
        List extensions = this.getExtensionsAssociations();
        int i2 = 0;
        while (i2 < extensions.size()) {
            Object ext = extensions.get(i2);
            if (!exclusion.contains(ext)) {
                assocs.add(ext);
            }
            ++i2;
        }
        return assocs.toArray(new ICFileTypeAssociation[assocs.size()]);
    }

    private List getAssocFromExtension(ICFileType typeRef, IConfigurationElement element) {
        ArrayList<ICFileTypeAssociation> assocs = new ArrayList<ICFileTypeAssociation>();
        String attr = element.getAttribute(ATTR_PATTERN);
        if (attr != null) {
            String[] item = attr.split(",");
            int i = 0;
            while (i < item.length) {
                try {
                    assocs.add(this.fModel.createAssocation(item[i].trim(), typeRef));
                }
                catch (IllegalArgumentException e) {
                    CCorePlugin.log(e);
                }
                ++i;
            }
        }
        return assocs;
    }

    private List getAssocFromPreferences(String[] items) {
        ArrayList<ICFileTypeAssociation> assocs = new ArrayList<ICFileTypeAssociation>();
        int i = 0;
        while (i < items.length) {
            String[] item = items[i].split("!!");
            if (item.length == 2) {
                String pattern = item[0].trim();
                ICFileType typeRef = this.fModel.getFileTypeById(item[1]);
                try {
                    assocs.add(this.fModel.createAssocation(pattern, typeRef));
                }
                catch (IllegalArgumentException e) {
                    CCorePlugin.log(e);
                }
            }
            ++i;
        }
        return assocs;
    }

    private List getAssocFromFile(ICFileType typeRef, IConfigurationElement element) {
        ArrayList<ICFileTypeAssociation> assocs = new ArrayList<ICFileTypeAssociation>();
        String attr = element.getAttribute(ATTR_FILE);
        if (attr != null) {
            URL baseURL = null;
            URL fileURL = null;
            BufferedReader in = null;
            String line = null;
            try {
                baseURL = Platform.getBundle((String)element.getDeclaringExtension().getNamespace()).getEntry("/");
                fileURL = new URL(baseURL, attr);
                in = new BufferedReader(new InputStreamReader(fileURL.openStream()));
                line = in.readLine();
                while (line != null) {
                    try {
                        assocs.add(this.fModel.createAssocation(line.trim(), typeRef));
                    }
                    catch (IllegalArgumentException e) {
                        CCorePlugin.log(e);
                    }
                    line = in.readLine();
                }
                in.close();
            }
            catch (IOException e) {
                CCorePlugin.log(e);
            }
        }
        return assocs;
    }

    private IExtensionPoint getExtensionPoint(String extensionPointId) {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", extensionPointId);
    }
}

