/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.som;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.coff.ReadMemoryAccess;

public class AR {
    public static final String NL = System.getProperty("line.separator", "\n");
    protected String filename;
    protected RandomAccessFile file;
    private byte[] ar_magic = new byte[8];
    private LSTHeader lstHeader;
    private ARHeader[] memberHeaders;

    public AR(String filename) throws IOException {
        this.filename = filename;
        this.file = new RandomAccessFile(filename, "r");
        this.file.read(this.ar_magic);
        if (!AR.isARHeader(this.ar_magic)) {
            this.file.close();
            throw new IOException(CCorePlugin.getResourceString("Util.exception.invalidArchive"));
        }
        this.lstHeader = new LSTHeader();
    }

    public void dispose() {
        try {
            if (this.file != null) {
                this.file.close();
                this.file = null;
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }

    public static boolean isARHeader(byte[] ident) {
        return ident.length >= 8 && ident[0] == 33 && ident[1] == 60 && ident[2] == 97 && ident[3] == 114 && ident[4] == 99 && ident[5] == 104 && ident[6] == 62 && ident[7] == 10;
    }

    protected RandomAccessFile getRandomAccessFile() throws IOException {
        if (this.file == null) {
            this.file = new RandomAccessFile(this.filename, "r");
        }
        return this.file;
    }

    public ARHeader[] getHeaders() throws IOException {
        this.loadHeaders();
        return this.memberHeaders;
    }

    private void loadHeaders() throws IOException {
        if (this.memberHeaders != null) {
            return;
        }
        Vector<ARHeader> v = new Vector<ARHeader>();
        try {
            long somDirOffset = this.lstHeader.dir_loc + 68;
            int somDirSize = this.lstHeader.module_limit * 8;
            this.getRandomAccessFile();
            this.file.seek(somDirOffset);
            byte[] somDirectory = new byte[somDirSize];
            this.file.readFully(somDirectory);
            ReadMemoryAccess memory = new ReadMemoryAccess(somDirectory, false);
            int i = 0;
            while (i < this.lstHeader.module_limit) {
                int somOffset = memory.getInt();
                int somSize = memory.getInt();
                ARHeader aHeader = new ARHeader(somOffset - 60);
                aHeader.somOffset = somOffset;
                aHeader.somSize = somSize;
                v.add(aHeader);
                ++i;
            }
        }
        catch (IOException iOException) {}
        this.memberHeaders = v.toArray(new ARHeader[v.size()]);
    }

    public String[] extractFiles(String outdir) throws IOException {
        return this.extractFiles(outdir, null);
    }

    private String[] extractFiles(String outdir, String[] names) throws IOException {
        Vector<String> names_used = new Vector<String>();
        this.loadHeaders();
        int count = 0;
        int i = 0;
        while (i < this.memberHeaders.length) {
            String object_name = this.memberHeaders[i].getObjectName();
            if (names == null || this.stringInStrings(object_name, names)) {
                object_name = count + "_" + object_name;
                ++count;
                byte[] data = this.memberHeaders[i].getObjectData();
                File output = new File(outdir, object_name);
                names_used.add(object_name);
                RandomAccessFile rfile = new RandomAccessFile(output, "rw");
                rfile.write(data);
                rfile.close();
            }
            ++i;
        }
        return names_used.toArray(new String[0]);
    }

    private boolean stringInStrings(String str, String[] set) {
        int i = 0;
        while (i < set.length) {
            if (str.compareTo(set[i]) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.lstHeader != null) {
            buffer.append("LST HEADER VALUES").append(NL);
            buffer.append("system_id    = ").append(this.lstHeader.system_id).append(NL);
            buffer.append("a_magic      = ").append(this.lstHeader.a_magic).append(NL);
            buffer.append("version_id   = ").append(this.lstHeader.version_id).append(NL);
            buffer.append("module_count = ").append(this.lstHeader.module_count).append(NL);
            buffer.append("module_limit = ").append(this.lstHeader.module_limit).append(NL);
            buffer.append("dir_loc      = ").append(this.lstHeader.dir_loc).append(NL);
            int i = 0;
            while (i < this.memberHeaders.length) {
                buffer.append("MEMBER HEADER VALUES").append(NL);
                buffer.append("name      = ").append(this.memberHeaders[i].getObjectName()).append(NL);
                buffer.append("somOffset = ").append(this.memberHeaders[i].somOffset).append(NL);
                buffer.append("somSize   = ").append(this.memberHeaders[i].getSize()).append(NL);
                ++i;
            }
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        try {
            AR ar = new AR(args[0]);
            ar.getHeaders();
            ar.extractFiles(args[1]);
            System.out.println(ar);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class ARHeader {
        public static final int HEADER_SIZE = 60;
        private byte[] ar_name = new byte[16];
        private byte[] ar_date = new byte[12];
        private byte[] ar_uid = new byte[6];
        private byte[] ar_gid = new byte[6];
        private byte[] ar_mode = new byte[8];
        private byte[] ar_size = new byte[10];
        private byte[] ar_fmag = new byte[2];
        String name;
        public int somOffset;
        public int somSize;

        public ARHeader(long offset) throws IOException {
            try {
                AR.this.getRandomAccessFile();
                AR.this.file.seek(offset);
                AR.this.file.read(this.ar_name);
                int i = 0;
                while (i < 16) {
                    if (this.ar_name[i] == 47) {
                        this.name = new String(this.ar_name, 0, i);
                    }
                    ++i;
                }
                AR.this.file.read(this.ar_date);
                AR.this.file.read(this.ar_uid);
                AR.this.file.read(this.ar_gid);
                AR.this.file.read(this.ar_mode);
                AR.this.file.read(this.ar_size);
                AR.this.file.read(this.ar_fmag);
            }
            catch (IOException e) {
                AR.this.dispose();
                CCorePlugin.log(e);
            }
        }

        public String getObjectName() {
            return this.name;
        }

        public long getSize() {
            return this.somSize;
        }

        public byte[] getObjectData() throws IOException {
            byte[] temp = new byte[this.somSize];
            AR.this.file = AR.this.getRandomAccessFile();
            AR.this.file.seek(this.somOffset);
            AR.this.file.read(temp);
            AR.this.dispose();
            return temp;
        }

        public long getObjectDataOffset() {
            return this.somOffset;
        }
    }

    public class LSTHeader {
        public static final int LST_HEADER_OFFSET = 68;
        public static final int LST_HEADER_SIZE = 76;
        public short system_id;
        public short a_magic;
        public int version_id;
        public int file_time_sec;
        public int file_time_nano;
        public int hash_loc;
        public int hash_size;
        public int module_count;
        public int module_limit;
        public int dir_loc;
        public int export_loc;
        public int export_count;
        public int import_loc;
        public int aux_loc;
        public int aux_size;
        public int string_loc;
        public int string_size;
        public int free_list;
        public int file_end;
        public int checksum;

        public LSTHeader() throws IOException {
            try {
                AR.this.getRandomAccessFile();
                AR.this.file.seek(68L);
                byte[] lstRecord = new byte[76];
                AR.this.file.readFully(lstRecord);
                ReadMemoryAccess memory = new ReadMemoryAccess(lstRecord, false);
                this.system_id = memory.getShort();
                this.a_magic = memory.getShort();
                this.version_id = memory.getInt();
                this.file_time_sec = memory.getInt();
                this.file_time_nano = memory.getInt();
                this.hash_loc = memory.getInt();
                this.hash_size = memory.getInt();
                this.module_count = memory.getInt();
                this.module_limit = memory.getInt();
                this.dir_loc = memory.getInt();
                this.export_loc = memory.getInt();
                this.export_count = memory.getInt();
                this.import_loc = memory.getInt();
                this.aux_loc = memory.getInt();
                this.aux_size = memory.getInt();
                this.string_loc = memory.getInt();
                this.string_size = memory.getInt();
                this.free_list = memory.getInt();
                this.file_end = memory.getInt();
                this.checksum = memory.getInt();
            }
            catch (IOException e) {
                AR.this.dispose();
                CCorePlugin.log(e);
            }
        }
    }
}

