/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNewDescriptor;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTypeId;

public class ASTNewExpression
extends ASTExpression {
    private final IASTTypeId typeId;
    private final IASTExpression.IASTNewExpressionDescriptor newDescriptor;

    public ASTNewExpression(IASTExpression.Kind kind, List references, IASTExpression.IASTNewExpressionDescriptor newDescriptor, IASTTypeId typeId) {
        super(kind, references);
        this.newDescriptor = newDescriptor;
        this.typeId = typeId;
    }

    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    public IASTExpression.IASTNewExpressionDescriptor getNewExpressionDescriptor() {
        return this.newDescriptor;
    }

    protected void processCallbacks(ISourceElementRequestor requestor) {
        super.processCallbacks(requestor);
        this.typeId.acceptElement(requestor);
        this.newDescriptor.acceptElement(requestor);
    }

    public IASTExpression findNewDescriptor(ITokenDuple finalDuple) {
        if (((ASTTypeId)this.typeId).getTokenDuple().contains(finalDuple)) {
            return this;
        }
        return null;
    }

    public void freeReferences() {
        super.freeReferences();
        this.typeId.freeReferences();
    }

    public String toString() {
        return ASTUtil.getExpressionString(this);
    }

    public ASTExpression findOwnerExpressionForIDExpression(ITokenDuple duple) {
        ASTTypeId ti = (ASTTypeId)this.getTypeId();
        ITokenDuple typeDuple = ti.getTokenDuple();
        if (typeDuple.equals(duple)) {
            return this;
        }
        if (typeDuple.contains(duple)) {
            return this;
        }
        ASTExpression ownerExpression = null;
        ASTNewDescriptor nd = (ASTNewDescriptor)this.getNewExpressionDescriptor();
        List newInitializerExpressions = nd.getNewInitializerExpressionsList();
        int size = newInitializerExpressions.size();
        int i = 0;
        while (i < size) {
            ASTExpression expressionList = (ASTExpression)newInitializerExpressions.get(i);
            ownerExpression = expressionList.findOwnerExpressionForIDExpression(duple);
            if (ownerExpression != null) break;
            ++i;
        }
        return ownerExpression;
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
    }

    public int getStartingOffset() {
        return 0;
    }

    public int getEndingOffset() {
        return 0;
    }

    public int getStartingLine() {
        return 0;
    }

    public int getEndingLine() {
        return 0;
    }

    public char[] getFilename() {
        return null;
    }
}

