/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OptionReference
implements IOption {
    private static final String EMPTY_STRING = new String();
    private List builtIns;
    private String command;
    private IOption option;
    private ToolReference owner;
    private Object value;
    private boolean resolved = true;

    public OptionReference(ToolReference owner, IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.resolved = false;
        this.owner = owner;
        owner.addOptionReference(this);
    }

    public OptionReference(ToolReference owner, IOption option) {
        this.owner = owner;
        this.option = option;
        owner.addOptionReference(this);
    }

    public OptionReference(ToolReference owner, Element element) {
        int optValType;
        this.owner = owner;
        try {
            this.option = owner.getTool().getOptionById(element.getAttribute("id"));
        }
        catch (NullPointerException nullPointerException) {
            this.option = null;
        }
        if (this.option == null) {
            return;
        }
        try {
            optValType = this.option.getValueType();
        }
        catch (BuildException buildException) {
            return;
        }
        owner.addOptionReference(this);
        switch (optValType) {
            case 0: {
                this.value = new Boolean(element.getAttribute("defaultValue"));
                break;
            }
            case 1: 
            case 2: {
                this.value = element.getAttribute("defaultValue");
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ArrayList<String> valueList = new ArrayList<String>();
                NodeList nodes = element.getElementsByTagName("listOptionValue");
                int i = 0;
                while (i < nodes.getLength()) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() == 1) {
                        Boolean isBuiltIn = new Boolean(((Element)node).getAttribute("builtIn"));
                        if (isBuiltIn.booleanValue()) {
                            this.getBuiltInList().add(((Element)node).getAttribute("value"));
                        } else {
                            valueList.add(((Element)node).getAttribute("value"));
                        }
                    }
                    ++i;
                }
                this.value = valueList;
            }
        }
    }

    public void resolveReferences() {
        if (!this.resolved) {
            int optValType;
            this.resolved = true;
            IManagedConfigElement element = ManagedBuildManager.getConfigElement(this);
            this.option = this.owner.getTool().getOptionById(element.getAttribute("id"));
            if (this.option == null) {
                this.resolved = false;
                return;
            }
            if (this.option instanceof Option) {
                ((Option)this.option).resolveReferences();
            } else if (this.option instanceof OptionReference) {
                ((OptionReference)this.option).resolveReferences();
            }
            try {
                optValType = this.option.getValueType();
            }
            catch (BuildException buildException) {
                return;
            }
            switch (optValType) {
                case 0: {
                    this.value = new Boolean(element.getAttribute("defaultValue"));
                    break;
                }
                case 2: {
                    this.value = element.getAttribute("defaultValue");
                    break;
                }
                case 1: {
                    String temp = element.getAttribute("defaultValue");
                    if (temp == null) break;
                    this.value = temp;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ArrayList<String> valueList = new ArrayList<String>();
                    IManagedConfigElement[] valueElements = element.getChildren("listOptionValue");
                    int i = 0;
                    while (i < valueElements.length) {
                        IManagedConfigElement valueElement = valueElements[i];
                        Boolean isBuiltIn = new Boolean(valueElement.getAttribute("builtIn"));
                        if (isBuiltIn.booleanValue()) {
                            this.getBuiltInList().add(valueElement.getAttribute("value"));
                        } else {
                            valueList.add(valueElement.getAttribute("value"));
                        }
                        ++i;
                    }
                    this.value = valueList;
                }
            }
        }
    }

    public void serialize(Document doc, Element element) {
        int optValType;
        element.setAttribute("id", this.option.getId());
        try {
            optValType = this.option.getValueType();
        }
        catch (BuildException buildException) {
            return;
        }
        switch (optValType) {
            case 0: {
                element.setAttribute("defaultValue", ((Boolean)this.value).toString());
                break;
            }
            case 1: 
            case 2: {
                element.setAttribute("defaultValue", (String)this.value);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Element valueElement;
                ArrayList stringList = (ArrayList)this.value;
                ListIterator iter = stringList.listIterator();
                while (iter.hasNext()) {
                    valueElement = doc.createElement("listOptionValue");
                    valueElement.setAttribute("value", (String)iter.next());
                    valueElement.setAttribute("builtIn", "false");
                    element.appendChild(valueElement);
                }
                if (this.builtIns == null) break;
                iter = this.builtIns.listIterator();
                while (iter.hasNext()) {
                    valueElement = doc.createElement("listOptionValue");
                    valueElement.setAttribute("value", (String)iter.next());
                    valueElement.setAttribute("builtIn", "true");
                    element.appendChild(valueElement);
                }
                break;
            }
        }
    }

    public String[] getApplicableValues() {
        return this.option.getApplicableValues();
    }

    public IOptionCategory getCategory() {
        return this.option.getCategory();
    }

    public String getCommand() {
        return this.option.getCommand();
    }

    public String getCommandFalse() {
        return this.option.getCommandFalse();
    }

    public String[] getDefinedSymbols() throws BuildException {
        if (this.value == null) {
            return this.option.getDefinedSymbols();
        }
        if (this.getValueType() == 5) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    public String getEnumCommand(String id) {
        if (!this.resolved) {
            this.resolveReferences();
        }
        if (this.option != null) {
            try {
                String command = this.option.getEnumCommand(id);
                return command;
            }
            catch (BuildException buildException) {}
        }
        return new String();
    }

    public String getEnumName(String id) {
        if (!this.resolved) {
            this.resolveReferences();
        }
        if (this.option != null) {
            try {
                String name = this.option.getEnumName(id);
                return name;
            }
            catch (BuildException buildException) {}
        }
        return new String();
    }

    public String getEnumeratedId(String name) {
        if (!this.resolved) {
            this.resolveReferences();
        }
        if (this.option != null) {
            try {
                String id = this.option.getEnumeratedId(name);
                return id;
            }
            catch (BuildException buildException) {}
        }
        return new String();
    }

    public String getId() {
        return this.option.getId();
    }

    public String[] getIncludePaths() throws BuildException {
        if (this.value == null) {
            return this.option.getIncludePaths();
        }
        if (this.getValueType() == 4) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    public String[] getLibraries() throws BuildException {
        if (this.value == null) {
            return this.option.getLibraries();
        }
        if (this.getValueType() == 6) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    public String getName() {
        return this.option.getName();
    }

    public boolean getBooleanValue() throws BuildException {
        if (this.value == null) {
            return this.option.getBooleanValue();
        }
        if (this.getValueType() == 0) {
            Boolean bool = (Boolean)this.value;
            return bool;
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    public int getBrowseType() {
        return this.option.getBrowseType();
    }

    private List getBuiltInList() {
        if (this.builtIns == null) {
            this.builtIns = new ArrayList();
        }
        return this.builtIns;
    }

    public String[] getBuiltIns() {
        ArrayList<String> answer = new ArrayList<String>();
        if (this.builtIns != null) {
            answer.addAll(this.builtIns);
        }
        if (this.option != null) {
            String[] optionBuiltIns = this.option.getBuiltIns();
            int index = 0;
            while (index < optionBuiltIns.length) {
                if (!answer.contains(optionBuiltIns[index])) {
                    answer.add(optionBuiltIns[index]);
                }
                ++index;
            }
        }
        return answer.toArray(new String[answer.size()]);
    }

    public IOption getOption() {
        if (!this.resolved) {
            this.resolveReferences();
        }
        return this.option;
    }

    public String getSelectedEnum() throws BuildException {
        if (this.value == null) {
            return this.option.getSelectedEnum();
        }
        if (this.getValueType() == 1) {
            return (String)this.value;
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    public String[] getStringListValue() throws BuildException {
        if (this.value == null) {
            return this.option.getStringListValue();
        }
        if (this.getValueType() == 3) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    public String getStringValue() throws BuildException {
        if (this.value == null) {
            return this.option.getStringValue();
        }
        if (this.getValueType() == 2) {
            return (String)this.value;
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    public ITool getParent() {
        return this.owner;
    }

    public ToolReference getToolReference() {
        return this.owner;
    }

    public String[] getUserObjects() throws BuildException {
        if (this.value == null) {
            return this.option.getDefinedSymbols();
        }
        if (this.getValueType() == 7) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    public int getValueType() {
        int optValType;
        try {
            optValType = this.option.getValueType();
        }
        catch (BuildException buildException) {
            return -1;
        }
        return optValType;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean references(IOption target) {
        if (this.equals(target)) {
            return true;
        }
        if (this.option instanceof OptionReference) {
            return ((OptionReference)this.option).references(target);
        }
        return this.option.equals(target);
    }

    public void setValue(boolean value) throws BuildException {
        if (this.getValueType() != 0) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        this.value = new Boolean(value);
    }

    public void setValue(String value) throws BuildException {
        if (this.getValueType() != 2 && this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        this.value = value;
    }

    public void setValue(String[] value) throws BuildException {
        if (this.getValueType() != 3 && this.getValueType() != 4 && this.getValueType() != 5 && this.getValueType() != 6 && this.getValueType() != 7) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        this.value = new ArrayList<String>(Arrays.asList(value));
    }

    public String toString() {
        String answer = new String();
        if (this.option != null) {
            answer = String.valueOf(answer) + "Reference to " + this.option.getName();
        }
        if (answer.length() > 0) {
            return answer;
        }
        return super.toString();
    }

    public boolean isExtensionElement() {
        return false;
    }

    public boolean overridesOnlyValue() {
        return false;
    }

    public void setValue(Object v) {
        this.value = v;
    }

    public void setValueType(int type) {
    }

    public Object getDefaultValue() {
        return this.value;
    }

    public void setDefaultValue(Object v) {
    }

    public IOption getSuperClass() {
        return null;
    }

    public int getResourceFilter() {
        return 0;
    }

    public void setResourceFilter(int filter) {
    }

    public void setBrowseType(int type) {
    }

    public void setCategory(IOptionCategory category) {
    }

    public void setCommand(String cmd) {
        if (cmd == null && this.command == null) {
            return;
        }
        if (cmd == null || this.command == null || !cmd.equals(this.command)) {
            this.command = cmd;
        }
    }

    public void setCommandFalse(String cmd) {
    }
}

