/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.wizards;

import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.part.WizardCheckboxTablePart;
import org.eclipse.cdt.make.internal.ui.wizards.StatusWizardPage;
import org.eclipse.cdt.make.ui.actions.UpdateMakeProjectAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class UpdateMakeProjectWizardPage
extends StatusWizardPage {
    private static final String MAKE_UPDATE_TITLE = "MakeWizardUpdatePage.title";
    private static final String MAKE_UPDATE_DESCRIPTION = "MakeWizardUpdatePage.description";
    private IProject[] selected;
    private CheckboxTableViewer makeProjectListViewer;
    private TablePart tablePart;

    public UpdateMakeProjectWizardPage(IProject[] selected) {
        super("UpdateMakeProjectWizardPage", true);
        this.setTitle(MakeUIPlugin.getResourceString(MAKE_UPDATE_TITLE));
        this.setDescription(MakeUIPlugin.getResourceString(MAKE_UPDATE_DESCRIPTION));
        this.selected = selected;
        this.tablePart = new TablePart(MakeUIPlugin.getResourceString("MakeWizardUpdatePage.projectList"));
    }

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        this.tablePart.createControl(container);
        this.makeProjectListViewer = this.tablePart.getTableViewer();
        this.makeProjectListViewer.setContentProvider((IContentProvider)new MakeProjectContentProvider());
        this.makeProjectListViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        GridData gd = (GridData)this.tablePart.getControl().getLayoutData();
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.makeProjectListViewer.setInput((Object)MakeUIPlugin.getWorkspace().getRoot());
        this.tablePart.setSelection(this.selected);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    public void storeSettings() {
    }

    public Object[] getSelected() {
        return this.tablePart.getSelection();
    }

    void dialogChanged() {
        IStatus genStatus = this.validatePlugins();
        this.updateStatus(genStatus);
    }

    private IStatus validatePlugins() {
        IProject[] allModels = UpdateMakeProjectAction.getOldProjects();
        if (allModels == null || allModels.length == 0) {
            return StatusWizardPage.createStatus(4, MakeUIPlugin.getResourceString("MakeWizardUpdatePage.status.noProjectsToUpdate"));
        }
        if (this.tablePart.getSelectionCount() == 0) {
            return StatusWizardPage.createStatus(4, MakeUIPlugin.getResourceString("MakeWizardUpdatePage.status.noProjectsSelected"));
        }
        return StatusWizardPage.createStatus(0, "");
    }

    public class MakeProjectContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            return UpdateMakeProjectAction.getOldProjects();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel) {
            super(mainLabel);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            UpdateMakeProjectWizardPage.this.dialogChanged();
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style);
            return viewer;
        }
    }
}

