/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.index;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class Indexer {
    private static Indexer indexer = null;
    private static IndexManager manager = CCorePlugin.getDefault().getCoreModel().getIndexManager();

    public static boolean indexEnabledOnAllProjects() {
        IProject[] projects = CCorePlugin.getWorkspace().getRoot().getProjects();
        boolean allEnabled = true;
        int i = 0;
        while (i < projects.length) {
            if (!Indexer.indexEnabledOnProject(projects[i])) {
                allEnabled = false;
                break;
            }
            ++i;
        }
        return allEnabled;
    }

    public static boolean indexEnabledOnAnyProjects() {
        IProject[] projects = CCorePlugin.getWorkspace().getRoot().getProjects();
        boolean allEnabled = false;
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen() && Indexer.indexEnabledOnProject(projects[i])) {
                allEnabled = true;
                break;
            }
            ++i;
        }
        return allEnabled;
    }

    public static boolean indexEnabledOnProject(IProject project) {
        boolean allEnabled = true;
        try {
            Boolean indexValue = (Boolean)project.getSessionProperty(IndexManager.activationKey);
            if (indexValue != null) {
                if (!indexValue.booleanValue()) {
                    allEnabled = false;
                }
            } else if (!manager.isIndexEnabled(project)) {
                allEnabled = false;
            }
        }
        catch (CoreException coreException) {}
        return allEnabled;
    }
}

