/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuildOptionBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ResourceBuildPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IPreferencePageContainer,
ICOptionContainer {
    private static final String PREFIX = "ResourceBuildPropertyPage";
    private static final String LABEL = "ResourceBuildPropertyPage.label";
    private static final String NAME_LABEL = "ResourceBuildPropertyPage.label.NameText";
    private static final String CONFIG_LABEL = "ResourceBuildPropertyPage.label.Configuration";
    private static final String ALL_CONFS = "ResourceBuildPropertyPage.selection.configuration.all";
    private static final String ACTIVE_RESOURCE_LABEL = "ResourceBuildPropertyPage.label.ActiveResource";
    private static final String RESOURCE_SETTINGS_LABEL = "ResourceBuildPropertyPage.label.ResourceSettings";
    private static final String TREE_LABEL = "ResourceBuildPropertyPage.label.ToolTree";
    private static final String OPTIONS_LABEL = "ResourceBuildPropertyPage.label.ToolOptions";
    private static final String NOTMBSFILE_LABEL = "ResourceBuildPropertyPage.label.NotMBSFile";
    private static final String EXCLUDE_CHECKBOX = "ResourceBuildPropertyPage.label.ExcludeCheckBox";
    private static final String TIP = "ResourceBuildPropertyPage.tip";
    private static final String RESOURCE_PLAT_TIP = "ResourceBuildPropertyPage.tip.ResourcePlatform";
    private static final String CONF_TIP = "ResourceBuildPropertyPage.tip.config";
    private static final String EXCLUDE_TIP = "ResourceBuildPropertyPage.tip.excludecheck";
    private static final String MANAGE_TITLE = "ResourceBuildPropertyPage.manage.title";
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{20, 30};
    private static final String ID_SEPARATOR = ".";
    private Combo configSelector;
    private Button excludedCheckBox;
    private boolean isExcluded = false;
    private boolean noContentOnPage = false;
    private IConfiguration[] configurations;
    private IConfiguration selectedConfiguration;
    private IResourceConfiguration currentResourceConfig;
    private Point lastShellSize;
    protected ManagedBuildOptionBlock fOptionBlock;
    protected boolean displayedConfig = false;

    public void setContainer(IPreferencePageContainer preferencePageContainer) {
        super.setContainer(preferencePageContainer);
        if (this.fOptionBlock == null) {
            this.fOptionBlock = new ManagedBuildOptionBlock(this);
        }
    }

    protected Control createContents(Composite parent) {
        boolean openMBSProject;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        try {
            openMBSProject = this.getProject().hasNature(ManagedCProjectNature.MNG_NATURE_ID);
        }
        catch (CoreException coreException) {
            openMBSProject = false;
        }
        if (openMBSProject) {
            this.contentForMBSFile(composite);
        } else {
            this.noContent(composite);
        }
        return composite;
    }

    protected void contentForMBSFile(Composite composite) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (info.getVersion() == null) {
            Label invalidInfo = new Label(composite, 16384);
            invalidInfo.setFont(composite.getFont());
            invalidInfo.setText(ManagedBuilderUIMessages.getResourceString("ResourceBuildPropertyPage.error.version_low"));
            invalidInfo.setLayoutData((Object)new GridData(32, 4, true, true));
            this.noContentOnPage = true;
            this.noDefaultAndApplyButton();
            return;
        }
        Group configGroup = ControlFactory.createGroup((Composite)composite, (String)ManagedBuilderUIMessages.getResourceString(ACTIVE_RESOURCE_LABEL), (int)1);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        configGroup.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        form.marginHeight = 5;
        form.marginWidth = 5;
        configGroup.setLayout((Layout)form);
        this.excludedCheckBox = ControlFactory.createCheckBox((Composite)configGroup, (String)ManagedBuilderUIMessages.getResourceString(EXCLUDE_CHECKBOX));
        this.excludedCheckBox.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResourceBuildPropertyPage.this.handleIsExcluded();
            }
        });
        this.excludedCheckBox.setToolTipText(ManagedBuilderUIMessages.getResourceString(EXCLUDE_TIP));
        FormData fd = new FormData();
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.excludedCheckBox, 0, 0x1000000);
        this.excludedCheckBox.setLayoutData((Object)fd);
        Label configLabel = ControlFactory.createLabel((Composite)configGroup, (String)ManagedBuilderUIMessages.getResourceString(CONFIG_LABEL));
        this.configSelector = new Combo((Composite)configGroup, 12);
        this.configSelector.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResourceBuildPropertyPage.this.handleConfigSelection();
            }
        });
        this.configSelector.setToolTipText(ManagedBuilderUIMessages.getResourceString(CONF_TIP));
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.excludedCheckBox, 15, -1);
        configLabel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.excludedCheckBox, 15, -1);
        fd.left = new FormAttachment((Control)configLabel, 5, -1);
        fd.right = new FormAttachment(80, -20);
        this.configSelector.setLayoutData((Object)fd);
        Group tabGroup = ControlFactory.createGroup((Composite)composite, (String)ManagedBuilderUIMessages.getResourceString(RESOURCE_SETTINGS_LABEL), (int)1);
        gd = new GridData(1808);
        tabGroup.setLayoutData((Object)gd);
        this.fOptionBlock.createContents((Composite)tabGroup, this.getElement());
        this.populateConfigurations();
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.cdt.ui.man_prop_build");
    }

    protected void noContent(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(ManagedBuilderUIMessages.getResourceString(NOTMBSFILE_LABEL));
        label.setFont(composite.getFont());
        this.noContentOnPage = true;
        this.noDefaultAndApplyButton();
    }

    private void handleIsExcluded() {
        boolean isSelected = this.excludedCheckBox.getSelection();
        this.setExcluded(isSelected);
    }

    private String[] getConfigurationNames() {
        String[] names = new String[this.configurations.length];
        int index = 0;
        while (index < this.configurations.length) {
            names[index] = this.configurations[index].getName();
            ++index;
        }
        return names;
    }

    protected Point getLastShellSize() {
        Shell shell;
        if (this.lastShellSize == null && (shell = this.getShell()) != null) {
            this.lastShellSize = shell.getSize();
        }
        return this.lastShellSize;
    }

    public IProject getProject() {
        IAdaptable element = this.getElement();
        if (element != null && element instanceof IFile) {
            IFile file = (IFile)element;
            return file.getProject();
        }
        return null;
    }

    public IConfiguration getSelectedConfiguration() {
        return this.selectedConfiguration;
    }

    private void handleConfigSelection() {
        if (this.configSelector.getItemCount() == 0) {
            return;
        }
        int selectionIndex = this.configSelector.getSelectionIndex();
        if (selectionIndex == -1) {
            return;
        }
        String configName = this.configSelector.getItem(selectionIndex);
        if (configName.equals(ManagedBuilderUIMessages.getResourceString(ALL_CONFS))) {
            return;
        }
        IConfiguration newConfig = this.configurations[selectionIndex];
        if (newConfig != this.selectedConfiguration) {
            Shell shell;
            boolean shouldApply;
            if (this.selectedConfiguration != null && this.fOptionBlock.isDirty() && (shouldApply = MessageDialog.openQuestion((Shell)(shell = ManagedBuilderUIPlugin.getDefault().getShell()), (String)ManagedBuilderUIMessages.getResourceString("BuildPropertyPage.changes.save.title"), (String)ManagedBuilderUIMessages.getFormattedString("BuildPropertyPage.changes.save.question", new String[]{this.selectedConfiguration.getName(), newConfig.getName()})))) {
                if (this.performOk()) {
                    this.fOptionBlock.setDirty(false);
                } else {
                    MessageDialog.openWarning((Shell)shell, (String)ManagedBuilderUIMessages.getResourceString("BuildPropertyPage.changes.save.title"), (String)ManagedBuilderUIMessages.getResourceString("BuildPropertyPage.changes.save.error"));
                }
            }
            this.selectedConfiguration = newConfig;
            ManagedBuildManager.setSelectedConfiguration((IProject)this.getProject(), (IConfiguration)this.selectedConfiguration);
            this.setCurrentResourceConfig(this.findCurrentResourceConfig());
            this.isExcluded = this.getCurrentResourceConfig().isExcluded();
            this.fOptionBlock.updateValues();
            this.excludedCheckBox.setSelection(this.isExcluded);
        }
    }

    protected void performDefaults() {
        this.fOptionBlock.performDefaults();
        this.excludedCheckBox.setSelection(this.getCurrentResourceConfig().isExcluded());
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.noContentOnPage) {
            return true;
        }
        if (!this.displayedConfig) {
            return true;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                ResourceBuildPropertyPage.this.fOptionBlock.performApply(monitor);
            }
        };
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getTargetException();
            ManagedBuilderUIPlugin.errorDialog(this.getShell(), ManagedBuilderUIMessages.getResourceString("ManagedProjectPropertyPage.internalError"), e1.toString(), e1);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)this.getProject(), (IConfiguration)this.getSelectedConfiguration());
        if (this.getCurrentResourceConfig().isExcluded() != this.isExcluded()) {
            this.getCurrentResourceConfig().setExclude(this.isExcluded());
            this.selectedConfiguration.setRebuildState(true);
        }
        ManagedBuildManager.saveBuildInfo((IProject)this.getProject(), (boolean)false);
        return true;
    }

    private void populateConfigurations() {
        ManagedBuildManager.setSelectedConfiguration((IProject)this.getProject(), (IConfiguration)this.selectedConfiguration);
        if (this.configSelector == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        this.configurations = info.getManagedProject().getConfigurations();
        if (this.configurations.length == 0) {
            return;
        }
        this.configSelector.removeAll();
        this.configSelector.setItems(this.getConfigurationNames());
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        int index = this.configSelector.indexOf(defaultConfig.getName());
        this.configSelector.select(index == -1 ? 0 : index);
        this.handleConfigSelection();
    }

    public IResourceConfiguration getCurrentResourceConfig() {
        return this.currentResourceConfig;
    }

    public void setCurrentResourceConfig(IResourceConfiguration currentResourceConfig) {
        if (currentResourceConfig != null) {
            this.currentResourceConfig = currentResourceConfig;
        } else {
            IFile file = (IFile)this.getElement();
            this.currentResourceConfig = this.selectedConfiguration.createResourceConfiguration(file);
        }
    }

    public IResourceConfiguration findCurrentResourceConfig() {
        IResourceConfiguration resConfigElement = null;
        if (this.selectedConfiguration.getResourceConfigurations().length == 0) {
            return null;
        }
        IResourceConfiguration[] resourceConfigurations = this.selectedConfiguration.getResourceConfigurations();
        IFile file = (IFile)this.getElement();
        int i = 0;
        while (i < resourceConfigurations.length) {
            resConfigElement = resourceConfigurations[i];
            if (file.getFullPath().toString().equals(resConfigElement.getResourcePath())) {
                return resConfigElement;
            }
            ++i;
        }
        return null;
    }

    public void updateButtons() {
    }

    public void updateMessage() {
    }

    public void updateTitle() {
    }

    public void updateContainer() {
        this.fOptionBlock.update();
        this.setValid(this.fOptionBlock.isValid());
        this.setErrorMessage(this.fOptionBlock.getErrorMessage());
    }

    public boolean isValid() {
        this.updateContainer();
        return super.isValid();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fOptionBlock.setVisible(visible);
        if (visible) {
            this.fOptionBlock.updateValues();
            this.displayedConfig = true;
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fOptionBlock.getPreferenceStore();
    }

    public IPreferenceStore getToolSettingsPreferenceStore() {
        return this.fOptionBlock.getToolSettingsPreferenceStore();
    }

    public Preferences getPreferences() {
        return null;
    }

    public void enableConfigSelection(boolean enable) {
        this.configSelector.setEnabled(enable);
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public void setExcluded(boolean isExcluded) {
        this.isExcluded = isExcluded;
    }
}

