/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CSearchPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo fExternLinks;
    private Button fExternEnabled;
    protected OverlayPreferenceStore fOverlayStore;
    private Text fTextControl;
    private static final String TIMEOUT_VALUE = "20000";

    public CSearchPreferencePage() {
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    private OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "externMatchEnable"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "externMatchVisible"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "CDT_INDEXER_TIMEOUT"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    protected Control createContents(Composite parent) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        result.setLayout((Layout)layout);
        Group indexerTimeoutGroup = new Group(result, 0);
        indexerTimeoutGroup.setLayout((Layout)new GridLayout());
        indexerTimeoutGroup.setLayoutData((Object)new GridData(768));
        indexerTimeoutGroup.setText(PreferencesMessages.getString("CSearchPreferences.IndexerTimeout.IndexerTimeoutGroup"));
        this.fTextControl = (Text)this.addTextField((Composite)indexerTimeoutGroup, PreferencesMessages.getString("CSearchPreferences.IndexerTimeout.Timeout"), "TimeOut", 6, 0, true);
        this.initialize();
        return result;
    }

    private void initialize() {
        this.fTextControl.setText(this.fOverlayStore.getString("CDT_INDEXER_TIMEOUT"));
    }

    public void init(IWorkbench workbench) {
    }

    private Combo createComboBox(Composite parent, String label, String[] items, String selection) {
        ControlFactory.createLabel(parent, label);
        Combo combo = ControlFactory.createSelectCombo(parent, items, selection);
        combo.setLayoutData((Object)new GridData());
        return combo;
    }

    private Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private Control addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        return textControl;
    }

    public boolean performOk() {
        String timeOut = this.fTextControl.getText();
        try {
            Integer.parseInt(timeOut);
        }
        catch (NumberFormatException numberFormatException) {
            timeOut = TIMEOUT_VALUE;
        }
        this.fOverlayStore.setValue("CDT_INDEXER_TIMEOUT", timeOut);
        this.fOverlayStore.propagate();
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        prefs.setValue("CDT_INDEXER_TIMEOUT", timeOut);
        CCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault("CDT_INDEXER_TIMEOUT", TIMEOUT_VALUE);
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initialize();
        super.performDefaults();
    }
}

