/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.io.OutputStream;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.internal.core.scannerconfig.ConsoleOutputSniffer;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoCollector;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.ScannerInfoConsoleParserUtility;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ScannerInfoConsoleParserFactory {
    public static ConsoleOutputSniffer getESIProviderOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject currentProject, IScannerConfigBuilderInfo scBuildInfo, IScannerInfoCollector collector) {
        if (scBuildInfo.isESIProviderCommandEnabled()) {
            IScannerInfoConsoleParser clParser = MakeCorePlugin.getDefault().getScannerInfoConsoleParser(scBuildInfo.getESIProviderConsoleParserId());
            clParser.startup(currentProject, null, collector);
            return new ConsoleOutputSniffer(outputStream, errorStream, new IScannerInfoConsoleParser[]{clParser});
        }
        return null;
    }

    public static ConsoleOutputSniffer getMakeBuilderOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject currentProject, IPath workingDirectory, IMarkerGenerator markerGenerator) {
        block5: {
            try {
                IScannerConfigBuilderInfo scBuildInfo;
                if (!currentProject.hasNature(ScannerConfigNature.NATURE_ID)) break block5;
                try {
                    scBuildInfo = MakeCorePlugin.createScannerConfigBuildInfo(currentProject, ScannerConfigBuilder.BUILDER_ID);
                }
                catch (CoreException coreException) {
                    scBuildInfo = null;
                }
                if (scBuildInfo != null && scBuildInfo.isAutoDiscoveryEnabled() && scBuildInfo.isMakeBuilderConsoleParserEnabled()) {
                    IScannerInfoConsoleParser clParser = MakeCorePlugin.getDefault().getScannerInfoConsoleParser(scBuildInfo.getMakeBuilderConsoleParserId());
                    clParser.startup(currentProject, new ScannerInfoConsoleParserUtility(currentProject, workingDirectory, (IMarkerGenerator)(scBuildInfo.isSIProblemGenerationEnabled() ? markerGenerator : null)), ScannerInfoCollector.getInstance());
                    return new ConsoleOutputSniffer(outputStream, errorStream, new IScannerInfoConsoleParser[]{clParser});
                }
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e.getStatus());
            }
        }
        return null;
    }
}

