/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtension;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.ICOwnerInfo;
import org.eclipse.cdt.internal.core.CDescriptorManager;
import org.eclipse.cdt.internal.core.CExtensionInfo;
import org.eclipse.cdt.internal.core.CExtensionReference;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.cdt.internal.core.InternalCExtension;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class CDescriptor
implements ICDescriptor {
    final CDescriptorManager fManager;
    final IProject fProject;
    private COwner fOwner;
    private HashMap extMap = new HashMap(4);
    private HashMap extInfoMap = new HashMap(4);
    private Document dataDoc;
    protected static final String DESCRIPTION_FILE_NAME = ".cdtproject";
    private static final String CEXTENSION_NAME = "cextension";
    private static final String PROJECT_DESCRIPTION = "cdtproject";
    private static final String PROJECT_OWNER_ID = "id";
    private static final String PROJECT_EXTENSION = "extension";
    private static final String PROJECT_EXTENSION_ATTR_POINT = "point";
    private static final String PROJECT_EXTENSION_ATTR_ID = "id";
    private static final String PROJECT_EXTENSION_ATTRIBUTE = "attribute";
    private static final String PROJECT_EXTENSION_ATTRIBUTE_KEY = "key";
    private static final String PROJECT_EXTENSION_ATTRIBUTE_VALUE = "value";
    private static final String PROJECT_DATA = "data";
    private static final String PROJECT_DATA_ITEM = "item";
    private static final String PROJECT_DATA_ID = "id";
    boolean fUpdating;
    boolean isInitializing = true;
    boolean bDirty = false;

    protected CDescriptor(CDescriptorManager manager, IProject project, String id) throws CoreException {
        String ownerID;
        IPath descriptionPath;
        this.fProject = project;
        this.fManager = manager;
        IPath projectLocation = project.getDescription().getLocation();
        if (projectLocation == null) {
            projectLocation = CDescriptor.getProjectDefaultLocation(project);
        }
        if ((descriptionPath = projectLocation.append(DESCRIPTION_FILE_NAME)).toFile().exists() && !(ownerID = this.readCDTProjectFile(descriptionPath)).equals("")) {
            Status status = ownerID.equals(id) ? new Status(2, "org.eclipse.cdt.core", 1, CCorePlugin.getResourceString("CDescriptor.exception.projectAlreadyExists"), null) : new Status(4, "org.eclipse.cdt.core", 2, String.valueOf(CCorePlugin.getResourceString("CDescriptor.exception.unmatchedOwnerId")) + "<requested:" + id + "/ In file:" + ownerID + ">", null);
            throw new CoreException((IStatus)status);
        }
        this.fOwner = new COwner(manager.getOwnerConfiguration(id));
        this.fOwner.configure(project, this);
        this.isInitializing = false;
        this.save();
    }

    protected CDescriptor(CDescriptorManager manager, IProject project) throws CoreException {
        IPath descriptionPath;
        this.fProject = project;
        this.fManager = manager;
        IPath projectLocation = project.getDescription().getLocation();
        if (projectLocation == null) {
            projectLocation = CDescriptor.getProjectDefaultLocation(project);
        }
        if (!(descriptionPath = projectLocation.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
            this.fOwner = new COwner(manager.getOwnerConfiguration(project));
            this.fOwner.configure(project, this);
            this.fManager.updateDescriptor(this);
        } else {
            String ownerId = this.readCDTProjectFile(descriptionPath);
            this.fOwner = new COwner(manager.getOwnerConfiguration(ownerId));
        }
        this.isInitializing = false;
    }

    protected CDescriptor(CDescriptorManager manager, IProject project, COwner owner) throws CoreException {
        IPath descriptionPath;
        this.fProject = project;
        this.fManager = manager;
        IPath projectLocation = project.getDescription().getLocation();
        if (projectLocation == null) {
            projectLocation = CDescriptor.getProjectDefaultLocation(project);
        }
        if ((descriptionPath = projectLocation.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
            this.readCDTProjectFile(descriptionPath);
        }
        this.fOwner = owner;
        this.fOwner.configure(project, this);
        this.isInitializing = false;
        this.save();
    }

    private String readCDTProjectFile(IPath descriptionPath) throws CoreException {
        String ownerID = "";
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(descriptionPath.toFile());
            NodeList nodeList = document.getElementsByTagName(PROJECT_DESCRIPTION);
            if (nodeList != null && nodeList.getLength() > 0) {
                Node node = nodeList.item(0);
                if (node.hasAttributes()) {
                    ownerID = node.getAttributes().getNamedItem("id").getNodeValue();
                }
                this.readProjectDescription(node);
                return ownerID;
            }
            Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptor.exception.missingElement"), null);
            throw new CoreException((IStatus)status);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, e.toString(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private static IPath getProjectDefaultLocation(IProject project) {
        return Platform.getLocation().append(project.getFullPath());
    }

    public ICOwnerInfo getProjectOwner() {
        return this.fOwner;
    }

    public String getPlatform() {
        return this.fOwner.getPlatform();
    }

    public IProject getProject() {
        return this.fProject;
    }

    public synchronized ICExtensionReference[] get(String extensionID) {
        ICExtensionReference[] refs = (CExtensionReference[])this.extMap.get(extensionID);
        if (refs == null) {
            return new ICExtensionReference[0];
        }
        return refs;
    }

    public synchronized ICExtensionReference[] get(String extensionID, boolean update) throws CoreException {
        ICExtensionReference[] refs = this.get(extensionID);
        if (refs.length == 0 && update) {
            boolean oldIsInitializing = this.isInitializing;
            this.isInitializing = true;
            this.fOwner.update(this.fProject, this, extensionID);
            this.isInitializing = oldIsInitializing;
            this.updateIfDirty();
            refs = this.get(extensionID);
        }
        return refs;
    }

    private CExtensionReference createRef(String extensionPoint, String extension) {
        CExtensionReference[] extensions = (CExtensionReference[])this.extMap.get(extensionPoint);
        if (extensions == null) {
            extensions = new CExtensionReference[1];
            this.extMap.put(extensionPoint, extensions);
        } else {
            CExtensionReference[] newExtensions = new CExtensionReference[extensions.length + 1];
            System.arraycopy(extensions, 0, newExtensions, 0, extensions.length);
            extensions = newExtensions;
            this.extMap.put(extensionPoint, extensions);
        }
        extensions[extensions.length - 1] = new CExtensionReference(this, extensionPoint, extension);
        return extensions[extensions.length - 1];
    }

    public synchronized ICExtensionReference create(String extensionPoint, String extension) throws CoreException {
        CExtensionReference extRef;
        boolean fireEvent = false;
        CDescriptor cDescriptor = this;
        synchronized (cDescriptor) {
            extRef = this.createRef(extensionPoint, extension);
            this.updateOnDisk();
            if (!this.isInitializing) {
                fireEvent = true;
            }
        }
        if (fireEvent) {
            this.fManager.fireEvent(new CDescriptorEvent(this, 1, 32));
        }
        return extRef;
    }

    public synchronized void remove(ICExtensionReference ext) throws CoreException {
        boolean fireEvent = false;
        CDescriptor cDescriptor = this;
        synchronized (cDescriptor) {
            CExtensionReference[] extensions = (CExtensionReference[])this.extMap.get(ext.getExtension());
            int i = 0;
            while (i < extensions.length) {
                if (extensions[i] == ext) {
                    System.arraycopy(extensions, i, extensions, i + 1, extensions.length - 1 - i);
                    if (extensions.length > 1) {
                        CExtensionReference[] newExtensions = new CExtensionReference[extensions.length - 1];
                        System.arraycopy(extensions, 0, newExtensions, 0, newExtensions.length);
                        this.extMap.put(ext.getExtension(), newExtensions);
                    } else {
                        this.extMap.remove(ext.getExtension());
                    }
                    this.updateOnDisk();
                    if (!this.isInitializing) {
                        fireEvent = true;
                    }
                }
                ++i;
            }
        }
        if (fireEvent) {
            this.fManager.fireEvent(new CDescriptorEvent(this, 1, 32));
        }
    }

    public void remove(String extensionPoint) throws CoreException {
        boolean fireEvent = false;
        CDescriptor cDescriptor = this;
        synchronized (cDescriptor) {
            CExtensionReference[] extensions = (CExtensionReference[])this.extMap.get(extensionPoint);
            if (extensions != null) {
                this.extMap.remove(extensionPoint);
                this.updateOnDisk();
                if (!this.isInitializing) {
                    fireEvent = true;
                }
            }
        }
        if (fireEvent) {
            this.fManager.fireEvent(new CDescriptorEvent(this, 1, 32));
        }
    }

    synchronized CExtensionInfo getInfo(CExtensionReference cProjectExtension) {
        CExtensionInfo info = (CExtensionInfo)this.extInfoMap.get(cProjectExtension);
        if (info == null) {
            info = new CExtensionInfo();
            this.extInfoMap.put(cProjectExtension, info);
        }
        return info;
    }

    protected IFile getFile() {
        return this.getProject().getFile(DESCRIPTION_FILE_NAME);
    }

    void save() throws CoreException {
        this.fManager.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor mon) throws CoreException {
                String xml;
                CDescriptor.this.bDirty = false;
                if (!CDescriptor.this.fProject.isAccessible()) {
                    return;
                }
                CDescriptor.this.fUpdating = true;
                try {
                    xml = CDescriptor.this.getAsXML();
                }
                catch (IOException e) {
                    Status s = new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)s);
                }
                catch (TransformerException e) {
                    Status s = new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)s);
                }
                catch (ParserConfigurationException e) {
                    Status s = new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)s);
                }
                IFile rscFile = CDescriptor.this.getFile();
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes("UTF8"));
                    if (rscFile.exists()) {
                        if (rscFile.isReadOnly()) {
                            CDescriptor.this.fManager.getWorkspace().validateEdit(new IFile[]{rscFile}, null);
                        }
                        rscFile.setContents((InputStream)inputStream, 1, null);
                    } else {
                        rscFile.create((InputStream)inputStream, 1, null);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    Status s = new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)s);
                }
                CDescriptor.this.fUpdating = false;
            }
        }, (ISchedulingRule)this.fProject, 1, null);
    }

    boolean isUpdating() {
        return this.fUpdating;
    }

    void updateIfDirty() {
        if (this.bDirty) {
            this.updateOnDisk();
        }
    }

    synchronized void updateOnDisk() {
        if (this.isUpdating()) {
            return;
        }
        if (this.isInitializing) {
            this.bDirty = true;
            return;
        }
        this.fUpdating = true;
        this.fManager.updateDescriptor(this);
    }

    void updateFromDisk() throws CoreException {
        HashMap origExtInfoMap;
        HashMap origExtMap;
        COwner origOwner;
        CDescriptor cDescriptor = this;
        synchronized (cDescriptor) {
            IPath descriptionPath;
            IPath projectLocation = this.fProject.getDescription().getLocation();
            if (projectLocation == null) {
                projectLocation = CDescriptor.getProjectDefaultLocation(this.fProject);
            }
            if (!(descriptionPath = projectLocation.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
                this.updateOnDisk();
                return;
            }
            origOwner = this.fOwner;
            origExtMap = this.extMap;
            origExtInfoMap = this.extInfoMap;
            Document origDataDoc = this.dataDoc;
            this.extMap = new HashMap(4);
            this.extInfoMap = new HashMap(4);
            this.dataDoc = null;
            try {
                String ownerId = this.readCDTProjectFile(descriptionPath);
                this.fOwner = new COwner(this.fManager.getOwnerConfiguration(ownerId));
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fOwner = origOwner;
                this.extMap = origExtMap;
                this.extInfoMap = origExtInfoMap;
                this.dataDoc = origDataDoc;
            }
        }
        if (!this.fOwner.equals(origOwner)) {
            this.fManager.fireEvent(new CDescriptorEvent(this, 1, 16));
        } else {
            boolean extChanges = true;
            if (this.extMap.size() == origExtMap.size() && this.extInfoMap.size() == origExtInfoMap.size()) {
                extChanges = false;
                Iterator entries = this.extMap.entrySet().iterator();
                while (entries.hasNext()) {
                    Object[] newExt;
                    Map.Entry entry = entries.next();
                    if (!origExtMap.containsKey(entry.getKey())) {
                        extChanges = true;
                        break;
                    }
                    Object[] origExt = (CExtensionReference[])origExtMap.get(entry.getKey());
                    if (Arrays.equals(origExt, newExt = (CExtensionReference[])entry.getValue())) continue;
                    extChanges = true;
                    break;
                }
            }
            if (extChanges) {
                this.fManager.fireEvent(new CDescriptorEvent(this, 1, 32));
            } else {
                this.fManager.fireEvent(new CDescriptorEvent(this, 1, 0));
            }
        }
    }

    private void readProjectDescription(Node node) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (childNode.getNodeType() == 1) {
                if (childNode.getNodeName().equals(PROJECT_EXTENSION)) {
                    try {
                        this.decodeProjectExtension((Element)childNode);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                } else if (childNode.getNodeName().equals(PROJECT_DATA)) {
                    try {
                        this.decodeProjectData((Element)childNode);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                }
            }
            ++i;
        }
    }

    private void decodeProjectExtension(Element element) throws CoreException {
        String point = element.getAttribute(PROJECT_EXTENSION_ATTR_POINT);
        String id = element.getAttribute("id");
        CExtensionReference ext = this.createRef(point, id);
        NodeList extAttrib = element.getChildNodes();
        int j = 0;
        while (j < extAttrib.getLength()) {
            if (extAttrib.item(j).getNodeName().equals(PROJECT_EXTENSION_ATTRIBUTE)) {
                NamedNodeMap attrib = extAttrib.item(j).getAttributes();
                this.getInfo(ext).setAttribute(attrib.getNamedItem(PROJECT_EXTENSION_ATTRIBUTE_KEY).getNodeValue(), attrib.getNamedItem(PROJECT_EXTENSION_ATTRIBUTE_VALUE).getNodeValue());
            }
            ++j;
        }
    }

    private void encodeProjectExtensions(Document doc, Element configRootElement) {
        Iterator extIterator = this.extMap.values().iterator();
        while (extIterator.hasNext()) {
            CExtensionReference[] extension = (CExtensionReference[])extIterator.next();
            int i = 0;
            while (i < extension.length) {
                Element element = doc.createElement(PROJECT_EXTENSION);
                configRootElement.appendChild(element);
                element.setAttribute(PROJECT_EXTENSION_ATTR_POINT, extension[i].getExtension());
                element.setAttribute("id", extension[i].getID());
                CExtensionInfo info = (CExtensionInfo)this.extInfoMap.get(extension[i]);
                if (info != null) {
                    Iterator attribIterator = info.getAttributes().entrySet().iterator();
                    while (attribIterator.hasNext()) {
                        Map.Entry entry = attribIterator.next();
                        Element extAttributes = doc.createElement(PROJECT_EXTENSION_ATTRIBUTE);
                        extAttributes.setAttribute(PROJECT_EXTENSION_ATTRIBUTE_KEY, (String)entry.getKey());
                        extAttributes.setAttribute(PROJECT_EXTENSION_ATTRIBUTE_VALUE, (String)entry.getValue());
                        element.appendChild(extAttributes);
                    }
                }
                ++i;
            }
        }
    }

    String getAsXML() throws IOException, TransformerException, ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        ProcessingInstruction version = doc.createProcessingInstruction("eclipse-cdt", "version=\"2.0\"");
        doc.appendChild(version);
        Element configRootElement = doc.createElement(PROJECT_DESCRIPTION);
        doc.appendChild(configRootElement);
        if (this.fOwner.getID().length() > 0) {
            configRootElement.setAttribute("id", this.fOwner.getID());
        }
        this.encodeProjectExtensions(doc, configRootElement);
        this.encodeProjectData(doc, configRootElement);
        return this.serializeDocument(doc);
    }

    protected ICExtension createExtensions(ICExtensionReference ext) throws CoreException {
        InternalCExtension cExtension = null;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(ext.getExtension());
        IExtension extension = extensionPoint.getExtension(ext.getID());
        if (extension == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, String.valueOf(CCorePlugin.getResourceString("CDescriptor.exception.providerNotFound")) + ":" + ext.getID(), null));
        }
        IConfigurationElement[] element = extension.getConfigurationElements();
        int i = 0;
        while (i < element.length) {
            if (element[i].getName().equalsIgnoreCase(CEXTENSION_NAME)) {
                cExtension = (InternalCExtension)((Object)element[i].createExecutableExtension("run"));
                cExtension.setExtenionReference(ext);
                cExtension.setProject(this.fProject);
                break;
            }
            ++i;
        }
        return (ICExtension)((Object)cExtension);
    }

    protected IConfigurationElement[] getConfigurationElement(ICExtensionReference ext) throws CoreException {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(ext.getExtension());
        IExtension extension = extensionPoint.getExtension(ext.getID());
        if (extension == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptor.exception.providerNotFound"), null));
        }
        IConfigurationElement[] element = extension.getConfigurationElements();
        int i = 0;
        while (i < element.length) {
            if (element[i].getName().equalsIgnoreCase(CEXTENSION_NAME)) {
                return element[i].getChildren();
            }
            ++i;
        }
        return new IConfigurationElement[0];
    }

    public synchronized Element getProjectData(String id) throws CoreException {
        Document doc = this.getProjectDataDoc();
        NodeList nodes = doc.getDocumentElement().getElementsByTagName(PROJECT_DATA_ITEM);
        int i = 0;
        while (i < nodes.getLength()) {
            Element element = (Element)nodes.item(i);
            if (element.getAttribute("id").equals(id)) {
                return element;
            }
            ++i;
        }
        Element element = doc.createElement(PROJECT_DATA_ITEM);
        element.setAttribute("id", id);
        doc.getDocumentElement().appendChild(element);
        return element;
    }

    public void saveProjectData() throws CoreException {
        this.save();
        this.fManager.fireEvent(new CDescriptorEvent(this, 1, 0));
    }

    private synchronized Document getProjectDataDoc() throws CoreException {
        if (this.dataDoc == null) {
            try {
                this.dataDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 4, CCorePlugin.getResourceString("CDescriptor.extension.internalError"), (Throwable)e));
            }
            Element rootElem = this.dataDoc.createElement(PROJECT_DATA);
            this.dataDoc.appendChild(rootElem);
        }
        return this.dataDoc;
    }

    private void decodeProjectData(Element data) throws CoreException {
        Document doc = this.getProjectDataDoc();
        doc.replaceChild(doc.importNode(data, true), doc.getDocumentElement());
    }

    private void encodeProjectData(Document doc, Element root) {
        if (this.dataDoc != null) {
            Element dataElements = this.dataDoc.getDocumentElement();
            NodeList nodes = dataElements.getElementsByTagName(PROJECT_DATA_ITEM);
            int i = 0;
            while (i < nodes.getLength()) {
                Element item = (Element)nodes.item(i);
                if (!item.hasChildNodes()) {
                    dataElements.removeChild(item);
                    --i;
                }
                ++i;
            }
            root.appendChild(doc.importNode(this.dataDoc.getDocumentElement(), true));
        }
    }

    private String serializeDocument(Document doc) throws IOException, TransformerException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }
}

