/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.impl.Util;

public class WordEntry {
    protected char[] fWord;
    protected int fNumRefs;
    protected int[] fRefs;
    protected int[] fRefsIndexFlags;

    public WordEntry() {
        this(CharOperation.NO_CHAR);
    }

    public WordEntry(char[] word) {
        this.fWord = word;
        this.fNumRefs = 0;
        this.fRefs = new int[1];
        this.fRefsIndexFlags = new int[1];
    }

    public int addRef(int fileNum, int indexFlags) {
        if (this.fNumRefs > 0 && this.fRefs[this.fNumRefs - 1] == fileNum) {
            return 0;
        }
        if (this.fNumRefs < this.fRefs.length) {
            int tempNumRefs = this.fNumRefs;
            this.fRefs[this.fNumRefs++] = fileNum;
            this.fRefsIndexFlags[tempNumRefs] = indexFlags;
            return 0;
        }
        int newSize = this.fNumRefs < 4 ? 4 : this.fNumRefs * 2;
        this.fRefs = new int[newSize];
        System.arraycopy(this.fRefs, 0, this.fRefs, 0, this.fNumRefs);
        this.fRefsIndexFlags = new int[newSize];
        System.arraycopy(this.fRefsIndexFlags, 0, this.fRefsIndexFlags, 0, this.fNumRefs);
        int tempNumRefs = this.fNumRefs;
        this.fRefs[this.fNumRefs++] = fileNum;
        this.fRefsIndexFlags[tempNumRefs] = indexFlags;
        return (newSize - this.fNumRefs + 1) * 4;
    }

    public void addRefs(int[] refs, int[] indexRefs) {
        int[] newRefs = new int[this.fNumRefs + refs.length];
        int[] newIndexRefs = new int[this.fNumRefs + indexRefs.length];
        int pos1 = 0;
        int pos2 = 0;
        int posNew = 0;
        int r1 = 0;
        int r2 = 0;
        int i1 = 0;
        int i2 = 0;
        while (pos1 < this.fNumRefs || pos2 < refs.length) {
            int compare;
            if (pos1 >= this.fNumRefs) {
                r2 = refs[pos2];
                i2 = indexRefs[pos2];
                compare = -1;
            } else if (pos2 >= refs.length) {
                compare = 1;
                r1 = this.fRefs[pos1];
                i1 = this.fRefsIndexFlags[pos1];
            } else {
                r1 = this.fRefs[pos1];
                r2 = refs[pos2];
                i1 = this.fRefsIndexFlags[pos1];
                i2 = indexRefs[pos2];
                compare = r2 - r1;
            }
            if (compare > 0) {
                newRefs[posNew] = r1;
                newIndexRefs[posNew] = i1;
                ++posNew;
                ++pos1;
                continue;
            }
            if (r2 != 0) {
                newRefs[posNew] = r2;
                newIndexRefs[posNew] = i2;
                ++posNew;
            }
            ++pos2;
        }
        this.fRefs = newRefs;
        this.fNumRefs = posNew;
        this.fRefsIndexFlags = newIndexRefs;
    }

    public int footprint() {
        return 24 + (8 + this.fWord.length * 2) + (8 + this.fRefs.length * 4) + (8 + this.fRefsIndexFlags.length * 4);
    }

    public int getNumRefs() {
        return this.fNumRefs;
    }

    public int getRef(int i) {
        if (i < this.fNumRefs) {
            return this.fRefs[i];
        }
        throw new IndexOutOfBoundsException();
    }

    public int getIndexFlag(int i) {
        if (i < this.fNumRefs) {
            return this.fRefsIndexFlags[i];
        }
        throw new IndexOutOfBoundsException();
    }

    public int[] getRefs() {
        int[] result = new int[this.fNumRefs];
        System.arraycopy(this.fRefs, 0, result, 0, this.fNumRefs);
        return result;
    }

    public int[] getRefsIndexFlags() {
        int[] result = new int[this.fNumRefs];
        System.arraycopy(this.fRefsIndexFlags, 0, result, 0, this.fNumRefs);
        return result;
    }

    public char[] getWord() {
        return this.fWord;
    }

    public void mapRefs(int[] mappings) {
        int position = 0;
        int position2 = 0;
        int i = 0;
        while (i < this.fNumRefs) {
            int map = -1;
            int map2 = -1;
            if (this.fRefs[i] >= 0 && this.fRefs[i] < mappings.length) {
                map = mappings[this.fRefs[i]];
            }
            if (map != -1 && map != 0) {
                this.fRefs[position++] = map;
            }
            if (this.fRefsIndexFlags[i] >= 0 && this.fRefsIndexFlags[i] < mappings.length) {
                map2 = mappings[this.fRefsIndexFlags[i]];
            }
            if (map2 != -1 && map2 != 0) {
                this.fRefsIndexFlags[position2++] = map2;
            }
            ++i;
        }
        this.fNumRefs = position;
        this.fRefs = new int[this.fNumRefs];
        System.arraycopy(this.fRefs, 0, this.fRefs, 0, this.fNumRefs);
        this.fRefsIndexFlags = new int[this.fNumRefs];
        System.arraycopy(this.fRefsIndexFlags, 0, this.fRefsIndexFlags, 0, this.fNumRefs);
        Util.sort(this.fRefs, this.fRefsIndexFlags);
    }

    public void reset(char[] word) {
        int i = this.fNumRefs;
        while (i-- > 0) {
            this.fRefs[i] = 0;
            this.fRefsIndexFlags[i] = 0;
        }
        this.fNumRefs = 0;
        this.fWord = word;
    }

    public String toString() {
        return new String(this.fWord);
    }

    public void catRefs(WordEntry word) {
        int[] wordFileRefs = word.fRefs;
        int[] cfr_ignored_0 = word.fRefsIndexFlags;
        ObjectSet set = new ObjectSet(4);
        int i = 0;
        while (i < wordFileRefs.length) {
            if (wordFileRefs[i] != 0) {
                set.put((Object)new Integer(wordFileRefs[i]));
            }
            ++i;
        }
        int[] mergedArray = new int[set.size()];
        int i2 = 0;
        while (i2 < set.size()) {
            mergedArray[i2] = (Integer)set.keyAt(i2);
            ++i2;
        }
        this.fRefs = new int[set.size()];
        System.arraycopy(mergedArray, 0, this.fRefs, 0, set.size());
        this.fNumRefs = set.size();
        Util.sort(this.fRefs);
    }
}

