/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CElementDeltaBuilder;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class CommitWorkingCopyOperation
extends CModelOperation {
    public CommitWorkingCopyOperation(ITranslationUnit element, boolean force) {
        super(new ICElement[]{element}, force);
    }

    public ISchedulingRule getSchedulingRule() {
        IResource resource = this.getElementToProcess().getResource();
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws CModelException {
        try {
            IBuffer copyBuffer;
            boolean hasSaved;
            char[] originalContents;
            IBuffer originalBuffer;
            CElementDeltaBuilder deltaBuilder;
            ITranslationUnit original;
            WorkingCopy copy;
            block12: {
                block13: {
                    this.beginTask("workingCopy.commit", 2);
                    copy = (WorkingCopy)this.getElementToProcess();
                    original = copy.getOriginalElement();
                    if (!original.isOpen()) {
                        original.open(null);
                    }
                    deltaBuilder = new CElementDeltaBuilder(original);
                    originalBuffer = original.getBuffer();
                    if (originalBuffer == null) {
                        Object var10_5 = null;
                        this.done();
                        return;
                    }
                    originalContents = originalBuffer.getCharacters();
                    hasSaved = false;
                    try {
                        copyBuffer = copy.getBuffer();
                        if (copyBuffer != null) break block12;
                        Object var8_12 = null;
                        if (hasSaved) break block13;
                        originalBuffer.setContents(originalContents);
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        if (hasSaved) throw throwable;
                        originalBuffer.setContents(originalContents);
                        throw throwable;
                    }
                }
                Object var10_6 = null;
                this.done();
                return;
            }
            originalBuffer.setContents(copyBuffer.getCharacters());
            original.save(this.fMonitor, this.fForce);
            this.hasModifiedResource = true;
            hasSaved = true;
            Object var8_14 = null;
            if (!hasSaved) {
                originalBuffer.setContents(originalContents);
            }
            copy.updateTimeStamp((TranslationUnit)original);
            copy.makeConsistent(this);
            this.worked(1);
            if (deltaBuilder != null) {
                deltaBuilder.buildDeltas();
                if (deltaBuilder.delta != null) {
                    this.addDelta(deltaBuilder.delta);
                }
            }
            this.worked(1);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            this.done();
            throw throwable;
        }
        this.done();
    }

    public ICModelStatus verify() {
        IWorkingCopy wc = (IWorkingCopy)this.getElementToProcess();
        if (!wc.isWorkingCopy()) {
            return new CModelStatus(967, wc);
        }
        ITranslationUnit original = wc.getOriginalElement();
        IResource resource = original.getResource();
        if (!wc.isBasedOn(resource) && !this.fForce) {
            return new CModelStatus(981);
        }
        return CModelStatus.VERIFIED_OK;
    }
}

