/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.Scanner2;

public class ScannerCallbackManager {
    private static final int bufferInitialSize = 8;
    private Object[] callbackStack = new Object[8];
    private int callbackPos = -1;
    private ISourceElementRequestor requestor;

    public ScannerCallbackManager(ISourceElementRequestor requestor) {
        this.requestor = requestor;
    }

    public void pushCallback(Object obj) {
        if (++this.callbackPos == this.callbackStack.length) {
            Object[] temp = new Object[this.callbackStack.length << 1];
            System.arraycopy(this.callbackStack, 0, temp, 0, this.callbackStack.length);
            this.callbackStack = temp;
        }
        this.callbackStack[this.callbackPos] = obj;
    }

    public void popCallbacks() {
        Object obj = null;
        int i = 0;
        while (i <= this.callbackPos) {
            obj = this.callbackStack[i];
            if (obj instanceof Scanner2.InclusionData) {
                this.requestor.enterInclusion(((Scanner2.InclusionData)obj).inclusion);
            } else if (obj instanceof IASTInclusion) {
                this.requestor.exitInclusion((IASTInclusion)obj);
            } else if (obj instanceof IASTMacro) {
                this.requestor.acceptMacro((IASTMacro)obj);
            } else if (obj instanceof IProblem) {
                this.requestor.acceptProblem((IProblem)obj);
            }
            ++i;
        }
        this.callbackPos = -1;
    }

    public boolean hasCallbacks() {
        return this.callbackPos != -1;
    }
}

