/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.AbstractCVariable;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.debug.core.DebugException;

public abstract class AbstractCValue
extends CDebugElement
implements ICValue {
    private AbstractCVariable fParent = null;

    public AbstractCValue(AbstractCVariable parent) {
        super((CDebugTarget)parent.getDebugTarget());
        this.fParent = parent;
    }

    public AbstractCVariable getParentVariable() {
        return this.fParent;
    }

    public String evaluateAsExpression(ICStackFrame frame) {
        String valueString = null;
        AbstractCVariable parent = this.getParentVariable();
        if (parent != null && frame != null && frame.canEvaluate()) {
            try {
                valueString = frame.evaluateExpressionToString(parent.getExpressionString());
            }
            catch (DebugException e) {
                valueString = e.getMessage();
            }
        }
        return valueString;
    }

    protected abstract void setChanged(boolean var1);

    public abstract void dispose();

    protected abstract void reset();

    protected abstract void preserve();
}

