/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.MemoryActionSelectionGroup;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.texteditor.IUpdate;

public class MemoryNumberOfColumnAction
extends Action
implements IUpdate {
    private MemoryActionSelectionGroup fGroup;
    private MemoryViewer fMemoryViewer;
    private int fNumberOfColumns = 0;

    public MemoryNumberOfColumnAction(MemoryActionSelectionGroup group, MemoryViewer viewer, int numberOfColumns) {
        super(MemoryNumberOfColumnAction.getLabel(numberOfColumns), 2);
        this.fGroup = group;
        this.fMemoryViewer = viewer;
        this.fNumberOfColumns = numberOfColumns;
    }

    private static String getLabel(int numberOfColumns) {
        return MessageFormat.format(ActionMessages.getString("MemoryNumberOfColumnAction.0"), new Integer(numberOfColumns));
    }

    public void update() {
        this.setEnabled(this.fMemoryViewer.canUpdate());
        this.setChecked(this.fMemoryViewer.getCurrentNumberOfColumns() == this.fNumberOfColumns);
    }

    public void run() {
        try {
            this.fMemoryViewer.setNumberOfColumns(this.fNumberOfColumns);
            this.fGroup.setCurrentSelection((IAction)this);
        }
        catch (DebugException e) {
            CDebugUIPlugin.errorDialog(ActionMessages.getString("MemoryNumberOfColumnAction.1"), e.getStatus());
            this.setChecked(false);
        }
    }

    public String getActionId() {
        return "MemoryNumberOfColumns" + this.fNumberOfColumns;
    }
}

