/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIMessages;
import org.eclipse.cdt.debug.mi.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.ListDialogField;
import org.eclipse.cdt.debug.mi.ui.IMILaunchConfigurationComponent;
import org.eclipse.cdt.debug.mi.ui.IPathProvider;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SolibSearchPathBlock
extends Observable
implements IMILaunchConfigurationComponent {
    private Composite fControl;
    private Shell fShell;
    private SolibSearchPathListDialogField fDirList;
    private IPathProvider fPathProvider;

    public SolibSearchPathBlock(IPathProvider pathProvider) {
        this.setPathProvider(pathProvider);
        int length = this.getPathProvider() != null ? 6 : 4;
        String[] buttonLabels = new String[length];
        buttonLabels[0] = MIUIMessages.getString("SolibSearchPathBlock.0");
        buttonLabels[1] = MIUIMessages.getString("SolibSearchPathBlock.1");
        buttonLabels[2] = MIUIMessages.getString("SolibSearchPathBlock.2");
        buttonLabels[3] = MIUIMessages.getString("SolibSearchPathBlock.3");
        if (buttonLabels.length == 6) {
            buttonLabels[4] = null;
            buttonLabels[5] = MIUIMessages.getString("SolibSearchPathBlock.Auto");
        }
        IListAdapter listAdapter = new IListAdapter(){

            public void customButtonPressed(DialogField field, int index) {
                SolibSearchPathBlock.this.buttonPressed(index);
            }

            public void selectionChanged(DialogField field) {
            }
        };
        this.fDirList = new SolibSearchPathListDialogField(listAdapter, buttonLabels, (ILabelProvider)new LabelProvider());
        this.fDirList.setLabelText(MIUIMessages.getString("SolibSearchPathBlock.4"));
        this.fDirList.setUpButtonIndex(1);
        this.fDirList.setDownButtonIndex(2);
        this.fDirList.setRemoveButtonIndex(3);
    }

    public void createControl(Composite parent) {
        this.fShell = parent.getShell();
        Composite comp = ControlFactory.createCompositeEx((Composite)parent, (int)2, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)comp.getLayout()).marginHeight = 0;
        ((GridLayout)comp.getLayout()).marginWidth = 0;
        comp.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)comp);
        this.fDirList.doFillIntoGrid(comp, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fDirList.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fDirList.getLabelControl(null), converter.convertWidthInCharsToPixels(30));
        LayoutUtil.setHorizontalGrabbing(this.fDirList.getListControl(null));
        this.fControl = comp;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.fDirList != null) {
            try {
                this.fDirList.addElements(configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST));
            }
            catch (CoreException coreException) {}
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fDirList != null) {
            configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, this.fDirList.getElements());
        }
    }

    protected void buttonPressed(int index) {
        switch (index) {
            case 0: {
                this.addDirectory();
                break;
            }
            case 5: {
                this.generatePaths();
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    protected Shell getShell() {
        return this.fShell;
    }

    private void addDirectory() {
        AddDirectoryDialog dialog = new AddDirectoryDialog(this.getShell());
        dialog.open();
        String result = dialog.getValue();
        if (result != null && !this.contains(result)) {
            this.fDirList.addElement(result.trim());
        }
    }

    public void dispose() {
        this.deleteObservers();
    }

    public Control getControl() {
        return this.fControl;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return false;
    }

    private void generatePaths() {
        IPathProvider pp = this.getPathProvider();
        if (pp != null) {
            IPath[] dirs = pp.getPaths();
            int i = 0;
            while (i < dirs.length) {
                if (!this.contains(dirs[i])) {
                    this.fDirList.addElement(dirs[i].toOSString());
                }
                ++i;
            }
        }
    }

    private IPathProvider getPathProvider() {
        return this.fPathProvider;
    }

    private void setPathProvider(IPathProvider pathProvider) {
        this.fPathProvider = pathProvider;
    }

    private boolean contains(IPath path) {
        List list = this.fDirList.getElements();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Path p = new Path((String)it.next());
            if (p.toFile().compareTo(path.toFile()) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean contains(String dir) {
        Path path = new Path(dir);
        List list = this.fDirList.getElements();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Path p = new Path((String)it.next());
            if (p.toFile().compareTo(path.toFile()) != 0) continue;
            return true;
        }
        return false;
    }

    class AddDirectoryDialog
    extends Dialog {
        protected Text fText;
        private Button fBrowseButton;
        private String fValue;

        public AddDirectoryDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite subComp = ControlFactory.createCompositeEx((Composite)composite, (int)2, (int)768);
            ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            subComp.setLayoutData((Object)data);
            subComp.setFont(parent.getFont());
            this.fText = new Text(subComp, 2052);
            this.fText.setLayoutData((Object)new GridData(768));
            this.fText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ AddDirectoryDialog this$1;
                {
                    this.this$1 = addDirectoryDialog;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.updateOKButton();
                }
            });
            this.fBrowseButton = ControlFactory.createPushButton((Composite)subComp, (String)MIUIMessages.getString("GDBServerDebuggerPage.7"));
            data = new GridData();
            data.horizontalAlignment = 4;
            data.widthHint = this.convertHorizontalDLUsToPixels(61);
            this.fBrowseButton.setLayoutData((Object)data);
            this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ AddDirectoryDialog this$1;
                {
                    this.this$1 = addDirectoryDialog;
                }

                public void widgetSelected(SelectionEvent evt) {
                    DirectoryDialog dialog = new DirectoryDialog(this.this$1.getShell());
                    dialog.setMessage(MIUIMessages.getString("SolibSearchPathBlock.5"));
                    String res = dialog.open();
                    if (res != null) {
                        this.this$1.fText.setText(res);
                    }
                }
            });
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(MIUIMessages.getString("SolibSearchPathBlock.Add_Directory"));
        }

        public String getValue() {
            return this.fValue;
        }

        private void setValue(String value) {
            this.fValue = value;
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.setValue(this.fText.getText());
            } else {
                this.setValue(null);
            }
            super.buttonPressed(buttonId);
        }

        protected void updateOKButton() {
            Button okButton = this.getButton(0);
            String text = this.fText.getText();
            okButton.setEnabled(this.isValid(text));
        }

        protected boolean isValid(String text) {
            return text.trim().length() > 0;
        }

        protected Control createButtonBar(Composite parent) {
            Control control = super.createButtonBar(parent);
            this.updateOKButton();
            return control;
        }
    }

    public class SolibSearchPathListDialogField
    extends ListDialogField {
        public SolibSearchPathListDialogField(IListAdapter adapter, String[] buttonLabels, ILabelProvider lprovider) {
            super(adapter, buttonLabels, lprovider);
        }

        protected boolean managedButtonPressed(int index) {
            boolean result = super.managedButtonPressed(index);
            if (result) {
                SolibSearchPathBlock.this.buttonPressed(index);
            }
            return result;
        }
    }
}

