/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.internal.ui.preferences.AbstractMakefileEditorPreferencePage;
import org.eclipse.cdt.make.internal.ui.preferences.ColorEditor;
import org.eclipse.cdt.make.internal.ui.preferences.MakefilePreferencesMessages;
import org.eclipse.cdt.make.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.make.internal.ui.preferences.TabFolderLayout;
import org.eclipse.cdt.make.internal.ui.text.ColorManager;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class MakefileEditorPreferencePage
extends AbstractMakefileEditorPreferencePage {
    private String[][] fSyntaxColorListModel;
    private TableViewer fHighlightingColorListViewer;
    private final List fHighlightingColorList = new ArrayList(5);
    org.eclipse.swt.widgets.List fAppearanceColorList;
    ColorEditor fAppearanceColorEditor;
    Button fAppearanceColorDefault;
    ColorEditor fSyntaxForegroundColorEditor;
    ColorEditor fBackgroundColorEditor;
    private Button fBackgroundDefaultRadioButton;
    Button fBackgroundCustomRadioButton;
    Button fBackgroundColorButton;
    Button fBoldCheckBox;
    Button fItalicCheckBox;
    protected Button fFoldingCheckbox;
    protected Map fWorkingValues;
    protected ArrayList fComboBoxes;
    final String[][] fAppearanceColorListModel;

    public MakefileEditorPreferencePage() {
        String[][] stringArrayArray = new String[5][];
        String[] stringArray = new String[3];
        stringArray[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.lineNumberForegroundColor");
        stringArray[1] = "lineNumberColor";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.currentLineHighlighColor");
        stringArray2[1] = "currentLineColor";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.printMarginColor");
        stringArray3[1] = "printMarginColor";
        stringArrayArray[2] = stringArray3;
        stringArrayArray[3] = new String[]{MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.foreground"), "AbstractTextEditor.Color.SelectionForeground", "AbstractTextEditor.Color.SelectionForeground.SystemDefault"};
        stringArrayArray[4] = new String[]{MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.background"), "AbstractTextEditor.Color.SelectionBackground", "AbstractTextEditor.Color.SelectionBackground.SystemDefault"};
        this.fAppearanceColorListModel = stringArrayArray;
    }

    protected OverlayPreferenceStore createOverlayStore() {
        String[][] stringArrayArray = new String[5][];
        String[] stringArray = new String[3];
        stringArray[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.makefile_editor_comment");
        stringArray[1] = "org.eclipse.cdt.make.ui.editor.comment";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.makefile_editor_macro_ref");
        stringArray2[1] = "org.eclipse.cdt.make.ui.editor.macro_ref";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.makefile_editor_macro_def");
        stringArray3[1] = "org.eclipse.cdt.make.ui.editor.macro_def";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.makefile_editor_function");
        stringArray4[1] = "org.eclipse.cdt.make.ui.editor.function";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.makefile_editor_keyword");
        stringArray5[1] = "org.eclipse.cdt.make.ui.editor.keyword";
        stringArrayArray[4] = stringArray5;
        this.fSyntaxColorListModel = stringArrayArray;
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Background.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.SelectionForeground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.SelectionForeground.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.SelectionBackground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.SelectionBackground.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "currentLineColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "printMarginColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "tabWidth"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "overviewRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "lineNumberColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "lineNumberRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_enabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_conditional"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_macrodef"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_rule"));
        int i = 0;
        while (i < this.fSyntaxColorListModel.length) {
            String colorKey = this.fSyntaxColorListModel[i][1];
            this.addTextKeyToCover(overlayKeys, colorKey);
            ++i;
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    private void addTextKeyToCover(ArrayList overlayKeys, String mainKey) {
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, mainKey));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, String.valueOf(mainKey) + "_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, String.valueOf(mainKey) + "_italic"));
    }

    protected Control createContents(Composite parent) {
        this.initializeDefaultColors();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IMakeHelpContextIds.MAKE_EDITOR_PREFERENCE_PAGE);
        this.getOverlayStore().load();
        this.getOverlayStore().start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.appearance"));
        item.setControl(this.createAppearancePage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.syntax"));
        item.setControl(this.createSyntaxPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.folding"));
        item.setControl((Control)this.createFoldingTabContent(folder));
        this.initialize();
        this.applyDialogFont((Composite)folder);
        return folder;
    }

    private void initializeDefaultColors() {
        RGB rgb;
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Background")) {
            rgb = this.getControl().getDisplay().getSystemColor(25).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.getOverlayStore(), (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Foreground")) {
            rgb = this.getControl().getDisplay().getSystemColor(24).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.getOverlayStore(), (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionBackground")) {
            rgb = this.getControl().getDisplay().getSystemColor(26).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.getOverlayStore(), (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionForeground")) {
            rgb = this.getControl().getDisplay().getSystemColor(27).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.getOverlayStore(), (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rgb);
        }
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        int n = this.fSyntaxColorListModel.length;
        while (i < n) {
            this.fHighlightingColorList.add(new HighlightingColorListItem(this.fSyntaxColorListModel[i][0], this.fSyntaxColorListModel[i][1], String.valueOf(this.fSyntaxColorListModel[i][1]) + "_bold", String.valueOf(this.fSyntaxColorListModel[i][1]) + "_italic", null));
            ++i;
        }
        this.fHighlightingColorListViewer.setInput((Object)this.fHighlightingColorList);
        this.fHighlightingColorListViewer.setSelection((ISelection)new StructuredSelection(this.fHighlightingColorListViewer.getElementAt(0)));
        i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
            ++i;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (MakefileEditorPreferencePage.this.fAppearanceColorList != null && !MakefileEditorPreferencePage.this.fAppearanceColorList.isDisposed()) {
                    MakefileEditorPreferencePage.this.fAppearanceColorList.select(0);
                    MakefileEditorPreferencePage.this.handleAppearanceColorListSelection();
                }
            }
        });
        this.initializeFolding();
        this.initializeBackgroundColorFields();
    }

    void initializeFolding() {
        boolean enabled = this.getOverlayStore().getBoolean("editor_folding_enabled");
        this.fFoldingCheckbox.setSelection(enabled);
    }

    void initializeDefaultFolding() {
        boolean enabled = this.getOverlayStore().getDefaultBoolean("editor_folding_enabled");
        this.fFoldingCheckbox.setSelection(enabled);
    }

    private void initializeBackgroundColorFields() {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getOverlayStore(), (String)"AbstractTextEditor.Color.Background");
        this.fBackgroundColorEditor.setColorValue(rgb);
        boolean dflt = this.getOverlayStore().getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        this.fBackgroundDefaultRadioButton.setSelection(dflt);
        this.fBackgroundCustomRadioButton.setSelection(!dflt);
        this.fBackgroundColorButton.setEnabled(!dflt);
    }

    protected void handleDefaults() {
        this.handleAppearanceColorListSelection();
        this.handleSyntaxColorListSelection();
        this.initializeBackgroundColorFields();
        this.initializeDefaultFolding();
    }

    private Control createSyntaxPage(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Group backgroundComposite = new Group(colorComposite, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        backgroundComposite.setLayout((Layout)layout);
        backgroundComposite.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.backcolor"));
        SelectionListener backgroundSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean custom = MakefileEditorPreferencePage.this.fBackgroundCustomRadioButton.getSelection();
                MakefileEditorPreferencePage.this.fBackgroundColorButton.setEnabled(custom);
                MakefileEditorPreferencePage.this.getOverlayStore().setValue("AbstractTextEditor.Color.Background.SystemDefault", !custom);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fBackgroundDefaultRadioButton = new Button((Composite)backgroundComposite, 16400);
        this.fBackgroundDefaultRadioButton.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.systemdefault"));
        this.fBackgroundDefaultRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundCustomRadioButton = new Button((Composite)backgroundComposite, 16400);
        this.fBackgroundCustomRadioButton.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.custom"));
        this.fBackgroundCustomRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundColorEditor = new ColorEditor((Composite)backgroundComposite);
        this.fBackgroundColorButton = this.fBackgroundColorEditor.getButton();
        Label label = new Label(colorComposite, 16384);
        label.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.Foreground"));
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer = new TableViewer(editorComposite, 68100);
        this.fHighlightingColorListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fHighlightingColorListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fHighlightingColorListViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fHighlightingColorListViewer.getControl().setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.bold"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.italic"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MakefileEditorPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = MakefileEditorPreferencePage.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)MakefileEditorPreferencePage.this.getOverlayStore(), (String)item.getColorKey(), (RGB)MakefileEditorPreferencePage.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBackgroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferenceConverter.setValue((IPreferenceStore)MakefileEditorPreferencePage.this.getOverlayStore(), (String)"AbstractTextEditor.Color.Background", (RGB)MakefileEditorPreferencePage.this.fBackgroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = MakefileEditorPreferencePage.this.getHighlightingColorListItem();
                MakefileEditorPreferencePage.this.getOverlayStore().setValue(item.getBoldKey(), MakefileEditorPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = MakefileEditorPreferencePage.this.getHighlightingColorListItem();
                MakefileEditorPreferencePage.this.getOverlayStore().setValue(item.getItalicKey(), MakefileEditorPreferencePage.this.fItalicCheckBox.getSelection());
            }
        });
        return colorComposite;
    }

    void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getOverlayStore(), (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
        this.updateAppearanceColorWidgets(this.fAppearanceColorListModel[i][2]);
    }

    private void updateAppearanceColorWidgets(String systemDefaultKey) {
        if (systemDefaultKey == null) {
            this.fAppearanceColorDefault.setSelection(false);
            this.fAppearanceColorDefault.setVisible(false);
            this.fAppearanceColorEditor.getButton().setEnabled(true);
        } else {
            boolean systemDefault = this.getOverlayStore().getBoolean(systemDefaultKey);
            this.fAppearanceColorDefault.setSelection(systemDefault);
            this.fAppearanceColorDefault.setVisible(true);
            this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
        }
    }

    private Control createAppearancePage(Composite parent) {
        Font font = parent.getFont();
        Composite appearanceComposite = new Composite(parent, 0);
        appearanceComposite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        String labelText = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.printMarginColumn");
        String[] errorMessages = new String[]{MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.empty_input_print_margin"), MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.invalid_input_print_margin")};
        this.addTextField(appearanceComposite, labelText, "printMarginColumn", 3, 0, errorMessages);
        labelText = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.tabwidth");
        errorMessages = new String[]{MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.notabwidth"), MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.39")};
        this.addTextField(appearanceComposite, labelText, "tabWidth", 3, 0, errorMessages);
        labelText = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.showOverviewRuler");
        this.addCheckBox(appearanceComposite, labelText, "overviewRuler", 0);
        labelText = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.showLineNumbers");
        this.addCheckBox(appearanceComposite, labelText, "lineNumberRuler", 0);
        labelText = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.highlightCurrentLine");
        this.addCheckBox(appearanceComposite, labelText, "currentLine", 0);
        labelText = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.showPrintMargin");
        this.addCheckBox(appearanceComposite, labelText, "printMargin", 0);
        Label label = new Label(appearanceComposite, 16384);
        label.setFont(font);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gd);
        label = new Label(appearanceComposite, 16384);
        label.setFont(font);
        label.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.appearanceOptions"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        editorComposite.setFont(font);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new org.eclipse.swt.widgets.List(editorComposite, 2564);
        this.fAppearanceColorList.setFont(font);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(6);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        stylesComposite.setFont(font);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setFont(font);
        label.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        foregroundColorButton.setFont(font);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MakefileEditorPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        SelectionListener colorDefaultSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean systemDefault = MakefileEditorPreferencePage.this.fAppearanceColorDefault.getSelection();
                MakefileEditorPreferencePage.this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
                int i = MakefileEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = MakefileEditorPreferencePage.this.fAppearanceColorListModel[i][2];
                if (key != null) {
                    MakefileEditorPreferencePage.this.getOverlayStore().setValue(key, systemDefault);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fAppearanceColorDefault = new Button(stylesComposite, 32);
        this.fAppearanceColorDefault.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.systemdefault"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fAppearanceColorDefault.setLayoutData((Object)gd);
        this.fAppearanceColorDefault.setVisible(false);
        this.fAppearanceColorDefault.addSelectionListener(colorDefaultSelectionListener);
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = MakefileEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = MakefileEditorPreferencePage.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)MakefileEditorPreferencePage.this.getOverlayStore(), (String)key, (RGB)MakefileEditorPreferencePage.this.fAppearanceColorEditor.getColorValue());
            }
        });
        return appearanceComposite;
    }

    private Composite createFoldingTabContent(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        GridData gd = new GridData(80);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fFoldingCheckbox = new Button(composite, 32);
        this.fFoldingCheckbox.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.foldingenable"));
        gd = new GridData(34);
        this.fFoldingCheckbox.setLayoutData((Object)gd);
        this.fFoldingCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = MakefileEditorPreferencePage.this.fFoldingCheckbox.getSelection();
                MakefileEditorPreferencePage.this.getOverlayStore().setValue("editor_folding_enabled", enabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    void handleSyntaxColorListSelection() {
        HighlightingColorListItem item = this.getHighlightingColorListItem();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getOverlayStore(), (String)item.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.getOverlayStore().getBoolean(item.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.getOverlayStore().getBoolean(item.getItalicKey()));
    }

    HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fHighlightingColorListViewer.getSelection();
        return (HighlightingColorListItem)selection.getFirstElement();
    }

    public boolean performOk() {
        return super.performOk();
    }

    public static void initDefaults(IPreferenceStore prefs) {
        EditorsUI.useAnnotationsPreferencePage((IPreferenceStore)prefs);
        EditorsUI.useQuickDiffPreferencePage((IPreferenceStore)prefs);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.make.ui.editor.comment", (RGB)ColorManager.MAKE_COMMENT_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.make.ui.editor.default", (RGB)ColorManager.MAKE_DEFAULT_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.make.ui.editor.function", (RGB)ColorManager.MAKE_FUNCTION_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.make.ui.editor.keyword", (RGB)ColorManager.MAKE_KEYWORD_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.make.ui.editor.macro_def", (RGB)ColorManager.MAKE_MACRO_DEF_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.make.ui.editor.macro_ref", (RGB)ColorManager.MAKE_MACRO_REF_RGB);
    }

    private class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private Color fItemColor;

        public HighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, Color itemColor) {
            this.fDisplayName = displayName;
            this.fColorKey = colorKey;
            this.fBoldKey = boldKey;
            this.fItalicKey = italicKey;
            this.fItemColor = itemColor;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public Color getItemColor() {
            return this.fItemColor;
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider
    implements IColorProvider {
        ColorListLabelProvider() {
        }

        public String getText(Object element) {
            return ((HighlightingColorListItem)element).getDisplayName();
        }

        public Color getForeground(Object element) {
            return ((HighlightingColorListItem)element).getItemColor();
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    private class ColorListContentProvider
    implements IStructuredContentProvider {
        ColorListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

