/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.filewizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewFileWizardMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.dialogs.ContainerGenerator;

public class NewSourceFileGenerator {
    private static final String HEADER_EXT = ".h";
    private static final String SOURCE_EXT = ".cpp";
    private static boolean fUseIncludeGuard = true;
    private static final String fLineDelimiter = System.getProperty("line.separator", "\n");

    public static String getLineDelimiter() {
        return fLineDelimiter;
    }

    public static String generateHeaderFileNameFromClass(String className) {
        return String.valueOf(className) + HEADER_EXT;
    }

    public static String generateSourceFileNameFromClass(String className) {
        return String.valueOf(className) + SOURCE_EXT;
    }

    public static IFile createHeaderFile(IPath filePath, boolean force, IProgressMonitor monitor) throws CoreException {
        ByteArrayInputStream stream;
        if (fUseIncludeGuard) {
            String includeGuardSymbol = NewSourceFileGenerator.generateIncludeGuardSymbol(filePath);
            StringBuffer buf = new StringBuffer();
            buf.append("#ifndef ");
            buf.append(includeGuardSymbol);
            buf.append(fLineDelimiter);
            buf.append("#define ");
            buf.append(includeGuardSymbol);
            buf.append(fLineDelimiter);
            buf.append(fLineDelimiter);
            buf.append("#endif //");
            buf.append(includeGuardSymbol);
            buf.append(fLineDelimiter);
            stream = new ByteArrayInputStream(buf.toString().getBytes());
        } else {
            stream = new ByteArrayInputStream(new byte[0]);
        }
        return NewSourceFileGenerator.createNewFile(filePath, stream, force, monitor);
    }

    private static String generateIncludeGuardSymbol(IPath headerPath) {
        String name = headerPath.lastSegment();
        if (name != null) {
            StringBuffer buf = new StringBuffer();
            buf.append('_');
            int i = 0;
            while (i < name.length()) {
                char ch = name.charAt(i);
                if (Character.isLetterOrDigit(ch)) {
                    buf.append(Character.toUpperCase(ch));
                } else if (ch == '.' || ch == '_') {
                    buf.append('_');
                }
                ++i;
            }
            buf.append('_');
            return buf.toString();
        }
        return null;
    }

    public static IFile createSourceFile(IPath filePath, boolean force, IProgressMonitor monitor) throws CoreException {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        return NewSourceFileGenerator.createNewFile(filePath, stream, force, monitor);
    }

    private static IFile createNewFile(IPath newFilePath, InputStream contents, boolean force, IProgressMonitor monitor) throws CoreException {
        IPath containerPath;
        int totalWork;
        int createFileWork = totalWork = 100;
        monitor.beginTask(NewFileWizardMessages.getString("NewSourceFileGenerator.createFile.task"), totalWork);
        IWorkspaceRoot root = CUIPlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(newFilePath);
        if (newFile == null) {
            newFile = root.getFile(newFilePath);
        }
        if (newFile.exists()) {
            monitor.done();
            return newFile;
        }
        if (newFilePath.segmentCount() > 1 && root.getContainerForLocation(containerPath = newFilePath.removeLastSegments(1)) == null) {
            int containerWork = totalWork / 2;
            createFileWork = totalWork / 2;
            ContainerGenerator generator = new ContainerGenerator(containerPath);
            generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, containerWork));
        }
        NewSourceFileGenerator.createFile(newFile, contents, force, (IProgressMonitor)new SubProgressMonitor(monitor, createFileWork));
        monitor.done();
        return newFile;
    }

    private static void createFile(IFile fileHandle, InputStream contents, boolean force, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            fileHandle.create(contents, force, monitor);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

