/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CDirectorySourceLocation;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.ListDialogField;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceLookupLabelProvider;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceLookupMessages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SourceListDialogField
extends ListDialogField {
    protected static final String YES_VALUE = SourceLookupMessages.getString("SourceListDialogField.0");
    protected static final String NO_VALUE = SourceLookupMessages.getString("SourceListDialogField.1");
    private static final String CP_LOCATION = "location";
    private static final String CP_ASSOCIATION = "association";
    private static final String CP_SEARCH_SUBFOLDERS = "searchSubfolders";
    private ObservableSourceList fObservable;

    public SourceListDialogField(String title, IListAdapter listAdapter) {
        String[] stringArray = new String[6];
        stringArray[0] = SourceLookupMessages.getString("SourceListDialogField.2");
        stringArray[2] = SourceLookupMessages.getString("SourceListDialogField.3");
        stringArray[3] = SourceLookupMessages.getString("SourceListDialogField.4");
        stringArray[5] = SourceLookupMessages.getString("SourceListDialogField.5");
        super(listAdapter, stringArray, (ILabelProvider)new SourceLookupLabelProvider());
        this.fObservable = new ObservableSourceList();
        this.setUpButtonIndex(2);
        this.setDownButtonIndex(3);
        this.setRemoveButtonIndex(5);
        this.setLabelText(title);
    }

    protected boolean managedButtonPressed(int index) {
        super.managedButtonPressed(index);
        return false;
    }

    protected TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = super.createTableViewer(parent);
        Table table = viewer.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        GridData gd = new GridData(272);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        new TableColumn(table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, true));
        new TableColumn(table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, true));
        new TableColumn(table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        TableColumn[] columns = table.getColumns();
        columns[0].setText(SourceLookupMessages.getString("SourceListDialogField.6"));
        columns[1].setText(SourceLookupMessages.getString("SourceListDialogField.7"));
        columns[2].setText(SourceLookupMessages.getString("SourceListDialogField.8"));
        TextCellEditor textCellEditor = new TextCellEditor((Composite)table);
        ComboBoxCellEditor comboCellEditor = new ComboBoxCellEditor((Composite)table, new String[]{YES_VALUE, NO_VALUE});
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = textCellEditor;
        cellEditorArray[2] = comboCellEditor;
        viewer.setCellEditors(cellEditorArray);
        viewer.setColumnProperties(new String[]{CP_LOCATION, CP_ASSOCIATION, CP_SEARCH_SUBFOLDERS});
        viewer.setCellModifier(this.createCellModifier());
        return viewer;
    }

    private ICellModifier createCellModifier() {
        return new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return element instanceof CDirectorySourceLocation && (property.equals(SourceListDialogField.CP_ASSOCIATION) || property.equals(SourceListDialogField.CP_SEARCH_SUBFOLDERS));
            }

            public Object getValue(Object element, String property) {
                if (element instanceof CDirectorySourceLocation && property.equals(SourceListDialogField.CP_ASSOCIATION)) {
                    return ((CDirectorySourceLocation)element).getAssociation() != null ? ((CDirectorySourceLocation)element).getAssociation().toOSString() : "";
                }
                if (element instanceof CDirectorySourceLocation && property.equals(SourceListDialogField.CP_SEARCH_SUBFOLDERS)) {
                    return ((CDirectorySourceLocation)element).searchSubfolders() ? new Integer(0) : new Integer(1);
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                Object entry = SourceListDialogField.this.getSelection();
                if (entry instanceof CDirectorySourceLocation) {
                    Path association;
                    if (property.equals(SourceListDialogField.CP_ASSOCIATION) && value instanceof String && (association = new Path((String)value)).isValidPath((String)value)) {
                        ((CDirectorySourceLocation)entry).setAssociation((IPath)association);
                        SourceListDialogField.this.setChanged();
                    }
                    if (property.equals(SourceListDialogField.CP_SEARCH_SUBFOLDERS) && value instanceof Integer) {
                        ((CDirectorySourceLocation)entry).setSearchSubfolders((Integer)value == 0);
                        SourceListDialogField.this.setChanged();
                    }
                    if (SourceListDialogField.this.hasChanged()) {
                        SourceListDialogField.this.refresh();
                        SourceListDialogField.this.notifyObservers();
                    }
                }
            }
        };
    }

    protected Object getSelection() {
        List list = this.getSelectedElements();
        return list.size() > 0 ? list.get(0) : null;
    }

    public synchronized void addObserver(Observer o) {
        this.fObservable.addObserver(o);
    }

    public synchronized void deleteObserver(Observer o) {
        this.fObservable.deleteObserver(o);
    }

    public synchronized boolean hasChanged() {
        return this.fObservable.hasChanged();
    }

    public void notifyObservers() {
        this.fObservable.notifyObservers();
    }

    public void notifyObservers(Object arg) {
        this.fObservable.notifyObservers(arg);
    }

    public void dispose() {
    }

    protected void setChanged() {
        this.fObservable.setChanged();
    }

    public ICSourceLocation[] getSourceLocations() {
        List list = this.getElements();
        return list.toArray(new ICSourceLocation[list.size()]);
    }

    public class ObservableSourceList
    extends Observable {
        protected synchronized void setChanged() {
            super.setChanged();
        }
    }
}

