/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.sharedlibs;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SharedLibrariesViewContentProvider
implements ITreeContentProvider {
    private HashMap fParentCache;
    private IDebugExceptionHandler fExceptionHandler;

    public SharedLibrariesViewContentProvider() {
        this.setParentCache(new HashMap(10));
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ICDebugTarget) {
            Object[] children = null;
            ICDebugTarget target = (ICDebugTarget)parent;
            try {
                if (target != null) {
                    children = target.getSharedLibraries();
                }
                if (children != null) {
                    this.cache(parent, children);
                    return children;
                }
            }
            catch (DebugException e) {
                if (this.getExceptionHandler() != null) {
                    this.getExceptionHandler().handleException(e);
                }
                CDebugUIPlugin.log(e);
            }
        }
        return new Object[0];
    }

    protected void cache(Object parent, Object[] children) {
        int i = 0;
        while (i < children.length) {
            this.getParentCache().put(children[i], parent);
            ++i;
        }
    }

    public Object getParent(Object element) {
        return this.getParentCache().get(element);
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof ICDebugTarget) {
            try {
                ICDebugTarget target = (ICDebugTarget)parent;
                return target.hasSharedLibraries();
            }
            catch (DebugException e) {
                CDebugUIPlugin.log(e);
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.setParentCache(null);
        this.setExceptionHandler(null);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.clearCache();
    }

    protected void clearCache() {
        if (this.getParentCache() != null) {
            this.getParentCache().clear();
        }
    }

    public void removeCache(Object[] children) {
        if (this.getParentCache() != null) {
            int i = 0;
            while (i < children.length) {
                this.getParentCache().remove(children[i]);
                ++i;
            }
        }
    }

    protected void setExceptionHandler(IDebugExceptionHandler handler) {
        this.fExceptionHandler = handler;
    }

    protected IDebugExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }

    private HashMap getParentCache() {
        return this.fParentCache;
    }

    private void setParentCache(HashMap parentCache) {
        this.fParentCache = parentCache;
    }
}

