/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexDelta;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IIndexer;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexOutput;
import org.eclipse.cdt.internal.core.index.impl.IFileDocument;
import org.eclipse.cdt.internal.core.index.impl.InMemoryIndex;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexDelta;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.IndexerOutput;
import org.eclipse.cdt.internal.core.index.impl.Int;
import org.eclipse.cdt.internal.core.index.impl.MergeFactory;
import org.eclipse.cdt.internal.core.index.impl.SimpleIndexInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public class Index
implements IIndex {
    public static final int MAX_FOOTPRINT = 10000000;
    protected InMemoryIndex addsIndex;
    protected IndexInput addsIndexInput;
    protected int state = 1;
    protected Map removedInAdds;
    protected Map removedInOld;
    protected static final int CAN_MERGE = 0;
    protected static final int MERGED = 1;
    private File indexFile;
    public String toString;

    public Index(File indexDirectory, boolean reuseExistingFile) throws IOException {
        this(indexDirectory, ".index", reuseExistingFile);
    }

    public Index(File indexDirectory, String indexName, boolean reuseExistingFile) throws IOException {
        this.indexFile = new File(indexDirectory, indexName);
        this.initialize(reuseExistingFile);
    }

    public Index(String indexName, boolean reuseExistingFile) throws IOException {
        this(indexName, null, reuseExistingFile);
    }

    public Index(String indexName, String toString, boolean reuseExistingFile) throws IOException {
        this.indexFile = new File(indexName);
        this.toString = toString;
        this.initialize(reuseExistingFile);
    }

    public void add(IDocument document, IIndexer indexer) throws IOException {
        IndexedFile indexedFile;
        if (this.timeToMerge()) {
            this.merge();
        }
        if ((indexedFile = this.addsIndex.getIndexedFile(document.getName())) != null) {
            this.remove(indexedFile, 0);
        }
        IndexerOutput output = new IndexerOutput(this.addsIndex);
        indexer.index(document, output);
        this.state = 0;
    }

    protected boolean canMerge() {
        return this.state == 0;
    }

    public void empty() throws IOException {
        if (this.indexFile.exists()) {
            this.indexFile.delete();
            InMemoryIndex mainIndex = new InMemoryIndex();
            BlocksIndexOutput mainIndexOutput = new BlocksIndexOutput(this.indexFile);
            if (!this.indexFile.exists()) {
                mainIndex.save(mainIndexOutput);
            }
        }
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public int getNumDocuments() throws IOException {
        int n;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            n = ((IndexInput)input).getNumFiles();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return n;
    }

    public int getNumWords() throws IOException {
        int n;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            n = ((IndexInput)input).getNumWords();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return n;
    }

    public int getNumIncludes() throws IOException {
        int n;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            n = ((IndexInput)input).getNumIncludes();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return n;
    }

    public String getPath(int documentNumber) throws IOException {
        IndexedFile file;
        BlocksIndexInput input;
        block3: {
            String string;
            input = new BlocksIndexInput(this.indexFile);
            try {
                ((IndexInput)input).open();
                file = ((IndexInput)input).getIndexedFile(documentNumber);
                if (file != null) break block3;
                string = null;
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                ((IndexInput)input).close();
                throw throwable;
            }
            ((IndexInput)input).close();
            return string;
        }
        String string = file.getPath();
        Object var4_7 = null;
        ((IndexInput)input).close();
        return string;
    }

    public boolean hasChanged() {
        return this.canMerge();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(boolean reuseExistingFile) throws IOException {
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
        if (reuseExistingFile && this.indexFile.exists()) {
            BlocksIndexInput mainIndexInput = new BlocksIndexInput(this.indexFile);
            try {
                ((IndexInput)mainIndexInput).open();
            }
            catch (IOException e) {
                BlocksIndexInput input = mainIndexInput;
                try {
                    input.opened = true;
                    input.close();
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    input.opened = false;
                    throw throwable;
                }
                {
                    Object var5_9 = null;
                    input.opened = false;
                    this.indexFile.delete();
                }
                mainIndexInput = null;
                throw e;
            }
            ((IndexInput)mainIndexInput).close();
            return;
        }
        InMemoryIndex mainIndex = new InMemoryIndex();
        BlocksIndexOutput mainIndexOutput = new BlocksIndexOutput(this.indexFile);
        mainIndex.save(mainIndexOutput);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void merge() throws IOException {
        File tempFile = new File(String.valueOf(this.indexFile.getAbsolutePath()) + "TempVA");
        BlocksIndexInput mainIndexInput = new BlocksIndexInput(this.indexFile);
        BlocksIndexOutput tempIndexOutput = new BlocksIndexOutput(tempFile);
        try {
            new MergeFactory(mainIndexInput, this.addsIndexInput, tempIndexOutput, this.removedInOld, this.removedInAdds).merge();
            File mainIndexFile = (File)((IndexInput)mainIndexInput).getSource();
            File tempIndexFile = (File)tempIndexOutput.getDestination();
            mainIndexFile.delete();
            tempIndexFile.renameTo(mainIndexFile);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.removedInAdds.clear();
            this.removedInOld.clear();
            this.addsIndex.init();
            this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
            this.state = 1;
            CCorePlugin.getDefault().cdtLog.flushLog();
            IndexDelta indexDelta = new IndexDelta(null, null, IIndexDelta.MERGE_DELTA);
            CCorePlugin.getDefault().getCoreModel().getIndexManager().notifyListeners(indexDelta);
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.removedInAdds.clear();
            this.removedInOld.clear();
            this.addsIndex.init();
            this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
            this.state = 1;
            CCorePlugin.getDefault().cdtLog.flushLog();
            IndexDelta indexDelta = new IndexDelta(null, null, IIndexDelta.MERGE_DELTA);
            CCorePlugin.getDefault().getCoreModel().getIndexManager().notifyListeners(indexDelta);
            return;
        }
    }

    public IQueryResult[] query(String word) throws IOException {
        IQueryResult[] iQueryResultArray;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            iQueryResultArray = ((IndexInput)input).query(word);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return iQueryResultArray;
    }

    public IEntryResult[] queryEntries(char[] prefix) throws IOException {
        IEntryResult[] iEntryResultArray;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            iEntryResultArray = ((IndexInput)input).queryEntriesPrefixedBy(prefix);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return iEntryResultArray;
    }

    public IQueryResult[] queryInDocumentNames(String word) throws IOException {
        IQueryResult[] iQueryResultArray;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            iQueryResultArray = ((IndexInput)input).queryInDocumentNames(word);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return iQueryResultArray;
    }

    public IQueryResult[] queryPrefix(char[] prefix) throws IOException {
        IQueryResult[] iQueryResultArray;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            iQueryResultArray = ((IndexInput)input).queryFilesReferringToPrefix(prefix);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return iQueryResultArray;
    }

    public String[] getFileDependencies(IPath filePath) throws IOException {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getFileDependencies(IFile file) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        int fileNum = 0;
        ArrayList<String> tempFileReturn = new ArrayList<String>();
        try {
            IFileDocument temp = new IFileDocument(file);
            ((IndexInput)input).open();
            IndexedFile inFile = ((IndexInput)input).getIndexedFile(temp);
            fileNum = inFile.getFileNumber();
            IncludeEntry[] tempEntries = ((IndexInput)input).queryIncludeEntries(fileNum);
            int i = 0;
            while (i < tempEntries.length) {
                char[] tempFile = tempEntries[i].getFile();
                StringBuffer tempString = new StringBuffer();
                tempString.append(tempFile);
                tempFileReturn.add(tempString.toString());
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        ((IndexInput)input).close();
        return tempFileReturn.toArray(new String[tempFileReturn.size()]);
    }

    public void remove(String documentName) throws IOException {
        IndexedFile file = this.addsIndex.getIndexedFile(documentName);
        if (file != null) {
            Int lastRemoved = (Int)this.removedInAdds.get(documentName);
            if (lastRemoved != null) {
                int fileNum = file.getFileNumber();
                if (lastRemoved.value < fileNum) {
                    lastRemoved.value = fileNum;
                }
            } else {
                this.removedInAdds.put(documentName, new Int(file.getFileNumber()));
            }
        } else {
            this.removedInOld.put(documentName, new Int(1));
        }
        this.state = 0;
    }

    protected void remove(IndexedFile file, int index) throws IOException {
        String name = file.getPath();
        if (index == 0) {
            Int lastRemoved = (Int)this.removedInAdds.get(name);
            if (lastRemoved != null) {
                if (lastRemoved.value < file.getFileNumber()) {
                    lastRemoved.value = file.getFileNumber();
                }
            } else {
                this.removedInAdds.put(name, new Int(file.getFileNumber()));
            }
        } else if (index == 1) {
            this.removedInOld.put(name, new Int(1));
        } else {
            throw new Error();
        }
        this.state = 0;
    }

    public void save() throws IOException {
        if (this.canMerge()) {
            this.merge();
        }
    }

    protected boolean timeToMerge() {
        return this.addsIndex.getFootprint() >= 10000000L;
    }

    public String toString() {
        String str = this.toString;
        if (str == null) {
            str = super.toString();
        }
        str = String.valueOf(str) + "(length: " + this.getIndexFile().length() + ")";
        return str;
    }
}

