/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.search.indexing.CleanEncounteredHeaders;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

class AddFolderToIndex
extends IndexRequest {
    IPath folderPath;
    IProject project;
    char[][] exclusionPattern;
    ArrayList sourceFilesToIndex;
    ArrayList headerFilesToIndex;
    boolean cleanEncouteredHeaders;

    public AddFolderToIndex(IPath folderPath, IProject project, char[][] exclusionPattern, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.folderPath = folderPath;
        this.project = project;
        this.exclusionPattern = exclusionPattern;
        this.sourceFilesToIndex = new ArrayList();
        this.headerFilesToIndex = new ArrayList();
        this.cleanEncouteredHeaders = false;
    }

    public AddFolderToIndex(IPath folderPath, IProject project, char[][] exclusionPattern, IndexManager manager, boolean cleanEncounteredHeaders) {
        super(project.getFullPath(), manager);
        this.folderPath = folderPath;
        this.project = project;
        this.exclusionPattern = exclusionPattern;
        this.sourceFilesToIndex = new ArrayList();
        this.headerFilesToIndex = new ArrayList();
        this.cleanEncouteredHeaders = cleanEncounteredHeaders;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        IResource folder = this.project.getParent().findMember(this.folderPath);
        if (folder == null) return true;
        if (folder.getType() == 1) {
            return true;
        }
        IIndex index = this.manager.getIndex(this.indexPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.manager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                final char[][] pattern = this.exclusionPattern;
                folder.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        switch (proxy.getType()) {
                            case 1: {
                                IResource resource = proxy.requestResource();
                                if (CoreModel.isValidTranslationUnitName(resource.getProject(), resource.getName()) && (pattern == null || !Util.isExcluded(resource, pattern))) {
                                    AddFolderToIndex.this.sortFiles((IFile)resource);
                                }
                                return false;
                            }
                            case 2: {
                                if (pattern == null || !Util.isExcluded(proxy.requestResource(), pattern)) break;
                                return false;
                            }
                        }
                        return true;
                    }
                }, 0);
                this.scheduleJobs();
            }
            catch (CoreException e) {
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> failed to add " + this.folderPath + " to index because of the following exception:");
                    e.printStackTrace();
                }
                Object var6_7 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.exitRead();
            throw throwable;
        }
        {
            Object var6_9 = null;
            monitor.exitRead();
            return true;
        }
    }

    private void scheduleJobs() {
        int i = 0;
        while (i < this.sourceFilesToIndex.size()) {
            this.manager.addSource((IFile)this.sourceFilesToIndex.get(i), this.indexPath, false);
            ++i;
        }
        i = 0;
        while (i < this.headerFilesToIndex.size()) {
            this.manager.addSource((IFile)this.headerFilesToIndex.get(i), this.indexPath, true);
            ++i;
        }
        if (this.cleanEncouteredHeaders) {
            CleanEncounteredHeaders cleanHeaders = new CleanEncounteredHeaders(this.manager);
            this.manager.request(cleanHeaders);
        }
    }

    public String toString() {
        return "adding " + this.folderPath + " to index " + this.indexPath;
    }

    protected void sortFiles(IFile file) {
        ICFileType type = CCorePlugin.getDefault().getFileType(file.getProject(), file.getName());
        if (type.isHeader()) {
            this.headerFilesToIndex.add(file);
        }
        if (type.isSource()) {
            this.sourceFilesToIndex.add(file);
        }
    }
}

