/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.internal.core.model.AbstractCValue;
import org.eclipse.cdt.debug.internal.core.model.AbstractCVariable;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CType;
import org.eclipse.cdt.debug.internal.core.model.CVariableFactory;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IVariable;

public class CIndexedValue
extends AbstractCValue
implements IIndexedValue {
    private ICDIArrayValue fCDIValue;
    private IVariable[] fVariables;
    private int fOffset;
    private int fSize;
    private ICType fType;

    public CIndexedValue(AbstractCVariable parent, ICDIArrayValue cdiValue, int offset, int size) {
        super(parent);
        this.fVariables = new IVariable[size];
        this.fCDIValue = cdiValue;
        this.fOffset = offset;
        this.fSize = size;
    }

    protected void setChanged(boolean changed) {
        int i = 0;
        while (i < this.fVariables.length) {
            if (this.fVariables[i] != null) {
                ((AbstractCVariable)this.fVariables[i]).setChanged(changed);
            }
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.fVariables.length) {
            if (this.fVariables[i] != null) {
                ((AbstractCVariable)this.fVariables[i]).dispose();
            }
            ++i;
        }
    }

    protected void reset() {
        int i = 0;
        while (i < this.fVariables.length) {
            if (this.fVariables[i] != null) {
                ((AbstractCVariable)this.fVariables[i]).resetValue();
            }
            ++i;
        }
    }

    protected void preserve() {
        this.resetStatus();
        int i = 0;
        while (i < this.fVariables.length) {
            if (this.fVariables[i] != null) {
                ((AbstractCVariable)this.fVariables[i]).preserve();
            }
            ++i;
        }
    }

    public ICType getType() throws DebugException {
        if (this.fType == null) {
            CIndexedValue cIndexedValue = this;
            synchronized (cIndexedValue) {
                if (this.fType == null) {
                    try {
                        ICDIType cdiType = this.getCDIValue().getType();
                        if (cdiType != null) {
                            this.fType = new CType(cdiType);
                        }
                    }
                    catch (CDIException e) {
                        CDebugElement.targetRequestFailed(e.getMessage(), null);
                    }
                }
            }
        }
        return this.fType;
    }

    public String getReferenceTypeName() throws DebugException {
        ICType type = this.getType();
        return type != null ? type.getName() : "";
    }

    public String getValueString() throws DebugException {
        return "";
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.getVariables0(this.getInitialOffset(), this.getSize());
    }

    public boolean hasVariables() throws DebugException {
        return this.getSize() > 0;
    }

    public IVariable getVariable(int offset) throws DebugException {
        if (offset >= this.getSize()) {
            CDebugElement.requestFailed(CoreModelMessages.getString("CIndexedValue.0"), null);
        }
        return this.getVariables0(offset, 1)[0];
    }

    public IVariable[] getVariables(int offset, int length) throws DebugException {
        if (offset >= this.getSize()) {
            CDebugElement.requestFailed(CoreModelMessages.getString("CIndexedValue.1"), null);
        }
        if (offset + length - 1 >= this.getSize()) {
            CDebugElement.requestFailed(CoreModelMessages.getString("CIndexedValue.2"), null);
        }
        return this.getVariables0(offset, length);
    }

    public int getSize() throws DebugException {
        return this.getSize0();
    }

    public int getInitialOffset() {
        return this.fOffset;
    }

    protected ICDIArrayValue getCDIValue() {
        return this.fCDIValue;
    }

    private int getPartitionSize(int index) {
        int psize = this.getPreferredPartitionSize();
        int size = this.getSize0();
        int pcount = size / psize + 1;
        if (pcount - 1 < index) {
            return 0;
        }
        return pcount - 1 == index ? size % psize : psize;
    }

    private int getPartitionIndex(int offset) {
        return offset / this.getPreferredPartitionSize();
    }

    private int getPreferredPartitionSize() {
        return 100;
    }

    private IVariable[] getVariables0(int offset, int length) throws DebugException {
        IVariable[] result = new IVariable[length];
        int firstIndex = this.getPartitionIndex(offset);
        int lastIndex = this.getPartitionIndex(offset + length);
        int i = firstIndex;
        while (i <= lastIndex) {
            CIndexedValue cIndexedValue = this;
            synchronized (cIndexedValue) {
                if (!this.isPartitionLoaded(i)) {
                    this.loadPartition(i);
                }
            }
            ++i;
        }
        System.arraycopy(this.fVariables, offset, result, 0, length);
        return result;
    }

    private boolean isPartitionLoaded(int index) {
        return this.fVariables[index * this.getPreferredPartitionSize()] != null;
    }

    private void loadPartition(int index) throws DebugException {
        int prefSize = this.getPreferredPartitionSize();
        int psize = this.getPartitionSize(index);
        ICDIVariable[] cdiVars = new ICDIVariable[]{};
        try {
            cdiVars = this.getCDIValue().getVariables(index * prefSize, psize);
        }
        catch (CDIException e) {
            CDebugElement.requestFailed(e.getMessage(), null);
        }
        int i = 0;
        while (i < cdiVars.length) {
            this.fVariables[i + index * prefSize] = CVariableFactory.createVariable(this.getParentVariable(), cdiVars[i]);
            ++i;
        }
    }

    private int getSize0() {
        return this.fSize;
    }
}

