/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocalVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIFormat;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIExecFinish;
import org.eclipse.cdt.debug.mi.core.command.MIExecReturn;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;

public class StackFrame
extends CObject
implements ICDIStackFrame {
    MIFrame frame;
    Thread cthread;
    int level;
    ICDIArgumentDescriptor[] argDescs;
    ICDILocalVariableDescriptor[] localDescs;
    Location fLocation;

    public StackFrame(Thread thread, MIFrame f, int l) {
        super((Target)thread.getTarget());
        this.cthread = thread;
        this.frame = f;
        this.level = l;
    }

    public MIFrame getMIFrame() {
        return this.frame;
    }

    public ICDIThread getThread() {
        return this.cthread;
    }

    public ICDIArgumentDescriptor[] getArgumentDescriptors() throws CDIException {
        if (this.argDescs == null) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            this.argDescs = mgr.getArgumentDescriptors(this);
        }
        return this.argDescs;
    }

    public ICDILocalVariableDescriptor[] getLocalVariableDescriptors() throws CDIException {
        if (this.localDescs == null) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            this.localDescs = mgr.getLocalVariableDescriptors(this);
        }
        return this.localDescs;
    }

    public ICDILocation getLocation() {
        BigInteger addr = BigInteger.ZERO;
        if (this.frame != null) {
            if (this.fLocation == null) {
                String a = this.frame.getAddress();
                if (a != null) {
                    addr = MIFormat.getBigInteger(a);
                }
                this.fLocation = new Location(this.frame.getFile(), this.frame.getFunction(), this.frame.getLine(), addr);
            }
            return this.fLocation;
        }
        return new Location("", "", 0, addr);
    }

    public int getLevel() {
        return this.level;
    }

    public boolean equals(ICDIStackFrame stackframe) {
        if (stackframe instanceof StackFrame) {
            StackFrame stack = (StackFrame)stackframe;
            return this.cthread != null && this.cthread.equals(stack.getThread()) && this.getLevel() == stack.getLevel() && this.getLocation().equals(stack.getLocation());
        }
        return super.equals(stackframe);
    }

    public void stepReturn() throws CDIException {
        this.finish();
    }

    public void stepReturn(ICDIValue value) throws CDIException {
        this.execReturn(value.toString());
    }

    protected void finish() throws CDIException {
        ((Thread)this.getThread()).setCurrentStackFrame(this, false);
        Target target = (Target)this.getTarget();
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        MIExecFinish finish = factory.createMIExecFinish();
        try {
            miSession.postCommand(finish);
            MIInfo info = finish.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    protected void execReturn(String value) throws CDIException {
        ((Thread)this.getThread()).setCurrentStackFrame(this, false);
        Target target = (Target)this.getTarget();
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        MIExecReturn ret = value == null ? factory.createMIExecReturn() : factory.createMIExecReturn(value);
        try {
            miSession.postCommand(ret);
            MIInfo info = ret.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }
}

