/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;

public class ProjectType
extends BuildObject
implements IProjectType {
    private static final String EMPTY_STRING = new String();
    private static final IConfiguration[] emptyConfigs = new IConfiguration[0];
    private IProjectType superClass;
    private String superClassId;
    private List configList;
    private Map configMap;
    private Boolean isAbstract;
    private Boolean isTest;
    private String unusedChildren;
    private boolean resolved = false;

    public ProjectType(IManagedConfigElement element) {
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionProjectType(this);
        IManagedConfigElement[] configs = element.getChildren("configuration");
        int n = 0;
        while (n < configs.length) {
            new Configuration(this, configs[n]);
            ++n;
        }
    }

    public ProjectType(ProjectType superClass, String Id, String name) {
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        ManagedBuildManager.addExtensionProjectType(this);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String isTestStr;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.superClassId = element.getAttribute("superClass");
        this.unusedChildren = element.getAttribute("unusedChildren");
        String isAbs = element.getAttribute("isAbstract");
        if (isAbs != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if ((isTestStr = element.getAttribute("isTest")) != null) {
            this.isTest = new Boolean("true".equals(isTestStr));
        }
    }

    public IConfiguration createConfiguration(IConfiguration parent, String id, String name) {
        Configuration config = new Configuration(this, parent, id, name);
        return config;
    }

    public IConfiguration getConfiguration(String id) {
        return (IConfiguration)this.getConfigurationMap().get(id);
    }

    public IConfiguration[] getConfigurations() {
        IConfiguration[] configs = new IConfiguration[this.getConfigurationList().size()];
        ListIterator iter = this.getConfigurationList().listIterator();
        int i = 0;
        while (iter.hasNext()) {
            Configuration config = (Configuration)iter.next();
            configs[i++] = config;
        }
        return configs;
    }

    public void removeConfiguration(String id) {
        ListIterator iter = this.getConfigurationList().listIterator();
        while (iter.hasNext()) {
            IConfiguration config = (IConfiguration)iter.next();
            if (!config.getId().equals(id)) continue;
            this.getConfigurationList().remove(config);
            this.getConfigurationMap().remove(id);
            break;
        }
    }

    public void addConfiguration(Configuration configuration) {
        this.getConfigurationList().add(configuration);
        this.getConfigurationMap().put(configuration.getId(), configuration);
    }

    private List getConfigurationList() {
        if (this.configList == null) {
            this.configList = new ArrayList();
        }
        return this.configList;
    }

    private Map getConfigurationMap() {
        if (this.configMap == null) {
            this.configMap = new HashMap();
        }
        return this.configMap;
    }

    public String getName() {
        if (this.name == null) {
            if (this.superClass != null) {
                return this.superClass.getName();
            }
            return new String("");
        }
        return this.name;
    }

    public IProjectType getSuperClass() {
        return this.superClass;
    }

    public boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    public String getUnusedChildren() {
        if (this.unusedChildren != null) {
            return this.unusedChildren;
        }
        return EMPTY_STRING;
    }

    public boolean isTestProjectType() {
        if (this.isTest == null) {
            if (this.superClass != null) {
                return this.superClass.isTestProjectType();
            }
            return false;
        }
        return this.isTest;
    }

    public void setIsAbstract(boolean b) {
        this.isAbstract = new Boolean(b);
    }

    public void setIsTest(boolean b) {
        this.isTest = new Boolean(b);
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionProjectType(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.OutputResolveError("superClass", this.superClassId, "projectType", this.getId());
                }
            }
            if (this.superClass != null) {
                ((ProjectType)this.superClass).resolveReferences();
                IConfiguration[] superConfigs = this.superClass.getConfigurations();
                int i = 0;
                while (i < superConfigs.length) {
                    block9: {
                        String superId = superConfigs[i].getId();
                        IConfiguration[] currentConfigs = this.getConfigurations();
                        int j = 0;
                        while (j < currentConfigs.length) {
                            IConfiguration config = currentConfigs[j];
                            while (config.getParent() != null) {
                                if (!config.getParent().getId().equals(superId)) {
                                    config = config.getParent();
                                    continue;
                                }
                                break block9;
                            }
                            ++j;
                        }
                        this.addConfiguration((Configuration)superConfigs[i]);
                    }
                    ++i;
                }
            }
            Iterator configIter = this.getConfigurationList().iterator();
            while (configIter.hasNext()) {
                Configuration current = (Configuration)configIter.next();
                current.resolveReferences();
            }
        }
    }
}

