/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.TargetPlatform;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ToolChain
extends BuildObject
implements IToolChain {
    private static final String EMPTY_STRING = new String();
    private IToolChain superClass;
    private String superClassId;
    private IConfiguration parent;
    private List toolList;
    private Map toolMap;
    private TargetPlatform targetPlatform;
    private Builder builder;
    private String unusedChildren;
    private String errorParserIds;
    private List osList;
    private List archList;
    private Boolean isAbstract;
    private IConfigurationElement scannerInfoCollectorElement;
    private boolean isExtensionToolChain = false;
    private boolean isDirty = false;
    private boolean resolved = true;

    public ToolChain(IConfiguration parent, IManagedConfigElement element) {
        IManagedConfigElement[] builders;
        this.parent = parent;
        this.isExtensionToolChain = true;
        this.resolved = false;
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionToolChain(this);
        IManagedConfigElement[] targetPlatforms = element.getChildren("targetPlatform");
        if (targetPlatforms.length >= 1) {
            targetPlatforms.getClass();
        }
        if (targetPlatforms.length > 0) {
            this.targetPlatform = new TargetPlatform((IToolChain)this, targetPlatforms[0]);
        }
        if ((builders = element.getChildren("builder")).length >= 1) {
            builders.getClass();
        }
        if (builders.length > 0) {
            this.builder = new Builder((IToolChain)this, builders[0]);
        }
        IManagedConfigElement[] tools = element.getChildren("tool");
        int n = 0;
        while (n < tools.length) {
            Tool toolChild = new Tool((IBuildObject)this, tools[n]);
            this.addTool(toolChild);
            ++n;
        }
    }

    public ToolChain(Configuration parent, IToolChain superClass, String Id, String name, boolean isExtensionElement) {
        this.parent = parent;
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionToolChain = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionToolChain(this);
        } else {
            this.setDirty(true);
        }
    }

    public ToolChain(IConfiguration parent, Element element) {
        this.parent = parent;
        this.isExtensionToolChain = false;
        this.loadFromProject(element);
        NodeList configElements = element.getChildNodes();
        int i = 0;
        while (i < configElements.getLength()) {
            Node configElement = configElements.item(i);
            if (configElement.getNodeName().equals("tool")) {
                Tool tool = new Tool((IBuildObject)this, (Element)configElement);
                this.addTool(tool);
            } else if (configElement.getNodeName().equals("targetPlatform")) {
                this.targetPlatform = new TargetPlatform((IToolChain)this, (Element)configElement);
            } else if (configElement.getNodeName().equals("builder")) {
                this.builder = new Builder((IToolChain)this, (Element)configElement);
            }
            ++i;
        }
    }

    public ToolChain(IConfiguration parent, String Id, String name, ToolChain toolChain) {
        String subName;
        String subId;
        int nnn;
        this.parent = parent;
        this.superClass = toolChain.superClass;
        if (this.superClass != null && toolChain.superClassId != null) {
            this.superClassId = new String(toolChain.superClassId);
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionToolChain = false;
        if (toolChain.unusedChildren != null) {
            this.unusedChildren = new String(toolChain.unusedChildren);
        }
        if (toolChain.errorParserIds != null) {
            this.errorParserIds = new String(toolChain.errorParserIds);
        }
        if (toolChain.osList != null) {
            this.osList = new ArrayList(toolChain.osList);
        }
        if (toolChain.archList != null) {
            this.archList = new ArrayList(toolChain.archList);
        }
        if (toolChain.isAbstract != null) {
            this.isAbstract = new Boolean(toolChain.isAbstract);
        }
        this.scannerInfoCollectorElement = toolChain.scannerInfoCollectorElement;
        if (toolChain.builder != null) {
            nnn = ManagedBuildManager.getRandomNumber();
            if (toolChain.builder.getSuperClass() != null) {
                subId = String.valueOf(toolChain.builder.getSuperClass().getId()) + "." + nnn;
                subName = toolChain.builder.getSuperClass().getName();
            } else {
                subId = String.valueOf(toolChain.builder.getId()) + "." + nnn;
                subName = toolChain.builder.getName();
            }
            this.builder = new Builder(this, subId, subName, toolChain.builder);
        }
        if (toolChain.targetPlatform != null) {
            nnn = ManagedBuildManager.getRandomNumber();
            if (toolChain.targetPlatform.getSuperClass() != null) {
                subId = String.valueOf(toolChain.targetPlatform.getSuperClass().getId()) + "." + nnn;
                subName = toolChain.targetPlatform.getSuperClass().getName();
            } else {
                subId = String.valueOf(toolChain.targetPlatform.getId()) + "." + nnn;
                subName = toolChain.targetPlatform.getName();
            }
            this.targetPlatform = new TargetPlatform(this, subId, subName, toolChain.targetPlatform);
        }
        if (toolChain.toolList != null) {
            ListIterator iter = toolChain.getToolList().listIterator();
            while (iter.hasNext()) {
                String subName2;
                String subId2;
                Tool toolChild = (Tool)iter.next();
                int nnn2 = ManagedBuildManager.getRandomNumber();
                if (toolChild.getSuperClass() != null) {
                    subId2 = String.valueOf(toolChild.getSuperClass().getId()) + "." + nnn2;
                    subName2 = toolChild.getSuperClass().getName();
                } else {
                    subId2 = String.valueOf(toolChild.getId()) + "." + nnn2;
                    subName2 = toolChild.getName();
                }
                Tool newTool = new Tool((IBuildObject)this, null, subId2, subName2, toolChild);
                this.addTool(newTool);
            }
        }
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String arch;
        String os;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.superClassId = element.getAttribute("superClass");
        this.unusedChildren = element.getAttribute("unusedChildren");
        String isAbs = element.getAttribute("isAbstract");
        if (isAbs != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        this.errorParserIds = element.getAttribute("errorParsers");
        String scannerInfoCollector = element.getAttribute("scannerInfoCollector");
        if (scannerInfoCollector != null && element instanceof DefaultManagedConfigElement) {
            this.scannerInfoCollectorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((os = element.getAttribute("osList")) != null) {
            this.osList = new ArrayList();
            String[] osTokens = os.split(",");
            int i = 0;
            while (i < osTokens.length) {
                this.osList.add(osTokens[i].trim());
                ++i;
            }
        }
        if ((arch = element.getAttribute("archList")) != null) {
            this.archList = new ArrayList();
            String[] archTokens = arch.split(",");
            int j = 0;
            while (j < archTokens.length) {
                this.archList.add(archTokens[j].trim());
                ++j;
            }
        }
    }

    protected void loadFromProject(Element element) {
        String arch;
        String os;
        String isAbs;
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        this.superClassId = element.getAttribute("superClass");
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.superClass = ManagedBuildManager.getExtensionToolChain(this.superClassId);
        }
        if (element.hasAttribute("unusedChildren")) {
            this.unusedChildren = element.getAttribute("unusedChildren");
        }
        if (element.hasAttribute("isAbstract") && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if (element.hasAttribute("errorParsers")) {
            this.errorParserIds = element.getAttribute("errorParsers");
        }
        if (element.hasAttribute("osList") && (os = element.getAttribute("osList")) != null) {
            this.osList = new ArrayList();
            String[] osTokens = os.split(",");
            int i = 0;
            while (i < osTokens.length) {
                this.osList.add(osTokens[i].trim());
                ++i;
            }
        }
        if (element.hasAttribute("archList") && (arch = element.getAttribute("archList")) != null) {
            this.archList = new ArrayList();
            String[] archTokens = arch.split(",");
            int j = 0;
            while (j < archTokens.length) {
                this.archList.add(archTokens[j].trim());
                ++j;
            }
        }
    }

    public void serialize(Document doc, Element element) {
        String current;
        String listValue;
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.unusedChildren != null) {
            element.setAttribute("unusedChildren", this.unusedChildren);
        }
        if (this.isAbstract != null) {
            element.setAttribute("isAbstract", this.isAbstract.toString());
        }
        if (this.errorParserIds != null) {
            element.setAttribute("errorParsers", this.errorParserIds);
        }
        if (this.osList != null) {
            ListIterator osIter = this.osList.listIterator();
            listValue = EMPTY_STRING;
            while (osIter.hasNext()) {
                current = (String)osIter.next();
                listValue = String.valueOf(listValue) + current;
                if (!osIter.hasNext()) continue;
                listValue = String.valueOf(listValue) + ",";
            }
            element.setAttribute("osList", listValue);
        }
        if (this.archList != null) {
            ListIterator archIter = this.archList.listIterator();
            listValue = EMPTY_STRING;
            while (archIter.hasNext()) {
                current = (String)archIter.next();
                listValue = String.valueOf(listValue) + current;
                if (!archIter.hasNext()) continue;
                listValue = String.valueOf(listValue) + ",";
            }
            element.setAttribute("archList", listValue);
        }
        if (this.targetPlatform != null) {
            Element targetPlatformElement = doc.createElement("targetPlatform");
            element.appendChild(targetPlatformElement);
            this.targetPlatform.serialize(doc, targetPlatformElement);
        }
        if (this.builder != null) {
            Element builderElement = doc.createElement("builder");
            element.appendChild(builderElement);
            this.builder.serialize(doc, builderElement);
        }
        List toolElements = this.getToolList();
        ListIterator iter = toolElements.listIterator();
        while (iter.hasNext()) {
            Tool tool = (Tool)iter.next();
            Element toolElement = doc.createElement("tool");
            element.appendChild(toolElement);
            tool.serialize(doc, toolElement);
        }
        this.isDirty = false;
    }

    public IConfiguration getParent() {
        return this.parent;
    }

    public ITargetPlatform createTargetPlatform(ITargetPlatform superClass, String id, String name, boolean isExtensionElement) {
        this.targetPlatform = new TargetPlatform(this, superClass, id, name, isExtensionElement);
        this.setDirty(true);
        return this.targetPlatform;
    }

    public ITargetPlatform getTargetPlatform() {
        if (this.targetPlatform == null && this.superClass != null) {
            return this.superClass.getTargetPlatform();
        }
        return this.targetPlatform;
    }

    public void removeLocalTargetPlatform() {
        if (this.targetPlatform == null) {
            return;
        }
        this.targetPlatform = null;
        this.setDirty(true);
    }

    public IBuilder createBuilder(IBuilder superClass, String id, String name, boolean isExtensionElement) {
        this.builder = new Builder(this, superClass, id, name, isExtensionElement);
        this.setDirty(true);
        return this.builder;
    }

    public IBuilder getBuilder() {
        if (this.builder == null && this.superClass != null) {
            return this.superClass.getBuilder();
        }
        return this.builder;
    }

    public void removeLocalBuilder() {
        if (this.builder == null) {
            return;
        }
        this.builder = null;
        this.setDirty(true);
    }

    public ITool createTool(ITool superClass, String id, String name, boolean isExtensionElement) {
        Tool tool = new Tool(this, superClass, id, name, isExtensionElement);
        this.addTool(tool);
        this.setDirty(true);
        return tool;
    }

    public ITool[] getTools() {
        ITool[] tools = null;
        if (this.superClass != null) {
            tools = this.superClass.getTools();
        }
        if (tools != null) {
            ListIterator iter = this.getToolList().listIterator();
            while (iter.hasNext()) {
                Tool tool = (Tool)iter.next();
                int j = 0;
                while (j < tools.length) {
                    if (tool.getSuperClass().getId().equals(tools[j].getId())) {
                        tools[j] = tool;
                        break;
                    }
                    ++j;
                }
                if (j != tools.length) continue;
                ITool[] newTools = new ITool[tools.length + 1];
                int k = 0;
                while (k < tools.length) {
                    newTools[k] = tools[k];
                    ++k;
                }
                newTools[j] = tool;
                tools = newTools;
            }
        } else {
            tools = new ITool[this.getToolList().size()];
            ListIterator iter = this.getToolList().listIterator();
            int i = 0;
            while (iter.hasNext()) {
                Tool tool = (Tool)iter.next();
                tools[i++] = tool;
            }
        }
        return tools;
    }

    public ITool getTool(String id) {
        Tool tool = (Tool)this.getToolMap().get(id);
        return tool;
    }

    public List getToolList() {
        if (this.toolList == null) {
            this.toolList = new ArrayList();
        }
        return this.toolList;
    }

    private Map getToolMap() {
        if (this.toolMap == null) {
            this.toolMap = new HashMap();
        }
        return this.toolMap;
    }

    public void addTool(Tool tool) {
        this.getToolList().add(tool);
        this.getToolMap().put(tool.getId(), tool);
    }

    public IToolChain getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    public boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    public String getUnusedChildren() {
        if (this.unusedChildren != null) {
            return this.unusedChildren;
        }
        return EMPTY_STRING;
    }

    public String getErrorParserIds() {
        String ids = this.errorParserIds;
        if (ids == null && this.superClass != null) {
            ids = this.superClass.getErrorParserIds();
        }
        if (ids == null) {
            ids = this.builder.getErrorParserIds();
            ITool[] tools = this.getTools();
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                String toolIds = tool.getErrorParserIds();
                if (toolIds != null && toolIds.length() > 0) {
                    if (ids != null) {
                        ids = String.valueOf(ids) + ";";
                        ids = String.valueOf(ids) + toolIds;
                    } else {
                        ids = toolIds;
                    }
                }
                ++i;
            }
        }
        return ids;
    }

    public String getErrorParserIds(IConfiguration config) {
        String ids = this.errorParserIds;
        if (ids == null && this.superClass != null) {
            ids = this.superClass.getErrorParserIds(config);
        }
        if (ids == null) {
            if (this.builder != null) {
                ids = this.builder.getErrorParserIds();
            }
            ITool[] tools = config.getFilteredTools();
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                String toolIds = tool.getErrorParserIds();
                if (toolIds != null && toolIds.length() > 0) {
                    if (ids != null) {
                        ids = String.valueOf(ids) + ";";
                        ids = String.valueOf(ids) + toolIds;
                    } else {
                        ids = toolIds;
                    }
                }
                ++i;
            }
        }
        return ids;
    }

    public String[] getErrorParserList() {
        String[] errorParsers;
        String parserIDs = this.getErrorParserIds();
        if (parserIDs != null) {
            if (parserIDs.length() == 0) {
                errorParsers = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{""};
                errorParsers = list.toArray(strArr);
            }
        } else {
            errorParsers = new String[]{};
        }
        return errorParsers;
    }

    public String[] getArchList() {
        if (this.archList == null) {
            if (this.superClass != null) {
                return this.superClass.getArchList();
            }
            return new String[]{"all"};
        }
        return this.archList.toArray(new String[this.archList.size()]);
    }

    public String[] getOSList() {
        if (this.osList == null) {
            if (this.superClass != null) {
                return this.superClass.getOSList();
            }
            return new String[]{"all"};
        }
        return this.osList.toArray(new String[this.osList.size()]);
    }

    public void setIsAbstract(boolean b) {
        this.isAbstract = new Boolean(b);
        this.setDirty(true);
    }

    public void setErrorParserIds(String ids) {
        String currentIds = this.getErrorParserIds();
        if (ids == null && currentIds == null) {
            return;
        }
        if (currentIds == null || ids == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    public void setOSList(String[] OSs) {
        if (this.osList == null) {
            this.osList = new ArrayList();
        } else {
            this.osList.clear();
        }
        int i = 0;
        while (i < OSs.length) {
            this.osList.add(OSs[i]);
            ++i;
        }
        this.setDirty(true);
    }

    public void setArchList(String[] archs) {
        if (this.archList == null) {
            this.archList = new ArrayList();
        } else {
            this.archList.clear();
        }
        int i = 0;
        while (i < archs.length) {
            this.archList.add(archs[i]);
            ++i;
        }
        this.setDirty(true);
    }

    public IConfigurationElement getScannerInfoCollectorElement() {
        if (this.scannerInfoCollectorElement == null && this.superClass != null) {
            return this.superClass.getScannerInfoCollectorElement();
        }
        return this.scannerInfoCollectorElement;
    }

    public void setScannerInfoCollectorElement(IConfigurationElement element) {
        this.scannerInfoCollectorElement = element;
        this.setDirty(true);
    }

    public boolean isExtensionElement() {
        return this.isExtensionToolChain;
    }

    public boolean isDirty() {
        if (this.isExtensionToolChain) {
            return false;
        }
        if (this.isDirty) {
            return true;
        }
        ListIterator iter = this.getToolList().listIterator();
        while (iter.hasNext()) {
            Tool toolChild = (Tool)iter.next();
            if (!toolChild.isDirty()) continue;
            return true;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            ListIterator iter = this.getToolList().listIterator();
            while (iter.hasNext()) {
                Tool toolChild = (Tool)iter.next();
                toolChild.setDirty(false);
            }
        }
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionToolChain(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.OutputResolveError("superClass", this.superClassId, "toolChain", this.getId());
                }
            }
            if (this.targetPlatform != null) {
                this.targetPlatform.resolveReferences();
            }
            if (this.builder != null) {
                this.builder.resolveReferences();
            }
            ListIterator iter = this.getToolList().listIterator();
            while (iter.hasNext()) {
                Tool toolChild = (Tool)iter.next();
                toolChild.resolveReferences();
            }
        }
    }

    public void normalizeOutputExtensions() {
        ITool[] tools = this.getTools();
        if (tools != null) {
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                String[] extensions = tool.getOutputExtensions();
                if (extensions == null) {
                    tool.setOutputExtensions("");
                } else if (extensions.length == 0) {
                    tool.setOutputExtensions("");
                }
                ++i;
            }
        }
    }
}

