/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.processing;

import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;

public class IndexingJob
extends Job {
    IProgressMonitor progressMonitor = null;
    IProgressMonitor group = Platform.getJobManager().createProgressGroup();
    JobManager jobManager = null;
    Thread indexThread = null;
    static final String JOB_NAME = Util.bind("indexerJob");
    int ticks = 0;
    int maxTicks = 0;
    int workDone = 0;

    public IndexingJob(Thread thread, JobManager manager) {
        super(JOB_NAME);
        this.group.beginTask(JOB_NAME, 100);
        this.jobManager = manager;
        this.indexThread = thread;
        this.setPriority(30);
        this.setProgressGroup(this.group, 100);
        this.tickUp();
        this.schedule();
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.progressMonitor = monitor;
        this.setThread(this.indexThread);
        this.progressMonitor.beginTask("", 100);
        return Job.ASYNC_FINISH;
    }

    public synchronized void tickUp() {
        ++this.ticks;
        if (this.ticks > this.maxTicks) {
            this.maxTicks = this.ticks;
        }
        this.updateRemainingCount(null);
    }

    public synchronized void setTicks(int n) {
        this.ticks = n;
        if (this.maxTicks < this.ticks) {
            this.maxTicks = this.ticks;
        }
        this.updatePercentage();
        this.updateRemainingCount(null);
    }

    public synchronized int tickDown(String str) {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            this.jobManager.pause();
            return 0;
        }
        --this.ticks;
        this.updatePercentage();
        this.updateRemainingCount(str);
        return this.ticks;
    }

    private void updateRemainingCount(String str) {
        if (this.progressMonitor == null) {
            return;
        }
        String taskString = Util.bind("manager.filesToIndex", Integer.toString(this.ticks));
        if (str != null) {
            taskString = String.valueOf(taskString) + str;
        }
        this.progressMonitor.subTask(taskString);
    }

    private void updatePercentage() {
        if (this.progressMonitor == null) {
            return;
        }
        int work = (this.maxTicks - this.ticks) * 100 / this.maxTicks - this.workDone;
        this.workDone += work;
        this.progressMonitor.worked(work);
        if (this.workDone < 0) {
            this.workDone = 0;
        }
    }

    public IProgressMonitor getProgressGroup() {
        return this.group;
    }
}

