/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.core.parser.util.CharTable;

public class CharArrayObjectMap
extends CharTable {
    public static final CharArrayObjectMap EMPTY_MAP = new CharArrayObjectMap(0){

        public Object clone() {
            return this;
        }

        public List toList() {
            return Collections.EMPTY_LIST;
        }

        public Object put(char[] key, int start, int length, Object value) {
            throw new UnsupportedOperationException();
        }
    };
    private Object[] valueTable = new Object[this.capacity()];

    public CharArrayObjectMap(int initialSize) {
        super(initialSize);
    }

    public Object put(char[] key, int start, int length, Object value) {
        int i = this.addIndex(key, start, length);
        Object oldvalue = this.valueTable[i];
        this.valueTable[i] = value;
        return oldvalue;
    }

    public final Object put(char[] key, Object value) {
        return this.put(key, 0, key.length, value);
    }

    public final Object get(char[] key, int start, int length) {
        int i = this.lookup(key, start, length);
        if (i >= 0) {
            return this.valueTable[i];
        }
        return null;
    }

    public final Object get(char[] key) {
        return this.get(key, 0, key.length);
    }

    public final Object getAt(int i) {
        if (i < 0 || i > this.currEntry) {
            return null;
        }
        return this.valueTable[i];
    }

    public final Object remove(char[] key, int start, int length) {
        int i = this.lookup(key, start, length);
        if (i < 0) {
            return null;
        }
        Object value = this.valueTable[i];
        if (i < this.currEntry) {
            System.arraycopy(this.valueTable, i + 1, this.valueTable, i, this.currEntry - i);
        }
        this.valueTable[this.currEntry] = null;
        this.removeEntry(i);
        return value;
    }

    public Object clone() {
        CharArrayObjectMap newTable = (CharArrayObjectMap)super.clone();
        newTable.valueTable = new Object[this.capacity()];
        System.arraycopy(this.valueTable, 0, newTable.valueTable, 0, this.valueTable.length);
        return newTable;
    }

    protected void resize(int size) {
        Object[] oldValueTable = this.valueTable;
        this.valueTable = new Object[size];
        System.arraycopy(oldValueTable, 0, this.valueTable, 0, oldValueTable.length);
        super.resize(size);
    }

    public void clear() {
        super.clear();
        int i = 0;
        while (i < this.capacity()) {
            this.valueTable[i] = null;
            ++i;
        }
    }

    protected int partition(Comparator c, int p, int r) {
        char[] x = this.keyTable[p];
        Object temp = null;
        int i = p;
        int j = r;
        while (true) {
            if (c.compare(this.keyTable[j], x) > 0) {
                --j;
                continue;
            }
            if (i < j) {
                while (c.compare(this.keyTable[i], x) < 0) {
                    ++i;
                }
            }
            if (i >= j) break;
            temp = this.keyTable[j];
            this.keyTable[j] = this.keyTable[i];
            this.keyTable[i] = temp;
            temp = this.valueTable[j];
            this.valueTable[j] = this.valueTable[i];
            this.valueTable[i] = temp;
        }
        return j;
    }
}

