/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.Hashtable;
import org.eclipse.cdt.core.parser.BacktrackException;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.Enum;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.ASTSemanticException;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTDesignator;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.gcc.IASTGCCDesignator;
import org.eclipse.cdt.core.parser.ast.gcc.IASTGCCExpression;
import org.eclipse.cdt.core.parser.ast.gcc.IASTGCCSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.extension.IParserExtension;
import org.eclipse.cdt.internal.core.parser.DeclarationWrapper;
import org.eclipse.cdt.internal.core.parser.IParserData;
import org.eclipse.cdt.internal.core.parser.Parser;

public class GCCParserExtension
implements IParserExtension {
    private static final char[] EMPTY_STRING = "".toCharArray();

    public boolean isValidCVModifier(ParserLanguage language, int tokenType) {
        return tokenType == 137 && language == ParserLanguage.CPP;
    }

    public ASTPointerOperator getPointerOperator(ParserLanguage language, int tokenType) {
        if (tokenType == 137 && language == ParserLanguage.CPP) {
            return ASTPointerOperator.RESTRICT_POINTER;
        }
        return null;
    }

    public boolean isValidUnaryExpressionStart(int tokenType) {
        switch (tokenType) {
            case 140: 
            case 141: {
                return true;
            }
        }
        return false;
    }

    public IASTExpression parseUnaryExpression(IASTScope scope, IParserData data, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) {
        try {
            switch (data.LT(1)) {
                case 141: {
                    return this.performUnaryExpression(data, scope, kind, key, UnaryExpressionKind.ALIGNOF);
                }
                case 140: {
                    return this.performUnaryExpression(data, scope, kind, key, UnaryExpressionKind.TYPEOF);
                }
            }
        }
        catch (EndOfFileException endOfFileException) {}
        return null;
    }

    protected IASTExpression performUnaryExpression(IParserData data, IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key, UnaryExpressionKind type) {
        IToken startingPoint = null;
        try {
            if (type == UnaryExpressionKind.ALIGNOF) {
                startingPoint = data.consume(141);
            } else if (type == UnaryExpressionKind.TYPEOF) {
                startingPoint = data.consume(140);
            }
        }
        catch (BacktrackException backtrackException) {
            return null;
        }
        catch (EndOfFileException endOfFileException) {
            return null;
        }
        try {
            IToken mark = data.mark();
            IASTTypeId d = null;
            IASTExpression unaryExpression = null;
            if (data.LT(1) == 8) {
                try {
                    data.consume(8);
                    d = data.typeId(scope, false, IASTCompletionNode.CompletionKind.TYPE_REFERENCE);
                    data.consume(9);
                }
                catch (BacktrackException backtrackException) {
                    data.backup(mark);
                    d = null;
                    unaryExpression = data.unaryExpression(scope, kind, key);
                }
            } else {
                unaryExpression = data.unaryExpression(scope, kind, key);
            }
            if (d != null & unaryExpression == null) {
                try {
                    IASTGCCExpression.Kind expKind = null;
                    if (type == UnaryExpressionKind.ALIGNOF) {
                        expKind = IASTGCCExpression.Kind.UNARY_ALIGNOF_TYPEID;
                    } else if (type == UnaryExpressionKind.TYPEOF) {
                        expKind = IASTGCCExpression.Kind.UNARY_TYPEOF_TYPEID;
                    }
                    return data.getAstFactory().createExpression(scope, expKind, null, null, null, d, null, EMPTY_STRING, null, null);
                }
                catch (ASTSemanticException aSTSemanticException) {
                    data.backup(startingPoint);
                    return null;
                }
                catch (Exception e) {
                    data.logException("unaryExpression_1::createExpression()", e);
                    data.backup(startingPoint);
                    return null;
                }
            }
            if (unaryExpression != null && d == null) {
                try {
                    IASTGCCExpression.Kind expKind = null;
                    if (type == UnaryExpressionKind.ALIGNOF) {
                        expKind = IASTGCCExpression.Kind.UNARY_ALIGNOF_UNARYEXPRESSION;
                    } else if (type == UnaryExpressionKind.TYPEOF) {
                        expKind = IASTGCCExpression.Kind.UNARY_TYPEOF_UNARYEXPRESSION;
                    }
                    return data.getAstFactory().createExpression(scope, expKind, unaryExpression, null, null, null, null, EMPTY_STRING, null, null);
                }
                catch (ASTSemanticException aSTSemanticException) {
                    data.backup(startingPoint);
                    return null;
                }
                catch (Exception e) {
                    data.logException("unaryExpression_1::createExpression()", e);
                    data.backup(startingPoint);
                    return null;
                }
            }
            return null;
        }
        catch (BacktrackException backtrackException) {
            data.backup(startingPoint);
            return null;
        }
        catch (EndOfFileException endOfFileException) {
            data.backup(startingPoint);
            return null;
        }
    }

    public boolean canHandleDeclSpecifierSequence(int tokenType) {
        switch (tokenType) {
            case 140: {
                return true;
            }
        }
        return false;
    }

    public IParserExtension.IDeclSpecifierExtensionResult parseDeclSpecifierSequence(IParserData data, Parser.Flags flags, DeclarationWrapper sdw, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) {
        IToken startingPoint = null;
        try {
            startingPoint = data.mark();
        }
        catch (EndOfFileException endOfFileException) {
            return null;
        }
        try {
            switch (data.LT(1)) {
                case 140: {
                    IASTExpression typeOfExpression = this.performUnaryExpression(data, sdw.getScope(), kind, key, UnaryExpressionKind.TYPEOF);
                    if (typeOfExpression != null) {
                        sdw.setSimpleType(IASTGCCSimpleTypeSpecifier.Type.TYPEOF);
                        flags.setEncounteredRawType(true);
                        Hashtable<String, IASTExpression> params = new Hashtable<String, IASTExpression>();
                        params.put("TYPEOF EXPRESSION", typeOfExpression);
                        sdw.setExtensionParameter("TYPEOF EXPRESSION", typeOfExpression);
                        return new GCCDeclSpecifierExtensionResult(startingPoint, data.getLastToken(), flags, params);
                    }
                    data.backup(startingPoint);
                    return null;
                }
            }
            data.backup(startingPoint);
            return null;
        }
        catch (EndOfFileException endOfFileException) {
            data.backup(startingPoint);
            return null;
        }
    }

    public boolean isValidRelationalExpressionStart(ParserLanguage language, int tokenType) {
        switch (tokenType) {
            case 142: 
            case 143: {
                return true;
            }
        }
        return false;
    }

    public IASTExpression parseRelationalExpression(IASTScope scope, IParserData data, IASTCompletionNode.CompletionKind kind, KeywordSetKey key, IASTExpression lhsExpression) {
        if (data.getParserLanguage() == ParserLanguage.C) {
            return null;
        }
        IToken mark = null;
        try {
            mark = data.mark();
        }
        catch (EndOfFileException endOfFileException) {
            return null;
        }
        IASTGCCExpression.Kind expressionKind = null;
        try {
            switch (data.LT(1)) {
                case 142: {
                    data.consume(142);
                    expressionKind = IASTGCCExpression.Kind.RELATIONAL_MAX;
                    break;
                }
                case 143: {
                    data.consume(143);
                    expressionKind = IASTGCCExpression.Kind.RELATIONAL_MIN;
                    break;
                }
                default: {
                    data.backup(mark);
                    return null;
                }
            }
            IToken next = data.LA(1);
            IASTExpression secondExpression = data.shiftExpression(scope, kind, key);
            if (next == data.LA(1)) {
                data.backup(mark);
                return null;
            }
            try {
                IASTExpression resultExpression = data.getAstFactory().createExpression(scope, expressionKind, lhsExpression, secondExpression, null, null, null, EMPTY_STRING, null, null);
                return resultExpression;
            }
            catch (ASTSemanticException aSTSemanticException) {
                data.backup(mark);
                return null;
            }
        }
        catch (EndOfFileException endOfFileException) {
            data.backup(mark);
            return null;
        }
        catch (BacktrackException backtrackException) {
            data.backup(mark);
            return null;
        }
    }

    public boolean canHandleCDesignatorInitializer(int tokenType) {
        switch (tokenType) {
            case 1: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public IASTDesignator parseDesignator(IParserData parserData, IASTScope scope) {
        IToken startingPoint = null;
        try {
            startingPoint = parserData.mark();
        }
        catch (EndOfFileException endOfFileException) {
            return null;
        }
        try {
            if (parserData.LT(1) == 1) {
                IToken identifier = parserData.identifier();
                parserData.consume(4);
                return parserData.getAstFactory().createDesignator(IASTDesignator.DesignatorKind.FIELD, null, identifier, null);
            }
            if (parserData.LT(1) == 10) {
                parserData.consume(10);
                IASTExpression constantExpression1 = parserData.expression(scope, IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, KeywordSetKey.EXPRESSION);
                parserData.consume(48);
                IASTExpression constantExpression2 = parserData.expression(scope, IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, KeywordSetKey.EXPRESSION);
                parserData.consume(11);
                Hashtable<String, IASTExpression> extensionParms = new Hashtable<String, IASTExpression>();
                extensionParms.put("SUBSCRIPT2 EXPRESSION", constantExpression2);
                return parserData.getAstFactory().createDesignator(IASTGCCDesignator.DesignatorKind.SUBSCRIPT_RANGE, constantExpression1, null, extensionParms);
            }
        }
        catch (EndOfFileException endOfFileException) {
        }
        catch (BacktrackException backtrackException) {}
        parserData.backup(startingPoint);
        return null;
    }

    public boolean supportsStatementsInExpressions() {
        return true;
    }

    public IASTExpression.Kind getExpressionKindForStatement() {
        return IASTGCCExpression.Kind.STATEMENT_EXPRESSION;
    }

    public boolean supportsExtendedTemplateInstantiationSyntax() {
        return true;
    }

    public boolean isValidModifierForInstantiation(IToken la) {
        if (la == null) {
            return false;
        }
        switch (la.getType()) {
            case 80: 
            case 87: 
            case 106: {
                return true;
            }
        }
        return false;
    }

    protected static class UnaryExpressionKind
    extends Enum {
        public static final UnaryExpressionKind ALIGNOF = new UnaryExpressionKind(1);
        public static final UnaryExpressionKind TYPEOF = new UnaryExpressionKind(2);

        protected UnaryExpressionKind(int enumValue) {
            super(enumValue);
        }
    }

    public class GCCDeclSpecifierExtensionResult
    implements IParserExtension.IDeclSpecifierExtensionResult {
        private final IToken first;
        private final IToken last;
        private final Parser.Flags flags;

        public GCCDeclSpecifierExtensionResult(IToken startingPoint, IToken token, Parser.Flags flags, Hashtable params) {
            this.first = startingPoint;
            this.last = token;
            this.flags = flags;
        }

        public IToken getFirstToken() {
            return this.first;
        }

        public IToken getLastToken() {
            return this.last;
        }

        public Parser.Flags getFlags() {
            return this.flags;
        }
    }
}

