/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast;

import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTMacro;

public class ASTMacro
implements IASTMacro {
    private int nameEndOffset = 0;
    private final char[] name;
    private final char[] fn;
    private int startingOffset = 0;
    private int endingOffset = 0;
    private int nameOffset = 0;
    private int startingLineNumber;
    private int endingLineNumber;
    private int nameLineNumber;
    private int fileIndex;

    public ASTMacro(char[] name, int start, int startLine, int nameBeg, int nameEnd, int nameLine, int end, int endLine, char[] fn) {
        this.name = name;
        this.setStartingOffsetAndLineNumber(start, startLine);
        this.setNameOffset(nameBeg);
        this.setNameEndOffsetAndLineNumber(nameEnd, nameLine);
        this.setEndingOffsetAndLineNumber(end, endLine);
        this.fn = fn;
    }

    public String getName() {
        return String.valueOf(this.name);
    }

    public char[] getNameCharArray() {
        return this.name;
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public void setNameOffset(int o) {
        this.nameOffset = o;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameOffset;
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            requestor.acceptMacro(this);
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(int index) {
        this.fileIndex = index;
    }

    public char[] getFilename() {
        return this.fn;
    }
}

