/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.scannerconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;

public class DiscoveredElement {
    public static final int CONTAINER = 1;
    public static final int INCLUDE_PATH = 2;
    public static final int SYMBOL_DEFINITION = 3;
    public static final int PATHS_GROUP = 4;
    public static final int SYMBOLS_GROUP = 5;
    private IProject fProject;
    private String fEntry;
    private int fEntryKind;
    private boolean fRemoved;
    private boolean fSystem;
    private ArrayList fChildren = new ArrayList();
    private DiscoveredElement fParent;

    public DiscoveredElement(IProject project, String entry, int kind, boolean removed, boolean system) {
        this.fProject = project;
        this.fEntry = entry;
        this.fEntryKind = kind;
        this.fRemoved = removed;
        this.fSystem = system;
    }

    public static DiscoveredElement createNew(DiscoveredElement parent, IProject project, String entry, int kind, boolean removed, boolean system) {
        DiscoveredElement rv = null;
        switch (kind) {
            case 1: {
                rv = new DiscoveredElement(project, entry, kind, removed, system);
                DiscoveredElement group = new DiscoveredElement(project, null, 4, false, false);
                rv.fChildren.add(group);
                group.fParent = rv;
                group = new DiscoveredElement(project, null, 5, false, false);
                rv.fChildren.add(group);
                group.fParent = rv;
                break;
            }
            case 2: {
                if (parent == null) break;
                DiscoveredElement group = null;
                if (parent.getEntryKind() == 4) {
                    group = parent = parent.getParent();
                } else if (parent.getEntryKind() == 1) {
                    Iterator i = parent.fChildren.iterator();
                    while (i.hasNext()) {
                        DiscoveredElement child = (DiscoveredElement)i.next();
                        if (child.getEntryKind() != 4) continue;
                        group = child;
                        break;
                    }
                    if (group == null) {
                        return null;
                    }
                }
                if (parent.getEntryKind() != 1) break;
                rv = new DiscoveredElement(project, entry, kind, removed, system);
                group.fChildren.add(rv);
                rv.setParent(group);
                break;
            }
            case 3: {
                if (parent == null) break;
                DiscoveredElement group = null;
                if (parent.getEntryKind() == 5) {
                    group = parent = parent.getParent();
                } else if (parent.getEntryKind() == 1) {
                    Iterator i = parent.fChildren.iterator();
                    while (i.hasNext()) {
                        DiscoveredElement child = (DiscoveredElement)i.next();
                        if (child.getEntryKind() != 5) continue;
                        group = child;
                        break;
                    }
                    if (group == null) {
                        return null;
                    }
                }
                if (parent.getEntryKind() != 1) break;
                rv = new DiscoveredElement(project, entry, kind, removed, system);
                group.fChildren.add(rv);
                rv.setParent(group);
            }
        }
        return rv;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public String getEntry() {
        return this.fEntry;
    }

    public void setEntry(String entry) {
        this.fEntry = entry;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public void setEntryKind(int entryKind) {
        this.fEntryKind = entryKind;
    }

    public boolean isRemoved() {
        return this.fRemoved;
    }

    public void setRemoved(boolean removed) {
        this.fRemoved = removed;
    }

    public DiscoveredElement getParent() {
        return this.fParent;
    }

    private void setParent(DiscoveredElement parent) {
        this.fParent = parent;
    }

    public Object[] getChildren() {
        switch (this.fEntryKind) {
            case 2: 
            case 3: {
                return new Object[0];
            }
        }
        return this.fChildren.toArray();
    }

    public boolean hasChildren() {
        switch (this.fEntryKind) {
            case 2: 
            case 3: {
                return false;
            }
        }
        return this.fChildren.size() > 0;
    }

    public void setChildren(Object[] children) {
        this.fChildren = new ArrayList<Object>(Arrays.asList(children));
    }

    public boolean delete() {
        boolean rc = false;
        DiscoveredElement parent = this.getParent();
        if (parent != null) {
            rc = parent.fChildren.remove(this);
            Iterator i = this.fChildren.iterator();
            while (i.hasNext()) {
                DiscoveredElement child = (DiscoveredElement)i.next();
                child.setParent(null);
                rc |= true;
            }
        }
        return rc;
    }
}

