/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ICFileTypeResolver;
import org.eclipse.cdt.core.filetype.IResolverModel;
import org.eclipse.cdt.internal.ui.preferences.CFileTypesPreferenceBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CFileTypesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CFileTypesPreferenceBlock fPrefsBlock;
    private ICFileTypeResolver fResolver;

    public CFileTypesPreferencePage() {
        this.setDescription(PreferencesMessages.getString("CFileTypesPreferencePage.description"));
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite topPane = new Composite(parent, 0);
        topPane.setLayout((Layout)new GridLayout());
        topPane.setLayoutData((Object)new GridData(1808));
        this.fResolver = this.getResolverModel().getResolver();
        this.fPrefsBlock = new CFileTypesPreferenceBlock(this.fResolver);
        WorkbenchHelp.setHelp((Control)topPane, (String)"org.eclipse.cdt.ui.c_file_types");
        return this.fPrefsBlock.createControl(topPane);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        prefs.setToDefault("org.eclipse.cdt.core.associationExclusion");
        prefs.setToDefault("org.eclipse.cdt.core.associationInclusion");
        this.fPrefsBlock.setResolver(this.getResolverModel().getResolver());
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fPrefsBlock.performOk()) {
            ICFileTypeAssociation[] oldAssocs = this.fResolver.getFileTypeAssociations();
            ICFileTypeResolver workingCopy = this.fPrefsBlock.getResolverWorkingCopy();
            ICFileTypeAssociation[] newAssocs = workingCopy.getFileTypeAssociations();
            ArrayList<ICFileTypeAssociation> delList = new ArrayList<ICFileTypeAssociation>();
            ArrayList<ICFileTypeAssociation> addList = new ArrayList<ICFileTypeAssociation>();
            int i = 0;
            while (i < oldAssocs.length) {
                if (Arrays.binarySearch(newAssocs, oldAssocs[i], ICFileTypeAssociation.Comparator) < 0) {
                    delList.add(oldAssocs[i]);
                }
                ++i;
            }
            i = 0;
            while (i < newAssocs.length) {
                if (Arrays.binarySearch(oldAssocs, newAssocs[i], ICFileTypeAssociation.Comparator) < 0) {
                    addList.add(newAssocs[i]);
                }
                ++i;
            }
            ICFileTypeAssociation[] addAssocs = addList.toArray(new ICFileTypeAssociation[addList.size()]);
            ICFileTypeAssociation[] delAssocs = delList.toArray(new ICFileTypeAssociation[delList.size()]);
            this.fResolver.adjustAssociations(addAssocs, delAssocs);
        }
        return super.performOk();
    }

    private IResolverModel getResolverModel() {
        return CCorePlugin.getDefault().getResolverModel();
    }
}

