/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.ui.refactoring.IChangePreviewViewer;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TextChangePreviewViewer
implements IChangePreviewViewer {
    private ComparePreviewer fViewer;

    public static Object createInput(TextChange change) {
        return change;
    }

    public static Object createInput(TextChange.EditChange change, int surroundingLines) {
        TextEditChangeInput result = new TextEditChangeInput();
        result.change = change;
        result.surroundingLines = surroundingLines;
        return result;
    }

    public static Object createInput(TextChange.EditChange[] changes, IRegion range) {
        TextEditChangeInput result = new TextEditChangeInput();
        result.changes = changes;
        result.range = range;
        return result;
    }

    public void createControl(Composite parent) {
        this.fViewer = new ComparePreviewer(parent);
    }

    public Control getControl() {
        return this.fViewer;
    }

    public void setInput(Object input) throws CoreException {
        if (input instanceof TextChange) {
            TextChange change = (TextChange)input;
            this.setInput(change.getCurrentContent(), change.getPreviewContent(), change.getTextType());
            return;
        }
        if (input instanceof TextEditChangeInput) {
            TextEditChangeInput edi = (TextEditChangeInput)input;
            if (edi.change != null && edi.surroundingLines >= 0) {
                TextChange.EditChange editChange = edi.change;
                TextChange change = editChange.getTextChange();
                this.setInput(change.getCurrentContent(editChange, 2), change.getPreviewContent(editChange, 2), change.getTextType());
                return;
            }
            if (edi.changes != null && edi.changes.length > 0 && edi.range != null) {
                TextChange change = edi.changes[0].getTextChange();
                this.setInput(change.getCurrentContent(edi.range), change.getPreviewContent(edi.changes, edi.range), change.getTextType());
                return;
            }
        } else {
            this.fViewer.setInput(null);
        }
    }

    public void refresh() {
        this.fViewer.getViewer().refresh();
    }

    private void setInput(String left, String right, String type) {
        this.fViewer.setInput(new DiffNode((ITypedElement)new CompareElement(left, type), (ITypedElement)new CompareElement(right, type)));
    }

    private static class TextEditChangeInput {
        TextChange.EditChange change;
        int surroundingLines;
        TextChange.EditChange[] changes;
        IRegion range;

        TextEditChangeInput() {
        }
    }

    private static class ComparePreviewer
    extends CompareViewerSwitchingPane {
        private CompareConfiguration fCompareConfiguration = new CompareConfiguration();

        public ComparePreviewer(Composite parent) {
            super(parent, 0x800800, true);
            this.fCompareConfiguration.setLeftEditable(false);
            this.fCompareConfiguration.setLeftLabel(RefactoringMessages.getString("ComparePreviewer.original_source"));
            this.fCompareConfiguration.setRightEditable(false);
            this.fCompareConfiguration.setRightLabel(RefactoringMessages.getString("ComparePreviewer.refactored_source"));
        }

        protected Viewer getViewer(Viewer oldViewer, Object input) {
            return CompareUI.findContentViewer((Viewer)oldViewer, (ICompareInput)((ICompareInput)input), (Composite)this, (CompareConfiguration)this.fCompareConfiguration);
        }

        public void setText(String text) {
            super.setText(text);
        }
    }

    private static class CompareElement
    implements ITypedElement,
    IStreamContentAccessor {
        private InputStream fContent;
        private String fType;

        public CompareElement(String content, String type) {
            this.fContent = CompareElement.createInputStream(content);
            this.fType = type;
        }

        public String getName() {
            return RefactoringMessages.getString("ComparePreviewer.element_name");
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return this.fType;
        }

        public InputStream getContents() throws CoreException {
            return this.fContent;
        }

        private static InputStream createInputStream(String s) {
            try {
                return new ByteArrayInputStream(s.getBytes(ResourcesPlugin.getEncoding()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new ByteArrayInputStream(s.getBytes());
            }
        }
    }
}

