/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IUndoManager;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.UndoManagerAdapter;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.actions.UndoManagerAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchSite;

public class UndoRefactoringAction
extends UndoManagerAction {
    private int fPatternLength;
    private CEditor fEditor;

    public UndoRefactoringAction(CEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
    }

    public UndoRefactoringAction(IWorkbenchSite site) {
        super(site);
        this.init(site.getWorkbenchWindow());
    }

    protected String getName() {
        return RefactoringMessages.getString("UndoRefactoringAction.name");
    }

    protected IRunnableWithProgress createOperation(final ChangeContext context) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    UndoRefactoringAction.this.setPreflightStatus(Refactoring.getUndoManager().performUndo(context, pm));
                }
                catch (CModelException e) {
                    throw new InvocationTargetException(e);
                }
                catch (ChangeAbortException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    protected UndoManagerAdapter createUndoManagerListener() {
        return new UndoManagerAdapter(){

            public void undoStackChanged(IUndoManager manager) {
                IAction action = UndoRefactoringAction.this.getAction();
                if (action == null) {
                    return;
                }
                boolean enabled = false;
                String text = null;
                if (manager.anythingToUndo()) {
                    enabled = true;
                    text = UndoRefactoringAction.this.getActionText();
                } else {
                    text = RefactoringMessages.getString("UndoRefactoringAction.label");
                }
                action.setEnabled(enabled);
                action.setText(text);
            }
        };
    }

    public void selectionChanged(ISelection s) {
        this.selectionChanged((IAction)this, s);
    }

    public void selectionChanged(IAction action, ISelection s) {
        if (!this.isHooked()) {
            this.hookListener((IAction)this);
        }
        this.fPatternLength = RefactoringMessages.getString("UndoRefactoringAction.extendedLabel").length();
        IUndoManager undoManager = Refactoring.getUndoManager();
        if (undoManager.anythingToUndo()) {
            if (undoManager.peekUndoName() != null) {
                action.setText(this.getActionText());
            }
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    private String getActionText() {
        return this.shortenText(RefactoringMessages.getFormattedString("UndoRefactoringAction.extendedLabel", Refactoring.getUndoManager().peekUndoName()), this.fPatternLength);
    }
}

