/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards;

import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

public abstract class AbstractWizardDropDownAction
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    protected static final IAction[] NO_ACTIONS = new IAction[0];
    private Menu fMenu = null;
    private IAction[] fActions = null;
    private IRegistryChangeListener fListener;
    private Object fLock = new Object();

    public AbstractWizardDropDownAction() {
        this.setMenuCreator(this);
        this.fListener = new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                AbstractWizardDropDownAction.this.refreshActions();
            }
        };
        Platform.getExtensionRegistry().addRegistryChangeListener(this.fListener);
    }

    public void refreshActions() {
        Menu oldMenu = null;
        Object object = this.fLock;
        synchronized (object) {
            oldMenu = this.fMenu;
            this.fActions = null;
            this.fMenu = null;
        }
        if (oldMenu != null) {
            oldMenu.dispose();
        }
    }

    public void dispose() {
        if (this.fListener != null) {
            Platform.getExtensionRegistry().removeRegistryChangeListener(this.fListener);
            this.fListener = null;
        }
        this.refreshActions();
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fMenu == null) {
                this.fMenu = new Menu(parent);
                IAction[] actions = this.getActions();
                int i = 0;
                while (i < actions.length) {
                    ActionContributionItem item = new ActionContributionItem(actions[i]);
                    item.fill(this.fMenu, -1);
                    ++i;
                }
            }
            return this.fMenu;
        }
    }

    public void run() {
        IAction action = this.getDefaultAction();
        if (action != null) {
            action.run();
        }
    }

    public IAction getDefaultAction() {
        IAction[] actions = this.getActions();
        if (actions.length > 0) {
            actions[0].getId();
            return actions[0];
        }
        return null;
    }

    private IAction[] getActions() {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fActions == null) {
                this.fActions = this.getWizardActions();
                if (this.fActions == null) {
                    this.fActions = NO_ACTIONS;
                }
            }
            return this.fActions;
        }
    }

    protected abstract IAction[] getWizardActions();

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

