/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.math.BigInteger;
import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CExtendedMemoryBlock;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CThread;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlock;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlockRetrieval;

public class CExtendedMemoryBlockRetrieval
implements IExtendedMemoryBlockRetrieval {
    public IExtendedMemoryBlock getExtendedMemoryBlock(String expression, IDebugElement selected) throws DebugException {
        IStackFrame frame;
        String address = null;
        if (selected instanceof CStackFrame) {
            address = ((CStackFrame)selected).evaluateExpressionToString(expression);
        } else if (selected instanceof CThread && (frame = ((CThread)selected).getTopStackFrame()) instanceof CStackFrame) {
            address = ((CStackFrame)selected).evaluateExpressionToString(expression);
        }
        IDebugTarget target = selected.getDebugTarget();
        if (target instanceof CDebugTarget && address != null) {
            try {
                BigInteger a = address.startsWith("0x") ? new BigInteger(address.substring(2), 16) : new BigInteger(address);
                return new CExtendedMemoryBlock((CDebugTarget)target, expression, a);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DebugException((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 5012, MessageFormat.format(InternalDebugCoreMessages.getString("CExtendedMemoryBlockRetrieval.0"), expression, address), null));
            }
        }
        return null;
    }

    public String getPaddedString() {
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return true;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }
}

