/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableDescriptor;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CVariable;

public class CGlobalVariable
extends CVariable
implements ICGlobalVariable {
    private IGlobalVariableDescriptor fDescriptor;

    protected CGlobalVariable(CDebugElement parent, IGlobalVariableDescriptor descriptor, ICDIVariableDescriptor cdiVariableObject) {
        super(parent, cdiVariableObject);
        this.fDescriptor = descriptor;
    }

    protected CGlobalVariable(CDebugElement parent, IGlobalVariableDescriptor descriptor, ICDIVariableDescriptor cdiVariableObject, String message) {
        super(parent, cdiVariableObject, message);
        this.fDescriptor = descriptor;
    }

    public boolean canEnableDisable() {
        return true;
    }

    public void handleDebugEvents(ICDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ICDIObject source;
            ICDIEvent event = events[i];
            if (event instanceof ICDIResumedEvent && (source = event.getSource()) != null) {
                ICDITarget cdiTarget = source.getTarget();
                if (this.getCDITarget().equals(cdiTarget)) {
                    this.setChanged(false);
                }
            }
            ++i;
        }
        super.handleDebugEvents(events);
    }

    public IGlobalVariableDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public void dispose() {
        this.internalDispose(true);
    }
}

