/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.ui.propertypages.CBreakpointPreferenceStore;
import org.eclipse.cdt.debug.internal.ui.propertypages.PropertyPageMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class CBreakpointPropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    private BooleanFieldEditor fEnabled;
    private BreakpointStringFieldEditor fCondition;
    private Text fIgnoreCountTextControl;
    private BreakpointIntegerFieldEditor fIgnoreCount;
    private IAdaptable fElement;
    private CBreakpointPreferenceStore fCBreakpointPreferenceStore;

    public CBreakpointPropertyPage() {
        super(1);
        this.noDefaultAndApplyButton();
        this.fCBreakpointPreferenceStore = new CBreakpointPreferenceStore();
    }

    protected void createFieldEditors() {
        ICBreakpoint breakpoint = this.getBreakpoint();
        this.createTypeSpecificLabelFieldEditors(breakpoint);
        this.createEnabledField(this.getFieldEditorParent());
        IPreferenceStore store = this.getPreferenceStore();
        try {
            String condition = breakpoint.getCondition();
            if (condition == null) {
                condition = "";
            }
            store.setValue("CONDITION", condition);
            this.createConditionEditor(this.getFieldEditorParent());
            store.setValue("ENABLED", breakpoint.isEnabled());
            int ignoreCount = breakpoint.getIgnoreCount();
            store.setValue("IGNORE_COUNT", ignoreCount >= 0 ? ignoreCount : 0);
            this.createIgnoreCountEditor(this.getFieldEditorParent());
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
    }

    private void createTypeSpecificLabelFieldEditors(ICBreakpoint breakpoint) {
        if (breakpoint instanceof ICFunctionBreakpoint) {
            ICFunctionBreakpoint fbrkpt = (ICFunctionBreakpoint)breakpoint;
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.18"), PropertyPageMessages.getString("CBreakpointPropertyPage.3")));
            String function = PropertyPageMessages.getString("CBreakpointPropertyPage.1");
            try {
                function = fbrkpt.getFunction();
            }
            catch (CoreException coreException) {
            }
            catch (NumberFormatException numberFormatException) {}
            if (function != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.2"), function));
            }
        } else if (breakpoint instanceof ICAddressBreakpoint) {
            ICAddressBreakpoint abrkpt = (ICAddressBreakpoint)breakpoint;
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.18"), PropertyPageMessages.getString("CBreakpointPropertyPage.6")));
            String address = PropertyPageMessages.getString("CBreakpointPropertyPage.4");
            try {
                address = abrkpt.getAddress();
            }
            catch (CoreException coreException) {}
            if (address != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.5"), address));
            }
        } else if (breakpoint instanceof ILineBreakpoint) {
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.18"), PropertyPageMessages.getString("CBreakpointPropertyPage.8")));
            String fileName = null;
            try {
                fileName = breakpoint.getSourceHandle();
            }
            catch (CoreException coreException) {}
            if (fileName != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.7"), fileName));
            }
            ILineBreakpoint lBreakpoint = (ILineBreakpoint)breakpoint;
            StringBuffer lineNumber = new StringBuffer(4);
            try {
                int lNumber = lBreakpoint.getLineNumber();
                if (lNumber > 0) {
                    lineNumber.append(lNumber);
                }
            }
            catch (CoreException ce) {
                CDebugUIPlugin.log(ce);
            }
            if (lineNumber.length() > 0) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.9"), lineNumber.toString()));
            }
        } else if (breakpoint instanceof ICWatchpoint) {
            ICWatchpoint watchpoint = (ICWatchpoint)breakpoint;
            String type = "";
            String expression = "";
            try {
                type = watchpoint.isReadType() && !watchpoint.isWriteType() ? PropertyPageMessages.getString("CBreakpointPropertyPage.11") : (!watchpoint.isReadType() && watchpoint.isWriteType() ? PropertyPageMessages.getString("CBreakpointPropertyPage.12") : PropertyPageMessages.getString("CBreakpointPropertyPage.13"));
                expression = watchpoint.getExpression();
            }
            catch (CoreException ce) {
                CDebugUIPlugin.log(ce);
            }
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.18"), type));
            String projectName = breakpoint.getMarker().getResource().getLocation().toOSString();
            if (projectName != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.10"), projectName));
            }
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.14"), expression));
        }
    }

    protected void createEnabledField(Composite parent) {
        this.fEnabled = new BooleanFieldEditor("ENABLED", PropertyPageMessages.getString("CBreakpointPropertyPage.19"), parent);
        this.addField((FieldEditor)this.fEnabled);
    }

    protected void createConditionEditor(Composite parent) {
        this.fCondition = new BreakpointStringFieldEditor("CONDITION", PropertyPageMessages.getString("CBreakpointPropertyPage.15"), parent);
        this.fCondition.setEmptyStringAllowed(true);
        this.fCondition.setErrorMessage(PropertyPageMessages.getString("CBreakpointPropertyPage.16"));
        this.addField((FieldEditor)this.fCondition);
    }

    protected void createIgnoreCountEditor(Composite parent) {
        this.fIgnoreCount = new BreakpointIntegerFieldEditor("IGNORE_COUNT", PropertyPageMessages.getString("CBreakpointPropertyPage.17"), parent);
        this.fIgnoreCount.setValidRange(0, Integer.MAX_VALUE);
        this.fIgnoreCountTextControl = this.fIgnoreCount.getTextControl(parent);
        try {
            this.fIgnoreCountTextControl.setEnabled(this.getBreakpoint().getIgnoreCount() >= 0);
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
        this.addField((FieldEditor)this.fIgnoreCount);
    }

    protected FieldEditor createLabelEditor(Composite parent, String title, String value) {
        return new LabelFieldEditor(parent, title, value);
    }

    protected ICBreakpoint getBreakpoint() {
        IAdaptable element = this.getElement();
        return element instanceof ICBreakpoint ? (ICBreakpoint)element : null;
    }

    public IAdaptable getElement() {
        return this.fElement;
    }

    public void setElement(IAdaptable element) {
        this.fElement = element;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fCBreakpointPreferenceStore;
    }

    public boolean performOk() {
        final ArrayList changedProperties = new ArrayList(5);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                changedProperties.add(event.getProperty());
            }
        });
        boolean result = super.performOk();
        this.setBreakpointProperties(changedProperties);
        return result;
    }

    protected void setBreakpointProperties(final List changedProperties) {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ICBreakpoint breakpoint = CBreakpointPropertyPage.this.getBreakpoint();
                Iterator changed = changedProperties.iterator();
                while (changed.hasNext()) {
                    String property = (String)changed.next();
                    if (property.equals("ENABLED")) {
                        breakpoint.setEnabled(CBreakpointPropertyPage.this.getPreferenceStore().getBoolean("ENABLED"));
                        continue;
                    }
                    if (property.equals("IGNORE_COUNT")) {
                        breakpoint.setIgnoreCount(CBreakpointPropertyPage.this.getPreferenceStore().getInt("IGNORE_COUNT"));
                        continue;
                    }
                    if (!property.equals("CONDITION")) continue;
                    breakpoint.setCondition(CBreakpointPropertyPage.this.getPreferenceStore().getString("CONDITION"));
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
    }

    class BreakpointIntegerFieldEditor
    extends IntegerFieldEditor {
        public BreakpointIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setErrorMessage(PropertyPageMessages.getString("CBreakpointPropertyPage.0"));
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void clearErrorMessage() {
            if (this.getPreferencePage() != null) {
                String message = this.getPreferencePage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class BreakpointStringFieldEditor
    extends StringFieldEditor {
        public BreakpointStringFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (this.getPreferencePage() != null) {
                String message = this.getPreferencePage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class LabelFieldEditor
    extends FieldEditor {
        private Label fTitleLabel;
        private Label fValueLabel;
        private Composite fBasicComposite;
        private String fValue;
        private String fTitle;

        public LabelFieldEditor(Composite parent, String title, String value) {
            this.fValue = value;
            this.fTitle = title;
            this.createControl(parent);
        }

        protected void adjustForNumColumns(int numColumns) {
            ((GridData)this.fBasicComposite.getLayoutData()).horizontalSpan = numColumns;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.fBasicComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.numColumns = 2;
            this.fBasicComposite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.horizontalAlignment = 4;
            this.fBasicComposite.setLayoutData((Object)data);
            this.fTitleLabel = new Label(this.fBasicComposite, 0);
            this.fTitleLabel.setText(this.fTitle);
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            this.fTitleLabel.setLayoutData((Object)gd);
            this.fValueLabel = new Label(this.fBasicComposite, 64);
            this.fValueLabel.setText(this.fValue);
            gd = new GridData();
            this.fValueLabel.setLayoutData((Object)gd);
        }

        public int getNumberOfControls() {
            return 1;
        }

        protected void doLoad() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }
    }
}

