/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ICFileTypeResolver;
import org.eclipse.cdt.core.filetype.IResolverModel;
import org.eclipse.cdt.core.filetype.ResolverChangeEvent;
import org.eclipse.cdt.core.filetype.ResolverDelta;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.internal.core.model.CContainerInfo;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ResolverProcessor {
    CModelManager fManager;
    CElementDelta fCurrentDelta;

    public void processResolverChanges(ResolverChangeEvent event) {
        CModel root = CModelManager.getDefault().getCModel();
        this.fCurrentDelta = new CElementDelta(root);
        this.fManager = CModelManager.getDefault();
        ResolverDelta[] deltas = event.getDeltas();
        ICElement[] celements = this.getAffectedElements(event.getResolver());
        int k = 0;
        while (k < celements.length) {
            ICElement celement = celements[k];
            int i = 0;
            while (i < deltas.length) {
                ICFileTypeAssociation association;
                ResolverDelta delta = deltas[i];
                if (delta.getElementType() == 4 && (association = (ICFileTypeAssociation)delta.getElement()).getType().isTranslationUnit()) {
                    try {
                        switch (delta.getEventType()) {
                            case 16: {
                                this.add(celement, association);
                                break;
                            }
                            case 32: {
                                this.remove(celement, association);
                            }
                        }
                    }
                    catch (CModelException cModelException) {}
                }
                ++i;
            }
            ++k;
        }
        if (this.fCurrentDelta.getAffectedChildren().length > 0) {
            this.fManager.fire(this.fCurrentDelta, 1);
        }
    }

    void add(ICElement celement, ICFileTypeAssociation association) throws CModelException {
        CElementInfo info;
        int type;
        if (celement instanceof IOpenable && (type = celement.getElementType()) < 60 && (info = (CElementInfo)this.fManager.peekAtInfo(celement)) != null) {
            try {
                IResource resource = celement.getResource();
                IResource[] members = null;
                if (resource instanceof IContainer) {
                    members = ((IContainer)resource).members();
                }
                if (members != null) {
                    int i = 0;
                    while (i < members.length) {
                        ICElement newElement;
                        IFile file;
                        if (members[i] instanceof IFile && association.matches((file = (IFile)members[i]).getName()) && (newElement = CoreModel.getDefault().create(file)) != null) {
                            this.elementAdded(newElement, celement);
                        }
                        ++i;
                    }
                    ICElement[] celements = info.getChildren();
                    int i2 = 0;
                    while (i2 < celements.length) {
                        this.add(celements[i2], association);
                        ++i2;
                    }
                }
            }
            catch (CoreException coreException) {}
        }
    }

    void remove(ICElement celement, ICFileTypeAssociation association) throws CModelException {
        CElementInfo cinfo;
        int type;
        if (celement instanceof IOpenable && (type = celement.getElementType()) < 60 && (cinfo = (CElementInfo)this.fManager.peekAtInfo(celement)) != null) {
            ICElement[] celements = cinfo.getChildren();
            int i = 0;
            while (i < celements.length) {
                if (celements[i].getElementType() == 60) {
                    if (association.matches(celements[i].getElementName())) {
                        this.elementRemoved(celements[i], celement);
                    }
                } else {
                    this.remove(celements[i], association);
                }
                ++i;
            }
        }
    }

    private void nonCResourcesChanged(ICElement parent) {
        if (parent instanceof Openable && ((Openable)parent).isOpen()) {
            try {
                CElementInfo info = ((Openable)parent).getElementInfo();
                switch (parent.getElementType()) {
                    case 10: {
                        ((CModelInfo)info).setNonCResources(null);
                        return;
                    }
                    case 11: {
                        ((CProjectInfo)info).setNonCResources(null);
                        break;
                    }
                    case 12: {
                        ICProject cproject;
                        CProjectInfo pinfo;
                        ((CContainerInfo)info).setNonCResources(null);
                        if (!(parent instanceof ISourceRoot) || !(parent.getResource() instanceof IProject) || (pinfo = (CProjectInfo)this.fManager.peekAtInfo(cproject = parent.getCProject())) == null) break;
                        pinfo.setNonCResources(null);
                    }
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    private void elementAdded(ICElement celement, ICElement parent) throws CModelException {
        if (celement instanceof Openable) {
            this.addToParentInfo((Openable)celement);
        }
        this.fCurrentDelta.added(celement);
        this.nonCResourcesChanged(parent);
    }

    private void addToParentInfo(Openable child) throws CModelException {
        CElementInfo info;
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen() && !(info = parent.getElementInfo()).includesChild(child)) {
            info.addChild(child);
        }
    }

    private void elementRemoved(ICElement celement, ICElement parent) throws CModelException {
        this.fCurrentDelta.removed(celement);
        this.nonCResourcesChanged(parent);
        this.removeFromParentInfo(celement);
        this.fManager.releaseCElement(celement);
    }

    private void removeFromParentInfo(ICElement child) throws CModelException {
        ICElement parent = child.getParent();
        if (parent != null && parent instanceof Parent && this.fManager.peekAtInfo(parent) != null) {
            ((Parent)parent).removeChild(child);
        }
    }

    private ICElement[] getAffectedElements(ICFileTypeResolver resolver) {
        try {
            IResolverModel rmodel = CCorePlugin.getDefault().getResolverModel();
            ICModel cmodel = CoreModel.getDefault().getCModel();
            ICProject[] cprojects = cmodel.getCProjects();
            IContainer container = resolver.getContainer();
            if (container instanceof IProject || container instanceof IFolder) {
                IProject project = container.getProject();
                int i = 0;
                while (i < cprojects.length) {
                    if (project.equals((Object)cprojects[i].getProject())) {
                        return new ICElement[]{cprojects[i]};
                    }
                    ++i;
                }
                return CElement.NO_ELEMENTS;
            }
            ArrayList<ICProject> list = new ArrayList<ICProject>(cprojects.length);
            int i = 0;
            while (i < cprojects.length) {
                if (!rmodel.hasCustomResolver(cprojects[i].getProject())) {
                    list.add(cprojects[i]);
                }
                ++i;
            }
            return list.toArray(new ICElement[list.size()]);
        }
        catch (CModelException cModelException) {
            return CElement.NO_ELEMENTS;
        }
    }
}

