/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.MoveProjectAction;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class CViewMoveAction
extends MoveResourceAction {
    private StructuredViewer viewer;
    private MoveProjectAction moveProjectAction;

    public CViewMoveAction(Shell shell, StructuredViewer structureViewer) {
        super(shell);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.move_action_context");
        this.viewer = structureViewer;
        this.moveProjectAction = new MoveProjectAction(shell);
    }

    public void run() {
        if (this.moveProjectAction.isEnabled()) {
            this.moveProjectAction.run();
            return;
        }
        super.run();
        List destinations = this.getDestinations();
        if (destinations != null && !destinations.isEmpty()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            ArrayList<IResource> resources = new ArrayList<IResource>();
            Iterator iterator = destinations.iterator();
            while (iterator.hasNext()) {
                IResource newResource = root.findMember((IPath)iterator.next());
                if (newResource == null) continue;
                resources.add(newResource);
            }
            this.viewer.setSelection((ISelection)new StructuredSelection(resources), true);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.moveProjectAction.selectionChanged(selection);
        return super.updateSelection(selection) || this.moveProjectAction.isEnabled();
    }
}

