/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Iterator;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateFactory;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.StandardSymbolExtension;

public class ASTTemplateInstantiation
extends ASTSymbol
implements IASTTemplateInstantiation {
    private ITemplateFactory factory;
    private IASTScope ownerScope;
    private IASTTemplateDeclaration instantiatedTemplate;
    private ISymbol instance;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTTemplateInstantiation(IASTScope scope, char[] filename) {
        super(null);
        IContainerSymbol container = ((ASTScope)scope).getContainerSymbol();
        this.factory = container.getSymbolTable().newTemplateFactory();
        this.factory.setContainingSymbol(container);
        this.factory.setASTExtension(new StandardSymbolExtension(this.factory, this));
        this.factory.pushTemplate(null);
        this.ownerScope = scope;
        this.fn = filename;
    }

    public IASTTemplateDeclaration getInstantiatedTemplate() {
        return this.instantiatedTemplate;
    }

    public void releaseFactory() {
        this.factory = null;
    }

    public void setInstanceSymbol(ISymbol sym) {
        this.instance = sym;
        ITemplateSymbol template = (ITemplateSymbol)this.instance.getInstantiatedSymbol().getContainingSymbol();
        this.instantiatedTemplate = (IASTTemplateDeclaration)((Object)template.getASTExtension().getPrimaryDeclaration());
        this.setSymbol(this.instance.getInstantiatedSymbol().getContainingSymbol());
    }

    public ISymbol getInstanceSymbol() {
        return this.instance;
    }

    public IContainerSymbol getContainerSymbol() {
        return this.factory != null ? this.factory : ((ASTTemplateDeclaration)this.getInstantiatedTemplate()).getContainerSymbol();
    }

    public IASTDeclaration getOwnedDeclaration() {
        return null;
    }

    public void setOwnedDeclaration(IASTDeclaration declaration) {
    }

    public IASTScope getOwnerScope() {
        return this.ownerScope;
    }

    public void acceptElement(ISourceElementRequestor requestor) {
    }

    public void enterScope(ISourceElementRequestor requestor) {
        try {
            requestor.enterTemplateInstantiation(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor requestor) {
        try {
            requestor.exitTemplateExplicitInstantiation(this);
        }
        catch (Exception exception) {}
    }

    public Iterator getDeclarations() throws ASTNotImplementedException {
        return null;
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public final void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }
}

