/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDICharType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIDerivedType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFloatingPointType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIIntegralType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIPointerType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIReferenceType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIStructType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.core.model.ICType;

public class CType
implements ICType {
    private ICDIType fCDIType;

    public CType(ICDIType cdiType) {
        this.setCDIType(cdiType);
    }

    public String getName() {
        return this.fCDIType != null ? this.fCDIType.getTypeName() : null;
    }

    public void dispose() {
        this.fCDIType = null;
    }

    public int[] getArrayDimensions() {
        int length = 0;
        ICDIType type = this.getCDIType();
        while (type instanceof ICDIArrayType) {
            ++length;
            ICDIType iCDIType = type = type instanceof ICDIDerivedType ? ((ICDIDerivedType)type).getComponentType() : null;
        }
        int[] dims = new int[length];
        type = this.getCDIType();
        int i = 0;
        while (i < length) {
            dims[i] = ((ICDIArrayType)type).getDimension();
            type = ((ICDIDerivedType)type).getComponentType();
            ++i;
        }
        return dims;
    }

    public boolean isArray() {
        return this.getCDIType() instanceof ICDIArrayType;
    }

    public boolean isCharacter() {
        return this.getCDIType() instanceof ICDICharType;
    }

    public boolean isFloatingPointType() {
        return this.getCDIType() instanceof ICDIFloatingPointType;
    }

    public boolean isPointer() {
        return this.getCDIType() instanceof ICDIPointerType;
    }

    public boolean isReference() {
        return this.getCDIType() instanceof ICDIReferenceType;
    }

    public boolean isStructure() {
        return this.getCDIType() instanceof ICDIStructType;
    }

    public boolean isUnsigned() {
        ICDIType cdiType = this.getCDIType();
        return cdiType instanceof ICDIIntegralType ? ((ICDIIntegralType)cdiType).isUnsigned() : false;
    }

    protected ICDIType getCDIType() {
        return this.fCDIType;
    }

    protected void setCDIType(ICDIType type) {
        this.fCDIType = type;
    }

    protected boolean isAggregate() {
        return this.isArray() || this.isStructure() || this.isPointer() || this.isReference();
    }
}

